/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.tooling.model.Strings;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

@CommandLine.Command(name="processor", description={"Get status of Camel processors"}, sortOptions=false, showDefaultValues=true)
public class CamelProcessorStatus
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameCompletionCandidates.class, description={"Sort by pid or name"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--remote"}, description={"Break down counters into remote/total pairs"})
    boolean remote;
    @CommandLine.Option(names={"--source"}, description={"Prefer to display source filename/code instead of IDs"})
    boolean source;
    @CommandLine.Option(names={"--limit"}, description={"Filter routes by limiting to the given number of rows"})
    int limit;
    @CommandLine.Option(names={"--filter-mean"}, description={"Filter processors that must be slower than the given time (ms)"})
    long mean;
    @CommandLine.Option(names={"--running"}, description={"Only include running processors"})
    boolean running;
    @CommandLine.Option(names={"--filter"}, description={"Filter processors by id"})
    String[] filter;
    @CommandLine.Option(names={"--group"}, description={"Filter processors by group"})
    String[] group;
    @CommandLine.Option(names={"--description"}, description={"Include description in the ID column (if available)"})
    boolean description;
    @CommandLine.Option(names={"--show-group"}, description={"Include group column"})
    boolean showGroup;

    public CamelProcessorStatus(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                JsonArray array = (JsonArray)root.get((Object)"routes");
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject o = (JsonObject)array.get(i);
                    Row row = new Row();
                    row.name = context.getString("name");
                    if ("CamelJBang".equals(row.name)) {
                        row.name = ProcessHelper.extractName(root, ph);
                    }
                    row.pid = Long.toString(ph.pid());
                    row.routeId = o.getString("routeId");
                    row.group = o.getString("group");
                    row.description = o.getString("description");
                    row.nodePrefixId = o.getString("nodePrefixId");
                    row.processor = o.getString("from");
                    row.source = o.getString("source");
                    row.state = o.getString("state");
                    Map stats = o.getMap("statistics");
                    if (stats != null) {
                        long time;
                        row.total = stats.get("exchangesTotal").toString();
                        Object num = stats.get("remoteExchangesTotal");
                        if (num != null) {
                            row.totalRemote = num.toString();
                        }
                        row.inflight = stats.get("exchangesInflight").toString();
                        num = stats.get("remoteExchangesInflight");
                        if (num != null) {
                            row.inflightRemote = num.toString();
                        }
                        row.failed = stats.get("exchangesFailed").toString();
                        num = stats.get("remoteExchangesFailed");
                        if (num != null) {
                            row.failedRemote = num.toString();
                        }
                        row.mean = stats.get("meanProcessingTime").toString();
                        if ("-1".equals(row.mean)) {
                            row.mean = null;
                        }
                        row.max = stats.get("maxProcessingTime").toString();
                        row.min = stats.get("minProcessingTime").toString();
                        Object last = stats.get("lastProcessingTime");
                        if (last != null) {
                            row.last = last.toString();
                        }
                        if ((last = stats.get("deltaProcessingTime")) != null) {
                            row.delta = last.toString();
                        }
                        if ((last = stats.get("lastCreatedExchangeTimestamp")) != null) {
                            time = Long.parseLong(last.toString());
                            row.sinceLastStarted = TimeUtils.printSince((long)time);
                        }
                        if ((last = stats.get("lastCompletedExchangeTimestamp")) != null) {
                            time = Long.parseLong(last.toString());
                            row.sinceLastCompleted = TimeUtils.printSince((long)time);
                        }
                        if ((last = stats.get("lastFailedExchangeTimestamp")) != null) {
                            time = Long.parseLong(last.toString());
                            row.sinceLastFailed = TimeUtils.printSince((long)time);
                        }
                    }
                    boolean add = true;
                    if (this.mean > 0L && (row.mean == null || Long.parseLong(row.mean) < this.mean)) {
                        add = false;
                    }
                    if (this.limit > 0 && rows.size() >= this.limit) {
                        add = false;
                    }
                    if (!add) continue;
                    rows.add(row);
                    List list = (List)o.getCollection("processors");
                    if (list == null) continue;
                    this.addProcessors(row, rows, list);
                }
            }
        });
        if (this.running || this.filter != null || this.group != null) {
            rows.removeIf(r -> {
                boolean keep = true;
                if (this.filter != null) {
                    keep = PatternHelper.matchPatterns((String)r.processorId, (String[])this.filter);
                }
                if (!keep && this.filter != null) {
                    for (String f : this.filter) {
                        if (keep) continue;
                        Object w = f.endsWith("*") ? f : f + "*";
                        keep = PatternHelper.matchPattern((String)r.processor, (String)w);
                    }
                }
                if (keep && this.group != null) {
                    keep = PatternHelper.matchPatterns((String)r.group, (String[])this.group);
                }
                if (keep && this.running) {
                    keep = "Started".equals(r.state);
                }
                return !keep;
            });
        }
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printTable(rows);
        }
        return 0;
    }

    private void addProcessors(Row route, List<Row> rows, List<JsonObject> processors) {
        for (JsonObject o : processors) {
            List lines;
            Row row = new Row();
            row.pid = route.pid;
            row.name = route.name;
            row.routeId = route.routeId;
            row.group = route.group;
            rows.add(row);
            row.processorId = o.getString("id");
            row.nodePrefixId = o.getString("nodePrefixId");
            row.processor = o.getString("processor");
            row.description = o.getString("description");
            row.level = o.getIntegerOrDefault("level", 0);
            row.source = o.getString("source");
            row.state = o.getString("state");
            row.disabled = o.getBooleanOrDefault("disabled", false);
            Map stats = o.getMap("statistics");
            if (stats != null) {
                long time;
                row.total = stats.get("exchangesTotal").toString();
                row.inflight = stats.get("exchangesInflight").toString();
                row.failed = stats.get("exchangesFailed").toString();
                row.mean = stats.get("meanProcessingTime").toString();
                if ("-1".equals(row.mean)) {
                    row.mean = null;
                }
                row.max = stats.get("maxProcessingTime").toString();
                row.min = stats.get("minProcessingTime").toString();
                Object last = stats.get("lastProcessingTime");
                if (last != null) {
                    row.last = last.toString();
                }
                if ((last = stats.get("deltaProcessingTime")) != null) {
                    row.delta = last.toString();
                }
                if ((last = stats.get("lastCompletedExchangeTimestamp")) != null) {
                    time = Long.parseLong(last.toString());
                    row.sinceLastCompleted = TimeUtils.printSince((long)time);
                }
                if ((last = stats.get("lastFailedExchangeTimestamp")) != null) {
                    time = Long.parseLong(last.toString());
                    row.sinceLastFailed = TimeUtils.printSince((long)time);
                }
            }
            if (!this.source || (lines = (List)o.getCollection("code")) == null) continue;
            for (JsonObject line : lines) {
                Code code = new Code();
                code.line = line.getInteger("line");
                code.code = line.getString("code");
                if (line.getBooleanOrDefault("match", false).booleanValue()) {
                    code.match = true;
                }
                row.code.add(code);
            }
        }
    }

    protected void printTable(List<Row> rows) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(this::getPid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getName), new Column().header("GROUP").visible(this.showGroup).dataAlign(HorizontalAlign.LEFT).maxWidth(20, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getGroup), new Column().header("ID").visible(!this.description).dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getId), new Column().header("ID").visible(this.description).dataAlign(HorizontalAlign.LEFT).maxWidth(60, OverflowBehaviour.NEWLINE).with(this::getIdAndDescription), new Column().header("PROCESSOR").dataAlign(HorizontalAlign.LEFT).minWidth(25).maxWidth(45, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getProcessor), new Column().header("STATUS").dataAlign(HorizontalAlign.LEFT).headerAlign(HorizontalAlign.CENTER).with(this::getStatus), new Column().header("TOTAL").with(this::getTotal), new Column().header("FAIL").with(this::getFailed), new Column().header("INFLIGHT").with(this::getInflight), new Column().header("MEAN").with(r -> r.mean), new Column().header("MIN").with(r -> r.min), new Column().header("MAX").with(r -> r.max), new Column().header("LAST").with(r -> r.last), new Column().header("DELTA").with(this::getDelta), new Column().header("SINCE-LAST").with(this::getSinceLast))));
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    protected String getSinceLast(Row r) {
        String s1 = r.sinceLastCompleted != null ? r.sinceLastCompleted : "-";
        String s2 = r.sinceLastFailed != null ? r.sinceLastFailed : "-";
        return s1 + "/" + s2;
    }

    protected String getDelta(Row r) {
        if (r.delta != null) {
            if (r.delta.startsWith("-")) {
                return r.delta;
            }
            if (!"0".equals(r.delta)) {
                return "+" + r.delta;
            }
        }
        return r.delta;
    }

    protected String getTotal(Row r) {
        if (this.remote && r.totalRemote != null) {
            return r.totalRemote + "/" + r.total;
        }
        return r.total;
    }

    protected String getFailed(Row r) {
        if (this.remote && r.failedRemote != null) {
            return r.failedRemote + "/" + r.failed;
        }
        return r.failed;
    }

    protected String getInflight(Row r) {
        if (this.remote && r.inflightRemote != null) {
            return r.inflightRemote + "/" + r.inflight;
        }
        return r.inflight;
    }

    protected String getName(Row r) {
        return r.processorId == null ? r.name : "";
    }

    protected String getGroup(Row r) {
        return r.group;
    }

    protected String getId(Row r) {
        String answer;
        if (this.source && r.source != null) {
            answer = this.sourceLocLine(r.source);
        } else if (r.processorId == null) {
            answer = r.routeId;
        } else {
            answer = r.processorId;
            if (r.nodePrefixId != null && answer.startsWith(r.nodePrefixId)) {
                answer = answer.substring(r.nodePrefixId.length());
            }
        }
        return answer;
    }

    protected String getIdAndDescription(Row r) {
        Object id = this.getId(r);
        if (this.description && r.description != null) {
            id = id != null ? (String)id + "\n  " + Strings.wrapWords((String)r.description, (String)" ", (String)"\n  ", (int)55, (boolean)true) : r.description;
        }
        return id;
    }

    protected String getPid(Row r) {
        if (r.processorId == null) {
            return r.pid;
        }
        return "";
    }

    protected String getStatus(Row r) {
        if (r.disabled) {
            return "Disabled";
        }
        return r.state;
    }

    protected String getProcessor(Row r) {
        String answer = r.processor;
        if (this.source) {
            answer = r.code.stream().filter(l -> l.match).findFirst().map(l -> Jsoner.unescape((String)l.code).trim()).orElse(r.processor);
        }
        String pad = StringHelper.padString((int)r.level, (int)2);
        return pad + answer;
    }

    static class Row {
        String pid;
        String name;
        long uptime;
        String routeId;
        String group;
        String nodePrefixId;
        String processorId;
        String processor;
        String description;
        int level;
        String source;
        String state;
        boolean disabled;
        String total;
        String totalRemote;
        String failed;
        String failedRemote;
        String inflight;
        String inflightRemote;
        String mean;
        String max;
        String min;
        String last;
        String delta;
        String sinceLastStarted;
        String sinceLastCompleted;
        String sinceLastFailed;
        List<Code> code = new ArrayList<Code>();

        Row() {
        }
    }

    private static class Code {
        int line;
        String code;
        boolean match;

        private Code() {
        }
    }

    public static class PidNameCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("pid", "name").iterator();
        }
    }
}

