/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="count", description={"Get total and failed exchanges"}, sortOptions=false, showDefaultValues=true)
public class CamelCount
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--total"}, description={"Get the total exchanges from a running integration"})
    boolean total;
    @CommandLine.Option(names={"--fail"}, description={"Get the failed exchanges from a running integration"})
    boolean fail;

    public CamelCount(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                row.age = TimeUtils.printSince((long)CamelCount.extractSince(ph));
                Map stats = context.getMap("statistics");
                if (stats != null) {
                    row.total = stats.get("exchangesTotal").toString();
                    row.failed = stats.get("exchangesFailed").toString();
                }
                rows.add(row);
            }
        });
        rows.sort(this::sortRow);
        if (!this.total && !this.fail) {
            if (!rows.isEmpty()) {
                this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.age), new Column().header("TOTAL").with(r -> r.total), new Column().header("FAIL").with(r -> r.failed))));
            }
        } else {
            StringBuilder builder = new StringBuilder();
            if (!rows.isEmpty()) {
                int index = 0;
                for (Row r2 : rows) {
                    if (rows.size() > 1) {
                        builder.append(r2.name).append(",");
                    }
                    if (this.total) {
                        builder.append(r2.total);
                    }
                    if (this.fail) {
                        if (this.total) {
                            builder.append(",");
                        }
                        builder.append(r2.failed);
                    }
                    if (index < rows.size() - 1) {
                        builder.append(System.getProperty("line.separator"));
                    }
                    ++index;
                }
            }
            this.printer().println(String.valueOf(builder));
        }
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    private static class Row {
        String pid;
        String name;
        String age;
        long uptime;
        String total;
        String failed;

        private Row() {
        }
    }
}

