/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;

class AvailablePortFinder {
    AvailablePortFinder() {
    }

    static int getNextAvailable(int fromPort, int toPort) {
        return AvailablePortFinder.findPort(fromPort, toPort);
    }

    private static int findPort(int fromPort, int toPort) {
        for (int i = fromPort; i <= toPort; ++i) {
            try {
                return AvailablePortFinder.probePort(i);
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
        }
        throw new IllegalStateException("Cannot find free port");
    }

    private static int probePort(int port) {
        int n;
        ServerSocket ss = new ServerSocket();
        try {
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress((InetAddress)null, port), 1);
            n = ss.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot find free port", e);
            }
        }
        ss.close();
        return n;
    }
}

