/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.plugin;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.plugin.PluginBaseCommand;
import org.apache.camel.dsl.jbang.core.common.PluginType;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Display available plugins."}, sortOptions=false, showDefaultValues=true)
public class PluginGet
extends PluginBaseCommand {
    @CommandLine.Option(names={"--all"}, defaultValue="false", description={"Display all available plugins."})
    public boolean all;

    public PluginGet(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        JsonObject plugins = (JsonObject)this.loadConfig().getMap("plugins");
        plugins.forEach((key, value) -> {
            JsonObject details = (JsonObject)value;
            String name = details.getStringOrDefault("name", key);
            String command = details.getStringOrDefault("command", name);
            String dependency = details.getStringOrDefault("dependency", "org.apache.camel:camel-jbang-plugin-%s".formatted(command));
            String description = details.getStringOrDefault("description", "Plugin %s called with command %s".formatted(name, command));
            rows.add(new Row(name, command, dependency, description));
        });
        this.printRows(rows);
        if (this.all) {
            rows.clear();
            for (PluginType camelPlugin : PluginType.values()) {
                if (plugins.get((Object)camelPlugin.getName()) != null) continue;
                String dependency = "org.apache.camel:camel-jbang-plugin-%s".formatted(camelPlugin.getCommand());
                rows.add(new Row(camelPlugin.getName(), camelPlugin.getCommand(), dependency, camelPlugin.getDescription()));
            }
            if (!rows.isEmpty()) {
                this.printer().println();
                this.printer().println("Supported plugins:");
                this.printer().println();
                this.printRows(rows);
            }
        }
        return 0;
    }

    private void printRows(List<Row> rows) {
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("NAME").headerAlign(HorizontalAlign.LEFT).dataAlign(HorizontalAlign.LEFT).with(r -> r.name), new Column().header("COMMAND").headerAlign(HorizontalAlign.LEFT).dataAlign(HorizontalAlign.LEFT).with(r -> r.command), new Column().header("DEPENDENCY").headerAlign(HorizontalAlign.LEFT).dataAlign(HorizontalAlign.LEFT).with(r -> r.dependency), new Column().header("DESCRIPTION").headerAlign(HorizontalAlign.LEFT).dataAlign(HorizontalAlign.LEFT).maxWidth(50, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.description))));
        }
    }

    private record Row(String name, String command, String dependency, String description) {
    }
}

