/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import picocli.CommandLine;

@CommandLine.Command(name="stop", description={"Shuts down running external services"}, sortOptions=false, showDefaultValues=true)
public class InfraStop
extends InfraBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running service(s)"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--kill"}, description={"To force killing the process (SIGKILL)"})
    boolean kill;

    public InfraStop(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        Map<Long, Path> pids = InfraStop.findPids(this.name);
        for (Map.Entry<Long, Path> entry : pids.entrySet()) {
            Path pidFile = entry.getValue();
            if (!Files.exists(pidFile, new LinkOption[0])) continue;
            this.printer().println("Shutting down external services (PID: " + String.valueOf(entry.getKey()) + ")");
            PathUtils.deleteFile(pidFile);
        }
        if (this.kill) {
            for (Long pid : pids.keySet()) {
                ProcessHandle.of(pid).ifPresent(ph -> {
                    this.printer().println("Killing external service (PID: " + pid + ")");
                    ph.destroyForcibly();
                });
            }
        }
        return 0;
    }
}

