/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.RunHelper;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.tooling.maven.MavenArtifact;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run an external service"}, sortOptions=false, showDefaultValues=true)
public class InfraRun
extends InfraBaseCommand {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"Service name"}, arity="1")
    private List<String> serviceName;
    @CommandLine.Option(names={"--log"}, description={"Log container output to console"})
    boolean logToStdout;
    @CommandLine.Option(names={"--background"}, defaultValue="false", description={"Run in the background"})
    boolean background;

    public InfraRun(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (this.serviceName == null || this.serviceName.isEmpty()) {
            return 0;
        }
        String service = this.serviceName.get(0);
        String serviceImplementation = this.serviceName.size() > 1 ? this.serviceName.get(1) : null;
        return this.run(service, serviceImplementation);
    }

    private Integer run(String testService, String testServiceImplementation) throws Exception {
        List<InfraBaseCommand.TestInfraService> services = this.getMetadata();
        InfraBaseCommand.TestInfraService testInfraService = services.stream().filter(service -> {
            if (testServiceImplementation != null && !testServiceImplementation.isEmpty() && service.aliasImplementation() != null) {
                return service.alias().contains(testService) && service.aliasImplementation().contains(testServiceImplementation);
            }
            if (testServiceImplementation == null) {
                return service.alias().contains(testService) && (service.aliasImplementation() == null || service.aliasImplementation().isEmpty());
            }
            return false;
        }).findFirst().orElse(null);
        if (testInfraService == null) {
            String message = ", use the list command for the available services";
            if (testServiceImplementation != null) {
                this.printer().println("service " + testService + " with implementation " + testServiceImplementation + " not found" + message);
            }
            this.printer().println("service " + testService + " not found" + message);
            return 1;
        }
        if (this.background) {
            return this.runBackground(testService);
        }
        return this.doRun(testService, testServiceImplementation, testInfraService);
    }

    protected int runBackground(String testService) throws Exception {
        ArrayList<String> cmds;
        if (this.spec != null) {
            cmds = new ArrayList(this.spec.commandLine().getParseResult().originalArgs());
        } else {
            cmds = new ArrayList<String>();
            cmds.add("run");
        }
        cmds.remove("--background=true");
        cmds.remove("--background");
        RunHelper.addCamelJBangCommand(cmds);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(cmds);
        Process p = pb.start();
        this.printer().println("Running " + testService + " in background with PID: " + p.pid());
        return 0;
    }

    protected Integer doRun(String testService, String testServiceImplementation, InfraBaseCommand.TestInfraService testInfraService) throws Exception {
        Thread t;
        DependencyDownloaderClassLoader cl = InfraRun.getDependencyDownloaderClassLoader(testInfraService);
        Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        String serviceInterface = testInfraService.service();
        String serviceImpl = testInfraService.implementation();
        Object actualService = cl.loadClass(serviceImpl).newInstance();
        boolean actualServiceIsAnInfrastructureService = false;
        for (Method method : actualService.getClass().getMethods()) {
            if (!method.getName().contains("initialize")) continue;
            actualServiceIsAnInfrastructureService = true;
            break;
        }
        if (!actualServiceIsAnInfrastructureService) {
            this.printer().println("Service " + serviceImpl + " is not an InfrastructureService");
            return 1;
        }
        if (!this.jsonOutput) {
            Object prefix = "";
            if (testServiceImplementation != null) {
                prefix = " with implementation " + testServiceImplementation;
            }
            this.printer().println("Starting service " + testService + (String)prefix + " (PID: " + RuntimeUtil.getPid() + ")");
        }
        actualService.getClass().getMethod("initialize", new Class[0]).invoke(actualService, new Object[0]);
        Method[] serviceMethods = cl.loadClass(serviceInterface).getDeclaredMethods();
        TreeMap<String, Object> properties = new TreeMap<String, Object>();
        for (Method method : serviceMethods) {
            if (method.getParameterCount() != 0 || method.getName().contains("registerProperties")) continue;
            Object value = null;
            try {
                value = method.invoke(actualService, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null) continue;
            properties.put(method.getName(), value);
        }
        String jsonProperties = this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(properties);
        this.printer().println(jsonProperties);
        String name = this.getLogFileName(testService, RuntimeUtil.getPid());
        Path logFile = InfraRun.createFile(name);
        String jsonName = this.getJsonFileName(testService, RuntimeUtil.getPid());
        Path jsonFile = InfraRun.createFile(jsonName);
        Files.write(jsonFile, this.jsonMapper.writeValueAsString(properties).getBytes(), new OpenOption[0]);
        if (Arrays.stream(actualService.getClass().getInterfaces()).anyMatch(c -> c.getName().contains("ContainerService"))) {
            Object containerLogConsumer = cl.loadClass("org.apache.camel.test.infra.common.CamelLogConsumer").getConstructor(Path.class, Boolean.TYPE).newInstance(logFile, this.logToStdout);
            actualService.getClass().getMethod("followLog", cl.loadClass("org.testcontainers.containers.output.BaseConsumer")).invoke(actualService, containerLogConsumer);
        }
        AtomicBoolean closed = new AtomicBoolean();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> InfraRun.shutdownInfra(closed, logFile, jsonFile, actualService)));
        CountDownLatch latch = new CountDownLatch(1);
        Console c2 = System.console();
        if (c2 != null) {
            if (!this.jsonOutput) {
                this.printer().println("Press ENTER to stop the execution");
            }
            t = new Thread(() -> {
                boolean quit = false;
                do {
                    String line;
                    if ((line = c2.readLine()) == null) continue;
                    quit = true;
                    latch.countDown();
                } while (!quit);
            }, "WaitEnter");
            t.start();
        } else {
            this.printer().println("Running (use camel infra stop " + testService + (String)(testServiceImplementation != null ? " " + testServiceImplementation : "") + " to stop the execution)");
        }
        t = new Thread(() -> {
            while (latch.getCount() > 0L) {
                File f;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((f = jsonFile.toFile()).exists()) continue;
                latch.countDown();
            }
        }, "WaitShutdownSignal");
        t.start();
        try {
            latch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        InfraRun.shutdownInfra(closed, logFile, jsonFile, actualService);
        return 0;
    }

    private static void shutdownInfra(AtomicBoolean closed, Path logFile, Path jsonFile, Object actualService) {
        if (closed.compareAndSet(false, true)) {
            try {
                actualService.getClass().getMethod("shutdown", new Class[0]).invoke(actualService, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Files.deleteIfExists(logFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Files.deleteIfExists(jsonFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Path createFile(String name) throws IOException {
        Path logDir = CommandLineHelper.getCamelDir();
        Files.createDirectories(logDir, new FileAttribute[0]);
        Path logFile = logDir.resolve(name);
        Files.createFile(logFile, new FileAttribute[0]);
        return logFile;
    }

    private static DependencyDownloaderClassLoader getDependencyDownloaderClassLoader(InfraBaseCommand.TestInfraService testInfraService) {
        DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(InfraRun.class.getClassLoader());
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setClassLoader((ClassLoader)cl);
        downloader.start();
        downloader.downloadDependency(testInfraService.groupId(), testInfraService.artifactId(), testInfraService.version(), true);
        MavenArtifact ma = downloader.downloadArtifact(testInfraService.groupId(), testInfraService.artifactId(), testInfraService.version());
        cl.addFile(ma.getFile());
        return cl;
    }

    public List<String> getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(List<String> serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isLogToStdout() {
        return this.logToStdout;
    }

    public void setLogToStdout(boolean logToStdout) {
        this.logToStdout = logToStdout;
    }
}

