/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import picocli.CommandLine;

@CommandLine.Command(name="ps", description={"Displays running services"}, sortOptions=false, showDefaultValues=true)
public class InfraPs
extends InfraBaseCommand {
    @CommandLine.Parameters(description={"Service name"}, arity="0..1")
    private List<String> serviceName;

    public InfraPs(CamelJBangMain main) {
        super(main);
    }

    @Override
    protected boolean showPidColumn() {
        return true;
    }

    @Override
    public Integer doCall() throws Exception {
        HashSet<String> runningAliases = new HashSet<String>();
        try {
            List<Path> pidFiles = Files.list(CommandLineHelper.getCamelDir()).filter(p -> {
                if (this.serviceName == null) {
                    return p.getFileName().toString().startsWith("infra-");
                }
                return p.getFileName().toString().startsWith("infra-" + this.serviceName.get(0));
            }).toList();
            for (Path pidFile : pidFiles) {
                String runningServiceName = pidFile.getFileName().toString().split("-")[1];
                runningAliases.add(runningServiceName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.listServices(rows -> {
            if (runningAliases.isEmpty()) {
                rows.clear();
            } else {
                rows.removeIf(row -> !runningAliases.contains(row.alias()));
            }
        });
    }
}

