/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import picocli.CommandLine;

@CommandLine.Command(name="log", description={"Displays external service logs"}, sortOptions=false, showDefaultValues=true)
public class InfraLog
extends InfraBaseCommand {
    @CommandLine.Parameters(description={"Service name"}, arity="0..2")
    private List<String> serviceName;
    private ExecutorService executorService = Executors.newFixedThreadPool(10);

    public InfraLog(CamelJBangMain main) {
        super(main);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Integer doCall() throws Exception {
        ArrayList futures = new ArrayList();
        if (this.serviceName == null || this.serviceName.isEmpty()) {
            try {
                List<Path> logFiles = Files.list(CommandLineHelper.getCamelDir()).filter(p -> {
                    String name = p.getFileName().toString();
                    return name.startsWith("infra-") && name.endsWith(".log");
                }).toList();
                for (Path logFile : logFiles) {
                    String alias = logFile.getFileName().toString().split("-")[1];
                    this.createTailer(logFile.toFile(), alias, futures);
                }
            }
            catch (IOException logFiles) {
                // empty catch block
            }
            if (futures.isEmpty()) {
                this.printer().println("There are no running services");
                return -1;
            }
        } else {
            void var3_7;
            String alias = this.serviceName.get(0);
            Object var3_5 = null;
            try {
                Path path = Files.list(CommandLineHelper.getCamelDir()).filter(p -> {
                    String name = p.getFileName().toString();
                    return name.startsWith("infra-" + alias + "-") && name.endsWith(".log");
                }).findFirst().orElse(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (var3_7 == null) {
                this.printer().println("Log not found for service " + alias);
                return -1;
            }
            this.createTailer(var3_7.toFile(), alias, futures);
        }
        for (Future future : futures) {
            while (!future.isDone()) {
                Thread.sleep(100L);
            }
        }
        return 0;
    }

    private void createTailer(File logFile, String alias, List<Future<?>> futures) {
        Tailer tailer = ((Tailer.Builder)Tailer.builder().setFile(logFile)).setTailerListener((TailerListener)new StdoutTailerListener(alias)).get();
        Thread thread = new Thread((Runnable)tailer);
        thread.setDaemon(true);
        futures.add(this.executorService.submit(thread));
    }

    class StdoutTailerListener
    implements TailerListener {
        private String suffix;
        private Tailer self;

        public StdoutTailerListener(String suffix) {
            this.suffix = suffix;
        }

        public void fileNotFound() {
        }

        public void fileRotated() {
        }

        public void handle(Exception ex) {
            InfraLog.this.printer().println("The service " + this.suffix + " was stopped");
            this.self.close();
            Thread.currentThread().interrupt();
        }

        public void handle(String line) {
            InfraLog.this.printer().println("[" + this.suffix + "] " + line);
        }

        public void init(Tailer tailer) {
            this.self = tailer;
            try {
                String line;
                StringBuilder sb = new StringBuilder();
                int linesToRead = 50;
                ReversedLinesFileReader fileReader = new ReversedLinesFileReader(tailer.getFile());
                for (int i = 0; i < linesToRead && (line = fileReader.readLine()) != null; ++i) {
                    sb.insert(0, "[" + this.suffix + "] " + line);
                }
                InfraLog.this.printer().println(sb.toString());
            }
            catch (IOException e) {
                InfraLog.this.printer().println("Error collecting logs");
                InfraLog.this.printer().printErr(e);
            }
        }
    }
}

