/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Displays running service(s) information"}, sortOptions=false, showDefaultValues=true)
public class InfraGet
extends InfraBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running service(s)"}, arity="0..1")
    String name = "*";

    public InfraGet(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        Map<Long, Path> pids = InfraGet.findPids(this.name);
        int i = 0;
        for (Map.Entry<Long, Path> e : pids.entrySet()) {
            Path pidFile = e.getValue();
            String fn = pidFile.getFileName().toString();
            String sn = fn.substring(fn.indexOf("-") + 1, fn.lastIndexOf(45));
            if (i > 0) {
                this.printer().println("");
            }
            this.printer().println("Service " + sn + " (PID: " + String.valueOf(e.getKey()) + ")");
            this.printer().println(Files.readString(pidFile));
            ++i;
        }
        return 0;
    }
}

