/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.json.DeserializationException;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

public abstract class InfraBaseCommand
extends CamelCommand {
    protected final ObjectMapper jsonMapper = new ObjectMapper();
    @CommandLine.Option(names={"--json"}, description={"Output in JSON Format"})
    boolean jsonOutput;

    public InfraBaseCommand(CamelJBangMain main) {
        super(main);
        this.jsonMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.jsonMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.jsonMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        this.jsonMapper.configure(MapperFeature.REQUIRE_HANDLERS_FOR_JAVA8_OPTIONALS, false);
    }

    protected static Map<Long, Path> findPids(String name) throws Exception {
        HashMap<Long, Path> pids = new HashMap<Long, Path>();
        if (!((String)name).matches("\\d+")) {
            if (((String)name).endsWith("!")) {
                name = ((String)name).substring(0, ((String)name).length() - 1);
            } else if (!((String)name).endsWith("*")) {
                name = (String)name + "*";
            }
        }
        String pattern = name;
        List<Path> pidFiles = Files.list(CommandLineHelper.getCamelDir()).filter(p -> {
            String n = p.getFileName().toString();
            return n.startsWith("infra-") && n.endsWith(".json");
        }).toList();
        for (Path pidFile : pidFiles) {
            String fn = pidFile.getFileName().toString();
            String sn = fn.substring(fn.indexOf("-") + 1, fn.lastIndexOf(45));
            String pid = fn.substring(fn.lastIndexOf("-") + 1, fn.lastIndexOf(46));
            if (!pid.equals(pattern) && !PatternHelper.matchPattern((String)sn, (String)pattern)) continue;
            pids.put(Long.valueOf(pid), pidFile);
        }
        return pids;
    }

    protected boolean showPidColumn() {
        return false;
    }

    protected List<TestInfraService> getMetadata() throws IOException {
        List metadata;
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        try (InputStream is = catalog.loadResource("test-infra", "metadata.json");){
            String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            metadata = (List)this.jsonMapper.readValue(json, (TypeReference)new TypeReference<List<TestInfraService>>(){});
        }
        return metadata;
    }

    public int listServices(Consumer<List<Row>> serviceConsumer) throws IOException {
        LinkedHashMap<String, InfraServiceAlias> services = new LinkedHashMap<String, InfraServiceAlias>();
        List<TestInfraService> metadata = this.getMetadata();
        ArrayList<Row> rows = new ArrayList<Row>(metadata.size());
        for (TestInfraService service : metadata) {
            for (String alias : service.alias()) {
                if (!services.containsKey(alias)) {
                    services.put(alias, new InfraServiceAlias(service.description()));
                }
                if (service.aliasImplementation() == null) continue;
                ((InfraServiceAlias)services.get(alias)).getAliasImplementation().addAll(service.aliasImplementation());
            }
        }
        int width = 0;
        for (Map.Entry entry : services.entrySet()) {
            width = Math.max(width, ((String)entry.getKey()).length());
            String pid = this.findPid((String)entry.getKey());
            rows.add(new Row(pid, (String)entry.getKey(), ((InfraServiceAlias)entry.getValue()).getAliasImplementation().stream().sorted().collect(Collectors.joining(", ")), ((InfraServiceAlias)entry.getValue()).getDescription(), this.getServiceData((String)entry.getKey(), pid)));
        }
        rows.sort(Comparator.comparing(Row::alias));
        serviceConsumer.accept(rows);
        if (this.jsonOutput) {
            this.printer().println(Jsoner.serialize(rows.stream().map(row -> {
                Object serviceDataObj = null;
                try {
                    serviceDataObj = Jsoner.deserialize((String)row.serviceData());
                }
                catch (DeserializationException deserializationException) {
                    // empty catch block
                }
                return Map.of("alias", row.alias(), "aliasImplementation", row.aliasImplementation(), "description", row.description() == null ? "" : row.description(), "serviceData", serviceDataObj);
            }).collect(Collectors.toList())));
        } else {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").visible(this.showPidColumn()).headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("ALIAS").minWidth(width + 2).dataAlign(HorizontalAlign.LEFT).with(Row::alias), new Column().header("IMPLEMENTATION").maxWidth(35, OverflowBehaviour.NEWLINE).dataAlign(HorizontalAlign.LEFT).with(Row::aliasImplementation), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).with(Row::description), new Column().header("SERVICE_DATA").dataAlign(HorizontalAlign.LEFT).with(Row::serviceData))));
        }
        return 0;
    }

    private String getServiceData(String key, String pid) {
        Path jsonFilePath = CommandLineHelper.getCamelDir().resolve(this.getJsonFileName(key, pid));
        if (jsonFilePath.toFile().exists()) {
            try {
                return Files.readString(jsonFilePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private String findPid(String key) {
        Path p = CommandLineHelper.getCamelDir();
        try {
            Files.createDirectories(p, new FileAttribute[0]);
            for (String s : Objects.requireNonNull(p.toFile().list())) {
                if (!s.startsWith("infra-" + key + "-") || !s.endsWith(".json")) continue;
                return FileUtil.stripExt((String)s.split("-")[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getLogFileName(String service, String pid) {
        return String.format("infra-%s-%s.log", service, pid);
    }

    public String getJsonFileName(String service, String pid) {
        return String.format("infra-%s-%s.json", service, pid);
    }

    record TestInfraService(String service, String implementation, String description, List<String> alias, List<String> aliasImplementation, String groupId, String artifactId, String version) {
    }

    private static class InfraServiceAlias {
        private final String description;
        private final Set<String> aliasImplementation = new HashSet<String>();

        public InfraServiceAlias(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<String> getAliasImplementation() {
            return this.aliasImplementation;
        }
    }

    record Row(String pid, String alias, String aliasImplementation, String description, String serviceData) {
    }
}

