/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.exceptionhandler;

import java.io.PrintWriter;
import picocli.CommandLine;

public class MissingPluginParameterExceptionHandler
implements CommandLine.IParameterExceptionHandler {
    public int handleParseException(CommandLine.ParameterException ex, String[] args) throws Exception {
        CommandLine cmd = ex.getCommandLine();
        PrintWriter err = cmd.getErr();
        if ("DEBUG".equalsIgnoreCase(System.getProperty("picocli.trace"))) {
            err.println(cmd.getColorScheme().stackTraceText((Throwable)ex));
        }
        err.println(cmd.getColorScheme().errorText(ex.getMessage()));
        CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)ex, (PrintWriter)err);
        err.print(cmd.getHelp().fullSynopsis());
        CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
        err.printf("Try '%s --help' for more information.%n", spec.qualifiedName());
        if (ex.getMessage().startsWith("Unmatched argument at index 0")) {
            err.println(cmd.getColorScheme().errorText("Maybe a specific Camel JBang plugin must be installed? (Try camel plugin --help' for more information)"));
        }
        return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : spec.exitCodeOnInvalidInput();
    }
}

