/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.config;

import java.util.Optional;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Display user configuration value"}, sortOptions=false, showDefaultValues=true)
public class ConfigGet
extends CamelCommand {
    @CommandLine.Parameters(description={"Configuration key"}, arity="1")
    String key;
    @CommandLine.Option(names={"--global"}, description={"Use global or local configuration"})
    boolean global = true;

    public ConfigGet(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        CommandLineHelper.loadProperties(properties -> {
            Optional<Object> maybeProperty = Optional.ofNullable(properties.get(this.key));
            if (maybeProperty.isPresent()) {
                this.printer().println(String.valueOf(maybeProperty.get()));
            } else {
                this.printer().println(this.key + " key not found");
            }
        }, !this.global);
        return 0;
    }
}

