/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.catalog;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.catalog.CatalogKamelet;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletModel;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletOptionModel;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class KameletCatalogHelper {
    private KameletCatalogHelper() {
    }

    public static List<String> findKameletNames(String version) throws Exception {
        Map<String, Object> kamelets = KameletCatalogHelper.loadKamelets(version);
        return new ArrayList<String>(kamelets.keySet());
    }

    public static KameletModel createModel(Object kamelet, boolean all) throws Exception {
        KameletModel km = new KameletModel();
        km.name = KameletCatalogHelper.getName(kamelet);
        km.type = KameletCatalogHelper.getType(kamelet);
        km.supportLevel = KameletCatalogHelper.getSupportLevel(kamelet);
        km.description = KameletCatalogHelper.getDescription(kamelet);
        if (all) {
            km.dependencies = KameletCatalogHelper.getDependencies(kamelet);
            Map<String, Object> props = KameletCatalogHelper.getProperties(kamelet);
            if (props != null) {
                km.properties = new LinkedHashMap<String, KameletOptionModel>();
                for (Map.Entry<String, Object> es : props.entrySet()) {
                    KameletOptionModel om = KameletCatalogHelper.createOptionModel(es.getKey(), es.getValue());
                    km.properties.put(om.name, om);
                }
                List<String> required = KameletCatalogHelper.getRequired(kamelet);
                if (required != null && !required.isEmpty()) {
                    for (String r : required) {
                        KameletOptionModel om = km.properties.get(r);
                        if (om == null) continue;
                        om.required = true;
                    }
                }
            }
        }
        return km;
    }

    private static KameletOptionModel createOptionModel(String name, Object prop) throws Exception {
        KameletOptionModel om = new KameletOptionModel();
        om.name = name;
        om.description = KameletCatalogHelper.getPropertyDescription(prop);
        om.type = KameletCatalogHelper.getPropertyType(prop);
        om.defaultValue = KameletCatalogHelper.getPropertyDefaultValue(prop);
        om.example = KameletCatalogHelper.getPropertyExample(prop);
        om.enumValues = KameletCatalogHelper.getPropertyEnum(prop);
        return om;
    }

    private static List<String> getRequired(Object kamelet) throws Exception {
        Method m = kamelet.getClass().getMethod("getSpec", new Class[0]);
        Object spec = ObjectHelper.invokeMethod((Method)m, (Object)kamelet, (Object[])new Object[0]);
        m = spec.getClass().getMethod("getDefinition", new Class[0]);
        Object def = ObjectHelper.invokeMethod((Method)m, (Object)spec, (Object[])new Object[0]);
        m = def.getClass().getMethod("getRequired", new Class[0]);
        return (List)ObjectHelper.invokeMethod((Method)m, (Object)def, (Object[])new Object[0]);
    }

    private static String getPropertyDescription(Object prop) throws Exception {
        Method m = prop.getClass().getMethod("getDescription", new Class[0]);
        return (String)ObjectHelper.invokeMethod((Method)m, (Object)prop, (Object[])new Object[0]);
    }

    private static String getPropertyType(Object prop) throws Exception {
        Method m = prop.getClass().getMethod("getType", new Class[0]);
        return (String)ObjectHelper.invokeMethod((Method)m, (Object)prop, (Object[])new Object[0]);
    }

    private static String getPropertyExample(Object prop) throws Exception {
        Method m = prop.getClass().getMethod("getExample", new Class[0]);
        Object en = ObjectHelper.invokeMethod((Method)m, (Object)prop, (Object[])new Object[0]);
        if (en != null) {
            String t = en.toString();
            return StringHelper.removeLeadingAndEndingQuotes((String)t);
        }
        return null;
    }

    private static String getPropertyDefaultValue(Object prop) throws Exception {
        Method m = prop.getClass().getMethod("getDefault", new Class[0]);
        Object dn = ObjectHelper.invokeMethod((Method)m, (Object)prop, (Object[])new Object[0]);
        if (dn != null) {
            String t = dn.toString();
            return StringHelper.removeLeadingAndEndingQuotes((String)t);
        }
        return null;
    }

    private static List<String> getPropertyEnum(Object prop) throws Exception {
        ArrayList<String> answer = new ArrayList<String>();
        Method m = prop.getClass().getMethod("getEnum", new Class[0]);
        List list = (List)ObjectHelper.invokeMethod((Method)m, (Object)prop, (Object[])new Object[0]);
        if (list != null && !list.isEmpty()) {
            for (Object en : list) {
                String t = en.toString();
                t = StringHelper.removeLeadingAndEndingQuotes((String)t);
                answer.add(t);
            }
        }
        return answer.isEmpty() ? null : answer;
    }

    private static String getName(Object kamelet) throws Exception {
        Method m = kamelet.getClass().getMethod("getMetadata", new Class[0]);
        Object meta = ObjectHelper.invokeMethod((Method)m, (Object)kamelet, (Object[])new Object[0]);
        m = meta.getClass().getMethod("getName", new Class[0]);
        return (String)ObjectHelper.invokeMethod((Method)m, (Object)meta, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> loadKamelets(String version) throws Exception {
        ClassLoader tccLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = KameletCatalogHelper.createClassLoader();
            MavenDependencyDownloader downloader = new MavenDependencyDownloader();
            downloader.setClassLoader(cl);
            downloader.start();
            downloader.downloadDependency("org.apache.camel.kamelets", "camel-kamelets-catalog", version);
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> clazz = cl.loadClass("org.apache.camel.kamelets.catalog.KameletsCatalog");
            Object catalog = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m = clazz.getMethod("getKamelets", new Class[0]);
            Map map = (Map)ObjectHelper.invokeMethod((Method)m, catalog, (Object[])new Object[0]);
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream loadKameletYamlSchema(String name, String version) throws Exception {
        ClassLoader tccLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = KameletCatalogHelper.createClassLoader();
            MavenDependencyDownloader downloader = new MavenDependencyDownloader();
            downloader.setClassLoader(cl);
            downloader.start();
            downloader.downloadDependency("org.apache.camel.kamelets", "camel-kamelets-catalog", version);
            Thread.currentThread().setContextClassLoader(cl);
            InputStream inputStream = cl.getResourceAsStream("kamelets/" + name + ".kamelet.yaml");
            return inputStream;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccLoader);
        }
    }

    public static KameletModel loadKameletModel(String name, String version) throws Exception {
        Object k;
        Map<String, Object> kamelets = KameletCatalogHelper.loadKamelets(version);
        if (kamelets != null && (k = kamelets.get(name)) != null) {
            return KameletCatalogHelper.createModel(k, true);
        }
        return null;
    }

    private static ClassLoader createClassLoader() {
        ClassLoader parentCL = CatalogKamelet.class.getClassLoader();
        return new DependencyDownloaderClassLoader(parentCL);
    }

    private static String getType(Object kamelet) throws Exception {
        Method m = kamelet.getClass().getMethod("getMetadata", new Class[0]);
        Object meta = ObjectHelper.invokeMethod((Method)m, (Object)kamelet, (Object[])new Object[0]);
        Map labels = (Map)ObjectHelper.invokeMethod((Method)(m = meta.getClass().getMethod("getLabels", new Class[0])), (Object)meta, (Object[])new Object[0]);
        if (labels != null) {
            return (String)labels.get("camel.apache.org/kamelet.type");
        }
        return null;
    }

    private static String getSupportLevel(Object kamelet) throws Exception {
        Method m = kamelet.getClass().getMethod("getMetadata", new Class[0]);
        Object meta = ObjectHelper.invokeMethod((Method)m, (Object)kamelet, (Object[])new Object[0]);
        Map anns = (Map)ObjectHelper.invokeMethod((Method)(m = meta.getClass().getMethod("getAnnotations", new Class[0])), (Object)meta, (Object[])new Object[0]);
        if (anns != null) {
            return (String)anns.get("camel.apache.org/kamelet.support.level");
        }
        return null;
    }

    private static String getDescription(Object kamelet) throws Exception {
        Method m = kamelet.getClass().getMethod("getSpec", new Class[0]);
        Object spec = ObjectHelper.invokeMethod((Method)m, (Object)kamelet, (Object[])new Object[0]);
        m = spec.getClass().getMethod("getDefinition", new Class[0]);
        Object def = ObjectHelper.invokeMethod((Method)m, (Object)spec, (Object[])new Object[0]);
        m = def.getClass().getMethod("getDescription", new Class[0]);
        return (String)ObjectHelper.invokeMethod((Method)m, (Object)def, (Object[])new Object[0]);
    }

    private static Map<String, Object> getProperties(Object kamelet) throws Exception {
        Method m = kamelet.getClass().getMethod("getSpec", new Class[0]);
        Object spec = ObjectHelper.invokeMethod((Method)m, (Object)kamelet, (Object[])new Object[0]);
        m = spec.getClass().getMethod("getDefinition", new Class[0]);
        Object def = ObjectHelper.invokeMethod((Method)m, (Object)spec, (Object[])new Object[0]);
        m = def.getClass().getMethod("getProperties", new Class[0]);
        return (Map)ObjectHelper.invokeMethod((Method)m, (Object)def, (Object[])new Object[0]);
    }

    private static List<String> getDependencies(Object kamelet) throws Exception {
        ArrayList<String> answer = new ArrayList<String>();
        Method m = kamelet.getClass().getMethod("getSpec", new Class[0]);
        Object spec = ObjectHelper.invokeMethod((Method)m, (Object)kamelet, (Object[])new Object[0]);
        List list = (List)ObjectHelper.invokeMethod((Method)(m = spec.getClass().getMethod("getDependencies", new Class[0])), (Object)spec, (Object[])new Object[0]);
        if (list != null && !list.isEmpty()) {
            for (Object en : list) {
                String t = en.toString();
                t = StringHelper.removeLeadingAndEndingQuotes((String)t);
                answer.add(t);
            }
        }
        return answer.isEmpty() ? null : answer;
    }
}

