/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.catalog;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.catalog.CatalogBaseCommand;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.TransformerModel;
import picocli.CommandLine;

@CommandLine.Command(name="transformer", description={"List data type transformers from the Camel Catalog"}, sortOptions=false, showDefaultValues=true)
public class CatalogTransformer
extends CatalogBaseCommand {
    public CatalogTransformer(CamelJBangMain main) {
        super(main);
    }

    @Override
    int nameWidth() {
        return 60;
    }

    @Override
    List<CatalogBaseCommand.Row> collectRows() {
        ArrayList<CatalogBaseCommand.Row> rows = new ArrayList<CatalogBaseCommand.Row>();
        for (String name : this.catalog.findTransformerNames()) {
            TransformerModel model = this.catalog.transformerModel(name);
            if (model == null) continue;
            CatalogBaseCommand.Row row = new CatalogBaseCommand.Row();
            row.name = model.getName();
            row.title = model.getTitle();
            row.description = model.getDescription();
            row.deprecated = model.isDeprecated();
            row.gav = this.getGAV((ArtifactModel<?>)model);
            rows.add(row);
        }
        return rows;
    }
}

