/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.catalog;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.catalog.CatalogBaseCommand;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.LanguageModel;
import picocli.CommandLine;

@CommandLine.Command(name="language", description={"List expression languages from the Camel Catalog"}, sortOptions=false, showDefaultValues=true)
public class CatalogLanguage
extends CatalogBaseCommand {
    public CatalogLanguage(CamelJBangMain main) {
        super(main);
    }

    @Override
    List<CatalogBaseCommand.Row> collectRows() {
        ArrayList<CatalogBaseCommand.Row> rows = new ArrayList<CatalogBaseCommand.Row>();
        for (String name : this.catalog.findLanguageNames()) {
            LanguageModel model = this.catalog.languageModel(name);
            if (model == null) continue;
            CatalogBaseCommand.Row row = new CatalogBaseCommand.Row();
            row.name = model.getName();
            row.title = model.getTitle();
            row.level = model.getSupportLevel().name();
            row.since = CatalogLanguage.fixQuarkusSince(model.getFirstVersionShort());
            row.description = model.getDescription();
            row.label = model.getLabel() != null ? model.getLabel() : "";
            row.deprecated = model.isDeprecated();
            row.nativeSupported = model.isNativeSupported();
            row.gav = this.getGAV((ArtifactModel<?>)model);
            rows.add(row);
        }
        return rows;
    }
}

