/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.catalog;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletCatalogHelper;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletModel;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

@CommandLine.Command(name="kamelet", description={"List Kamelets from the Kamelet Catalog"}, sortOptions=false, showDefaultValues=true)
public class CatalogKamelet
extends CamelCommand {
    @CommandLine.Option(names={"--sort"}, description={"Sort by name, type, support-level, or description"}, defaultValue="name")
    String sort;
    @CommandLine.Option(names={"--type", "--filter-type"}, description={"Filter by type: source, sink, or action"})
    String filterType;
    @CommandLine.Option(names={"--filter"}, description={"Filter by name or description"})
    String filterName;
    @CommandLine.Option(names={"--kamelets-version"}, description={"Apache Camel Kamelets version"})
    String kameletsVersion;

    public CatalogKamelet(CamelJBangMain main) {
        super(main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer doCall() throws Exception {
        Map kamelets;
        List<KameletModel> rows = new ArrayList<KameletModel>();
        if (this.kameletsVersion == null) {
            this.kameletsVersion = VersionHelper.extractKameletsVersion();
        }
        ClassLoader tccLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = this.createClassLoader();
            MavenDependencyDownloader downloader = new MavenDependencyDownloader();
            downloader.setClassLoader(cl);
            downloader.start();
            downloader.downloadDependency("org.apache.camel.kamelets", "camel-kamelets-catalog", this.kameletsVersion);
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> clazz = cl.loadClass("org.apache.camel.kamelets.catalog.KameletsCatalog");
            Object catalog = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m = clazz.getMethod("getKamelets", new Class[0]);
            kamelets = (Map)ObjectHelper.invokeMethod((Method)m, catalog, (Object[])new Object[0]);
        }
        catch (Exception e) {
            this.printer().printErr("Cannot download camel-kamelets-catalog due to " + e.getMessage());
            Integer downloader = 1;
            return downloader;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccLoader);
        }
        for (Object o : kamelets.values()) {
            KameletModel row = KameletCatalogHelper.createModel(o, false);
            rows.add(row);
        }
        if (this.filterType != null) {
            rows = rows.stream().filter(r -> r.type.equalsIgnoreCase(this.filterType)).collect(Collectors.toList());
        }
        if (this.filterName != null) {
            this.filterName = this.filterName.toLowerCase(Locale.ROOT);
            rows = rows.stream().filter(r -> r.name.equalsIgnoreCase(this.filterName) || r.description.toLowerCase(Locale.ROOT).contains(this.filterName)).collect(Collectors.toList());
        }
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).with(r -> r.name), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).minWidth(10).with(r -> r.type), new Column().header("LEVEL").dataAlign(HorizontalAlign.LEFT).minWidth(12).with(r -> r.supportLevel), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).with(this::getDescription))));
        }
        return 0;
    }

    protected int sortRow(KameletModel o1, KameletModel o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "type": {
                return o1.type.compareToIgnoreCase(o2.type) * negate;
            }
            case "level": 
            case "support-level": {
                return o1.supportLevel.compareToIgnoreCase(o2.supportLevel) * negate;
            }
            case "description": {
                return o1.description.compareToIgnoreCase(o2.description) * negate;
            }
        }
        return 0;
    }

    private ClassLoader createClassLoader() {
        ClassLoader parentCL = CatalogKamelet.class.getClassLoader();
        return new DependencyDownloaderClassLoader(parentCL);
    }

    private String getDescription(KameletModel r) {
        String d = r.description;
        if (d != null && d.contains(".")) {
            d = StringHelper.before((String)d, (String)".");
            d = d.trim();
        }
        if (d != null && d.contains("\n")) {
            d = StringHelper.before((String)d, (String)"\n");
            d = d.trim();
        }
        if (d == null) {
            d = "";
        }
        return d;
    }
}

