/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.catalog;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.awt.Desktop;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.catalog.CatalogBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletCatalogHelper;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletModel;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletOptionModel;
import org.apache.camel.dsl.jbang.core.common.CatalogLoader;
import org.apache.camel.dsl.jbang.core.common.RuntimeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeTypeConverter;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

@CommandLine.Command(name="doc", description={"Shows documentation for kamelet, component, and other Camel resources"}, sortOptions=false, showDefaultValues=true)
public class CatalogDoc
extends CamelCommand {
    @CommandLine.Parameters(description={"Name of kamelet, component, dataformat, or other Camel resource"}, arity="1")
    String name;
    @CommandLine.Option(names={"--camel-version"}, description={"To use a different Camel version than the default version"})
    String camelVersion;
    @CommandLine.Option(names={"--runtime"}, completionCandidates=RuntimeCompletionCandidates.class, converter={RuntimeTypeConverter.class}, description={"Runtime (${COMPLETION-CANDIDATES})"})
    RuntimeType runtime;
    @CommandLine.Option(names={"--download"}, defaultValue="true", description={"Whether to allow automatic downloading JAR dependencies (over the internet)"})
    boolean download = true;
    @CommandLine.Option(names={"--quarkus-version"}, description={"Quarkus Platform version"}, defaultValue="3.27.0")
    String quarkusVersion;
    @CommandLine.Option(names={"--quarkus-group-id"}, description={"Quarkus Platform Maven groupId"}, defaultValue="io.quarkus.platform")
    String quarkusGroupId = "io.quarkus.platform";
    @CommandLine.Option(names={"--repos"}, description={"Additional maven repositories for download on-demand (Use commas to separate multiple repositories)"})
    String repos;
    @CommandLine.Option(names={"--url"}, description={"Prints the link to the online documentation on the Camel website"}, defaultValue="false")
    boolean url;
    @CommandLine.Option(names={"--open-url"}, description={"Opens the online documentation form the Camel website in the web browser"}, defaultValue="false")
    boolean openUrl;
    @CommandLine.Option(names={"--filter"}, description={"Filter option listed in tables by name, description, or group"})
    String filter;
    @CommandLine.Option(names={"--header"}, description={"Whether to display component message headers"}, defaultValue="true")
    boolean headers;
    @CommandLine.Option(names={"--kamelets-version"}, description={"Apache Camel Kamelets version"}, defaultValue="4.14.0")
    String kameletsVersion;
    CamelCatalog catalog;

    public CatalogDoc(CamelJBangMain main) {
        super(main);
    }

    CamelCatalog loadCatalog() throws Exception {
        if (RuntimeType.springBoot == this.runtime) {
            return CatalogLoader.loadSpringBootCatalog(this.repos, this.camelVersion, this.download);
        }
        if (RuntimeType.quarkus == this.runtime) {
            return CatalogLoader.loadQuarkusCatalog(this.repos, this.quarkusVersion, this.quarkusGroupId, this.download);
        }
        if (this.camelVersion == null) {
            return new DefaultCamelCatalog(true);
        }
        return CatalogLoader.loadCatalog(this.repos, this.camelVersion, this.download);
    }

    @Override
    public Integer doCall() throws Exception {
        OtherModel om;
        LanguageModel lm;
        DataFormatModel dm;
        ComponentModel cm;
        KameletModel km;
        MainModel mm;
        this.catalog = this.loadCatalog();
        String prefix = StringHelper.before((String)this.name, (String)":");
        if (prefix != null) {
            this.name = StringHelper.after((String)this.name, (String)":");
        }
        if ("main".equals(this.name) && (mm = this.catalog.mainModel()) != null) {
            this.docMain(mm);
            return 0;
        }
        if ((prefix == null || "kamelet".equals(prefix)) && (km = KameletCatalogHelper.loadKameletModel(this.name, this.kameletsVersion)) != null) {
            this.docKamelet(km);
            return 0;
        }
        if ((prefix == null || "component".equals(prefix)) && (cm = this.catalog.componentModel(this.name)) != null) {
            this.docComponent(cm);
            return 0;
        }
        if ((prefix == null || "dataformat".equals(prefix)) && (dm = this.catalog.dataFormatModel(this.name)) != null) {
            this.docDataFormat(dm);
            return 0;
        }
        if ((prefix == null || "language".equals(prefix)) && (lm = this.catalog.languageModel(this.name)) != null) {
            this.docLanguage(lm);
            return 0;
        }
        if ((prefix == null || "other".equals(prefix)) && (om = this.catalog.otherModel(this.name)) != null) {
            this.docOther(om);
            return 0;
        }
        if (prefix == null) {
            boolean kamelet = this.name.endsWith("-sink") || this.name.endsWith("-source") || this.name.endsWith("-action");
            suggestions = kamelet ? SuggestSimilarHelper.didYouMean(KameletCatalogHelper.findKameletNames(this.kameletsVersion), (String)this.name) : SuggestSimilarHelper.didYouMean(CatalogBaseCommand.findComponentNames(this.catalog), (String)this.name);
            if (!suggestions.isEmpty()) {
                String type = kamelet ? "kamelet" : "component";
                this.printer().printf("Camel %s: %s not found. Did you mean? %s%n", type, this.name, String.join((CharSequence)", ", suggestions));
            } else {
                this.printer().println("Camel resource: " + this.name + " not found");
            }
        } else {
            switch (prefix) {
                case "kamelet": {
                    List list = SuggestSimilarHelper.didYouMean(KameletCatalogHelper.findKameletNames(this.kameletsVersion), (String)this.name);
                    break;
                }
                case "component": {
                    List list = SuggestSimilarHelper.didYouMean(CatalogBaseCommand.findComponentNames(this.catalog), (String)this.name);
                    break;
                }
                case "dataformat": {
                    List list = SuggestSimilarHelper.didYouMean((List)this.catalog.findDataFormatNames(), (String)this.name);
                    break;
                }
                case "language": {
                    List list = SuggestSimilarHelper.didYouMean((List)this.catalog.findLanguageNames(), (String)this.name);
                    break;
                }
                case "other": {
                    List list = SuggestSimilarHelper.didYouMean((List)this.catalog.findOtherNames(), (String)this.name);
                    break;
                }
                default: {
                    List list = suggestions = List.of();
                }
            }
            if (!suggestions.isEmpty()) {
                this.printer().printf("Camel %s: %s not found. Did you mean? %s%n", prefix, this.name, String.join((CharSequence)", ", suggestions));
            } else {
                this.printer().printf("Camel %s: %s not found.%n", prefix, this.name);
            }
        }
        return 1;
    }

    private void docKamelet(KameletModel km) throws Exception {
        String link = this.websiteLink("kamelet", this.name, this.kameletsVersion);
        if (this.openUrl) {
            if (link != null) {
                Desktop.getDesktop().browse(new URI(link));
            }
            return;
        }
        if (this.url) {
            if (link != null) {
                this.printer().println(link);
            }
            return;
        }
        this.printer().printf("Kamelet Name: %s%n", km.name);
        this.printer().printf("Kamelet Type: %s%n", km.type);
        this.printer().println("Support Level: " + km.supportLevel);
        this.printer().println("");
        this.printer().printf("%s%n", km.description);
        this.printer().println("");
        if (km.dependencies != null && !km.dependencies.isEmpty()) {
            this.printer().println("");
            for (String dep : km.dependencies) {
                MavenGav gav = MavenGav.parseGav((String)dep);
                if ("camel-core".equals(gav.getArtifactId())) continue;
                this.printer().println("    <dependency>");
                this.printer().println("        <groupId>" + gav.getGroupId() + "</groupId>");
                this.printer().println("        <artifactId>" + gav.getArtifactId() + "</artifactId>");
                String v = gav.getVersion();
                if (v == null && "org.apache.camel".equals(gav.getGroupId())) {
                    v = this.catalog.getCatalogVersion();
                }
                if (v != null) {
                    this.printer().println("        <version>" + v + "</version>");
                }
                if (gav.getScope() != null) {
                    this.printer().println("        <scope>" + gav.getScope() + "</scope>");
                }
                this.printer().println("    </dependency>");
            }
            this.printer().println("");
        }
        if (km.properties != null && !km.properties.isEmpty()) {
            int total2;
            Collection<KameletOptionModel> filtered = this.filterKameletOptions(this.filter, km.properties.values());
            int total1 = km.properties.size();
            if (total1 == (total2 = filtered.size())) {
                this.printer().printf("The %s kamelet supports (total: %s) options, which are listed below.%n%n", km.name, total1);
            } else {
                this.printer().printf("The %s kamelet supports (total: %s match-filter: %s) options, which are listed below.%n%n", km.name, total1, total2);
            }
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.FANCY_ASCII, filtered, Arrays.asList(new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).minWidth(20).maxWidth(35, OverflowBehaviour.NEWLINE).with(r -> r.name), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(this::getDescription), new Column().header("DEFAULT").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(r -> r.defaultValue), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(r -> r.type), new Column().header("EXAMPLE").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.NEWLINE).with(r -> r.example))));
            this.printer().println("");
        }
        if (link != null) {
            this.printer().println(link);
            this.printer().println("");
        }
    }

    private void docMain(MainModel mm) throws Exception {
        String link = this.websiteLink("other", this.name, this.catalog.getCatalogVersion());
        if (this.openUrl) {
            if (link != null) {
                Desktop.getDesktop().browse(new URI(link));
            }
            return;
        }
        if (this.url) {
            if (link != null) {
                this.printer().println(link);
            }
            return;
        }
        this.printer().printf("Name: %s%n", "main");
        this.printer().printf("Since: %s%n", "3.0");
        this.printer().println("");
        this.printer().printf("%s%n", "This module is used for running Camel standalone via a main class extended from camel-main.");
        this.printer().println("");
        this.printer().println("    <dependency>");
        this.printer().println("        <groupId>org.apache.camel</groupId>");
        this.printer().println("        <artifactId>camel.main</artifactId>");
        this.printer().println("        <version>" + this.catalog.getCatalogVersion() + "</version>");
        this.printer().println("    </dependency>");
        this.printer().println("");
        this.printer().printf("%s%n%n%n", "When running Camel via camel-main you can configure Camel in the application.properties file");
        for (MainModel.MainGroupModel g : mm.getGroups()) {
            List<? extends BaseOptionModel> go = this.filterMain(g.getName(), null, mm.getOptions());
            List<? extends BaseOptionModel> filtered = this.filter(this.filter, go);
            int total1 = go.size();
            int total2 = filtered.size();
            if (total2 <= 0) continue;
            if (total1 == total2) {
                this.printer().printf("%s (total: %s):%n", g.getDescription(), total1);
            } else {
                this.printer().printf("%s options (total: %s match-filter: %s):%n", g.getDescription(), total1, total2);
            }
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.FANCY_ASCII, filtered, Arrays.asList(new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).minWidth(20).maxWidth(40, OverflowBehaviour.NEWLINE).with(this::getName), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(this::getDescription), new Column().header("DEFAULT").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(r -> r.getShortDefaultValue(25)), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(BaseOptionModel::getShortJavaType))));
            this.printer().println("");
            this.printer().println("");
        }
        if (link != null) {
            this.printer().println(link);
            this.printer().println("");
        }
    }

    private void docComponent(ComponentModel cm) throws Exception {
        String link = this.websiteLink("component", this.name, this.catalog.getCatalogVersion());
        if (this.openUrl) {
            if (link != null) {
                Desktop.getDesktop().browse(new URI(link));
            }
            return;
        }
        if (this.url) {
            if (link != null) {
                this.printer().println(link);
            }
            return;
        }
        if (cm.isDeprecated()) {
            this.printer().printf("Component Name: %s (deprecated)%n", cm.getName());
        } else {
            this.printer().printf("Component Name: %s%n", cm.getName());
        }
        this.printer().printf("Since: %s%n", CatalogDoc.fixQuarkusSince(cm.getFirstVersionShort()));
        this.printer().println("");
        if (cm.isProducerOnly()) {
            this.printer().println("Only producer is supported");
        } else if (cm.isConsumerOnly()) {
            this.printer().println("Only consumer is supported");
        } else {
            this.printer().println("Both producer and consumer are supported");
        }
        this.printer().println("");
        this.printer().printf("%s%n", cm.getDescription());
        this.printer().println("");
        this.printer().println("    <dependency>");
        this.printer().println("        <groupId>" + cm.getGroupId() + "</groupId>");
        this.printer().println("        <artifactId>" + cm.getArtifactId() + "</artifactId>");
        this.printer().println("        <version>" + cm.getVersion() + "</version>");
        this.printer().println("    </dependency>");
        this.printer().println("");
        this.printer().printf("The %s endpoint is configured using URI syntax:%n", cm.getName());
        this.printer().println("");
        this.printer().printf("    %s%n", cm.getSyntax());
        this.printer().println("");
        this.printer().println("with the following path and query parameters:");
        this.printer().println("");
        this.printer().printf("Path parameters (%s):%n", cm.getEndpointPathOptions().size());
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.FANCY_ASCII, (Collection)cm.getEndpointPathOptions(), Arrays.asList(new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).minWidth(20).maxWidth(35, OverflowBehaviour.NEWLINE).with(this::getName), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(this::getDescription), new Column().header("DEFAULT").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(r -> r.getShortDefaultValue(25)), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(BaseOptionModel::getShortJavaType))));
        this.printer().println("");
        List<? extends BaseOptionModel> filtered = this.filter(this.filter, cm.getEndpointParameterOptions());
        int total1 = cm.getEndpointParameterOptions().size();
        int total2 = filtered.size();
        if (total1 == total2) {
            this.printer().printf("Query parameters (total: %s):%n", total1);
        } else {
            this.printer().printf("Query parameters (total: %s match-filter: %s):%n", total1, total2);
        }
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.FANCY_ASCII, filtered, Arrays.asList(new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).minWidth(20).maxWidth(35, OverflowBehaviour.NEWLINE).with(this::getName), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(this::getDescription), new Column().header("DEFAULT").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(r -> r.getShortDefaultValue(25)), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(BaseOptionModel::getShortJavaType))));
        this.printer().println("");
        if (this.headers && !cm.getEndpointHeaders().isEmpty()) {
            this.printer().printf("The %s component supports (total: %s) message headers, which are listed below.%n%n", cm.getName(), cm.getEndpointHeaders().size());
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.FANCY_ASCII, (Collection)cm.getEndpointHeaders(), Arrays.asList(new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).minWidth(20).maxWidth(35, OverflowBehaviour.NEWLINE).with(this::getName), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(this::getDescription), new Column().header("DEFAULT").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(r -> r.getShortDefaultValue(25)), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(BaseOptionModel::getShortJavaType))));
            this.printer().println("");
        }
        if (link != null) {
            this.printer().println(link);
            this.printer().println("");
        }
    }

    private void docDataFormat(DataFormatModel dm) throws Exception {
        String link = this.websiteLink("dataformat", this.name, this.catalog.getCatalogVersion());
        if (this.openUrl) {
            if (link != null) {
                Desktop.getDesktop().browse(new URI(link));
            }
            return;
        }
        if (this.url) {
            if (link != null) {
                this.printer().println(link);
            }
            return;
        }
        if (dm.isDeprecated()) {
            this.printer().printf("Dataformat Name: %s (deprecated)%n", dm.getName());
        } else {
            this.printer().printf("Dataformat Name: %s%n", dm.getName());
        }
        this.printer().printf("Since: %s%n", CatalogDoc.fixQuarkusSince(dm.getFirstVersionShort()));
        this.printer().println("");
        this.printer().printf("%s%n", dm.getDescription());
        this.printer().println("");
        this.printer().println("    <dependency>");
        this.printer().println("        <groupId>" + dm.getGroupId() + "</groupId>");
        this.printer().println("        <artifactId>" + dm.getArtifactId() + "</artifactId>");
        this.printer().println("        <version>" + dm.getVersion() + "</version>");
        this.printer().println("    </dependency>");
        this.printer().println("");
        List<? extends BaseOptionModel> filtered = this.filter(this.filter, dm.getOptions());
        int total1 = dm.getOptions().size();
        int total2 = filtered.size();
        if (total1 == total2) {
            this.printer().printf("The %s dataformat supports (total: %s) options, which are listed below.%n%n", dm.getName(), total1);
        } else {
            this.printer().printf("The %s dataformat supports (total: %s match-filter: %s) options, which are listed below.%n%n", dm.getName(), total1, total2);
        }
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.FANCY_ASCII, filtered, Arrays.asList(new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).minWidth(20).maxWidth(35, OverflowBehaviour.NEWLINE).with(this::getName), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(this::getDescription), new Column().header("DEFAULT").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(r -> r.getShortDefaultValue(25)), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(BaseOptionModel::getShortJavaType))));
        this.printer().println("");
        if (link != null) {
            this.printer().println(link);
            this.printer().println("");
        }
    }

    private void docLanguage(LanguageModel lm) throws Exception {
        String link = this.websiteLink("language", this.name, this.catalog.getCatalogVersion());
        if (this.openUrl) {
            if (link != null) {
                Desktop.getDesktop().browse(new URI(link));
            }
            return;
        }
        if (this.url) {
            if (link != null) {
                this.printer().println(link);
            }
            return;
        }
        if (lm.isDeprecated()) {
            this.printer().printf("Language Name: %s (deprecated)%n", lm.getName());
        } else {
            this.printer().printf("Language Name: %s%n", lm.getName());
        }
        this.printer().printf("Since: %s%n", CatalogDoc.fixQuarkusSince(lm.getFirstVersionShort()));
        this.printer().println("");
        this.printer().printf("%s%n", lm.getDescription());
        this.printer().println("");
        this.printer().println("    <dependency>");
        this.printer().println("        <groupId>" + lm.getGroupId() + "</groupId>");
        this.printer().println("        <artifactId>" + lm.getArtifactId() + "</artifactId>");
        this.printer().println("        <version>" + lm.getVersion() + "</version>");
        this.printer().println("    </dependency>");
        this.printer().println("");
        List<? extends BaseOptionModel> filtered = this.filter(this.filter, lm.getOptions());
        int total1 = lm.getOptions().size();
        int total2 = filtered.size();
        if (total1 == total2) {
            this.printer().printf("The %s language supports (total: %s) options, which are listed below.%n%n", lm.getName(), total1);
        } else {
            this.printer().printf("The %s language supports (total: %s match-filter: %s) options, which are listed below.%n%n", lm.getName(), total1, total2);
        }
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.FANCY_ASCII, filtered, Arrays.asList(new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).minWidth(20).maxWidth(35, OverflowBehaviour.NEWLINE).with(this::getName), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(this::getDescription), new Column().header("DEFAULT").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(r -> r.getShortDefaultValue(25)), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.NEWLINE).with(BaseOptionModel::getShortJavaType))));
        this.printer().println("");
        if (link != null) {
            this.printer().println(link);
            this.printer().println("");
        }
    }

    private void docOther(OtherModel om) throws Exception {
        String link = this.websiteLink("other", this.name, this.catalog.getCatalogVersion());
        if (this.openUrl) {
            if (link != null) {
                Desktop.getDesktop().browse(new URI(link));
            }
            return;
        }
        if (this.url) {
            if (link != null) {
                this.printer().println(link);
            }
            return;
        }
        if (om.isDeprecated()) {
            this.printer().printf("Miscellaneous Name: %s (deprecated)%n", om.getName());
        } else {
            this.printer().printf("Miscellaneous Name: %s%n", om.getName());
        }
        this.printer().printf("Since: %s%n", CatalogDoc.fixQuarkusSince(om.getFirstVersionShort()));
        this.printer().println("");
        this.printer().printf("%s%n", om.getDescription());
        this.printer().println("");
        this.printer().println("    <dependency>");
        this.printer().println("        <groupId>" + om.getGroupId() + "</groupId>");
        this.printer().println("        <artifactId>" + om.getArtifactId() + "</artifactId>");
        this.printer().println("        <version>" + om.getVersion() + "</version>");
        this.printer().println("    </dependency>");
        this.printer().println("");
        if (link != null) {
            this.printer().println(link);
            this.printer().println("");
        }
    }

    String getName(BaseOptionModel o) {
        String l = o.getShortGroup();
        if (l != null && !"common".equals(l)) {
            return o.getName() + "\n(" + l + ")";
        }
        return o.getName();
    }

    String getDescription(BaseOptionModel o) {
        Object prefix = "";
        Object suffix = "";
        if (o.isDeprecated()) {
            prefix = "DEPRECATED: " + (String)prefix;
        }
        if (o.isRequired()) {
            prefix = "REQUIRED: " + (String)prefix;
        }
        if (o.getEnums() != null) {
            suffix = "\n\nEnum values:\n- " + String.join((CharSequence)"\n- ", o.getEnums());
        }
        return (String)prefix + o.getDescription() + (String)suffix;
    }

    String getDescription(KameletOptionModel o) {
        Object prefix = "";
        Object suffix = "";
        if (o.required) {
            prefix = "REQUIRED: " + (String)prefix;
        }
        if (o.enumValues != null) {
            suffix = "\n\nEnum values:\n- " + String.join((CharSequence)"\n- ", o.enumValues);
        }
        return (String)prefix + o.description + (String)suffix;
    }

    List<? extends BaseOptionModel> filter(String name, List<? extends BaseOptionModel> options) {
        if (name == null || name.isEmpty()) {
            return options;
        }
        String target = name.toLowerCase(Locale.ROOT);
        return options.stream().filter(r -> r.getName().contains(target) || r.getName().equalsIgnoreCase(target) || r.getDescription().toLowerCase(Locale.ROOT).contains(target) || r.getShortGroup() != null && r.getShortGroup().toLowerCase(Locale.ROOT).contains(target)).collect(Collectors.toList());
    }

    Collection<KameletOptionModel> filterKameletOptions(String name, Collection<KameletOptionModel> options) {
        if (name == null || name.isEmpty()) {
            return options;
        }
        String target = name.toLowerCase(Locale.ROOT);
        return options.stream().filter(r -> r.name.equalsIgnoreCase(target) || r.description.toLowerCase(Locale.ROOT).contains(target)).collect(Collectors.toList());
    }

    String websiteLink(String prefix, String name, String version) {
        Object v = "next";
        if (version != null && !version.endsWith("-SNAPSHOT")) {
            int pos = version.lastIndexOf(46);
            v = version.substring(0, pos) + ".x";
        }
        if ("component".equals(prefix)) {
            return String.format("https://camel.apache.org/components/%s/%s-component.html", v, name);
        }
        if ("dataformat".equals(prefix)) {
            return String.format("https://camel.apache.org/components/%s/dataformats/%s-dataformat.html", v, name);
        }
        if ("language".equals(prefix)) {
            return String.format("https://camel.apache.org/components/%s/languages/%s-language.html", v, name);
        }
        if ("other".equals(prefix)) {
            return String.format("https://camel.apache.org/components/%s/others/%s.html", v, name);
        }
        if ("kamelet".equals(prefix)) {
            return String.format("https://camel.apache.org/camel-kamelets/%s/%s.html", v, name);
        }
        return null;
    }

    List<? extends BaseOptionModel> filterMain(String prefix, String name, List<? extends BaseOptionModel> options) {
        options = options.stream().filter(o -> o.getName().startsWith(prefix)).collect(Collectors.toList());
        if (name == null || name.isEmpty()) {
            return options;
        }
        String target = name.toLowerCase(Locale.ROOT);
        return options.stream().filter(r -> r.getName().contains(target) || r.getName().equalsIgnoreCase(target) || r.getDescription().toLowerCase(Locale.ROOT).contains(target) || r.getShortGroup() != null && r.getShortGroup().toLowerCase(Locale.ROOT).contains(target)).collect(Collectors.toList());
    }

    static String fixQuarkusSince(String since) {
        if (since != null && since.startsWith("0")) {
            return "1.0";
        }
        return since;
    }
}

