/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.catalog;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.catalog.CatalogBaseCommand;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.ComponentModel;
import picocli.CommandLine;

@CommandLine.Command(name="component", description={"List components from the Camel Catalog"}, sortOptions=false, showDefaultValues=true)
public class CatalogComponent
extends CatalogBaseCommand {
    public CatalogComponent(CamelJBangMain main) {
        super(main);
    }

    @Override
    List<CatalogBaseCommand.Row> collectRows() {
        ArrayList<CatalogBaseCommand.Row> rows = new ArrayList<CatalogBaseCommand.Row>();
        for (String name : CatalogComponent.findComponentNames(this.catalog)) {
            ComponentModel model = this.catalog.componentModel(name);
            if (model == null) continue;
            CatalogBaseCommand.Row row = new CatalogBaseCommand.Row();
            row.name = model.getScheme();
            row.title = model.getTitle();
            row.level = model.getSupportLevel().name();
            row.since = CatalogComponent.fixQuarkusSince(model.getFirstVersionShort());
            row.description = model.getDescription();
            row.label = model.getLabel() != null ? model.getLabel() : "";
            row.deprecated = model.isDeprecated();
            row.nativeSupported = model.isNativeSupported();
            row.gav = this.getGAV((ArtifactModel<?>)model);
            rows.add(row);
        }
        return rows;
    }
}

