/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.catalog;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CatalogLoader;
import org.apache.camel.dsl.jbang.core.common.RuntimeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeTypeConverter;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

public abstract class CatalogBaseCommand
extends CamelCommand {
    @CommandLine.Option(names={"--camel-version"}, description={"To use a different Camel version than the default version"})
    String camelVersion;
    @CommandLine.Option(names={"--runtime"}, completionCandidates=RuntimeCompletionCandidates.class, converter={RuntimeTypeConverter.class}, description={"Runtime (${COMPLETION-CANDIDATES})"})
    RuntimeType runtime;
    @CommandLine.Option(names={"--download"}, defaultValue="true", description={"Whether to allow automatic downloading JAR dependencies (over the internet)"})
    boolean download = true;
    @CommandLine.Option(names={"--quarkus-version"}, description={"Quarkus Platform version"}, defaultValue="3.27.0")
    String quarkusVersion;
    @CommandLine.Option(names={"--quarkus-group-id"}, description={"Quarkus Platform Maven groupId"}, defaultValue="io.quarkus.platform")
    String quarkusGroupId = "io.quarkus.platform";
    @CommandLine.Option(names={"--repos"}, description={"Additional maven repositories for download on-demand (Use commas to separate multiple repositories)"})
    String repos;
    @CommandLine.Option(names={"--sort"}, description={"Sort by name, support-level, or description"}, defaultValue="name")
    String sort;
    @CommandLine.Option(names={"--display-gav"}, description={"Display Maven GAV instead of name"}, defaultValue="false")
    boolean displayGav;
    @CommandLine.Option(names={"--filter"}, description={"Filter by name or description"})
    String filterName;
    @CommandLine.Option(names={"--since-before"}, description={"Filter by version older (inclusive)"})
    String sinceBefore;
    @CommandLine.Option(names={"--since-after"}, description={"Filter by version more recent (inclusive)"})
    String sinceAfter;
    @CommandLine.Option(names={"--json"}, description={"Output in JSON Format"})
    boolean jsonOutput;
    CamelCatalog catalog;

    public CatalogBaseCommand(CamelJBangMain main) {
        super(main);
    }

    abstract List<Row> collectRows();

    String getGAV(ArtifactModel<?> model) {
        return model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
    }

    CamelCatalog loadCatalog() throws Exception {
        if (RuntimeType.springBoot == this.runtime) {
            return CatalogLoader.loadSpringBootCatalog(this.repos, this.camelVersion, this.download);
        }
        if (RuntimeType.quarkus == this.runtime) {
            return CatalogLoader.loadQuarkusCatalog(this.repos, this.quarkusVersion, this.quarkusGroupId, this.download);
        }
        if (this.camelVersion == null) {
            return new DefaultCamelCatalog(true);
        }
        return CatalogLoader.loadCatalog(this.repos, this.camelVersion, this.download);
    }

    @Override
    public Integer doCall() throws Exception {
        this.catalog = this.loadCatalog();
        List<Row> rows = this.collectRows();
        if (this.filterName != null) {
            this.filterName = this.filterName.toLowerCase(Locale.ROOT);
            rows = rows.stream().filter(r -> r.name.equalsIgnoreCase(this.filterName) || r.description.toLowerCase(Locale.ROOT).contains(this.filterName) || r.label.toLowerCase(Locale.ROOT).contains(this.filterName)).collect(Collectors.toList());
        }
        if (this.sinceBefore != null) {
            rows = rows.stream().filter(r -> VersionHelper.isGE(this.sinceBefore, r.since)).collect(Collectors.toList());
        }
        if (this.sinceAfter != null) {
            rows = rows.stream().filter(r -> VersionHelper.isGE(r.since, this.sinceAfter)).collect(Collectors.toList());
        }
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            if (this.jsonOutput) {
                this.printer().println(Jsoner.serialize(rows.stream().map(row -> Map.of("name", row.name, "level", row.level, "native", row.nativeSupported)).collect(Collectors.toList())));
            } else {
                this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("NAME").visible(!this.displayGav).dataAlign(HorizontalAlign.LEFT).maxWidth(this.nameWidth()).with(r -> r.name), new Column().header("ARTIFACT-ID").visible(this.displayGav).dataAlign(HorizontalAlign.LEFT).with(this::shortGav), new Column().header("LEVEL").dataAlign(HorizontalAlign.LEFT).with(r -> r.level), new Column().header("NATIVE").dataAlign(HorizontalAlign.CENTER).visible(RuntimeType.quarkus == this.runtime).with(this::nativeSupported), new Column().header("SINCE").dataAlign(HorizontalAlign.RIGHT).with(r -> r.since), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).with(this::shortDescription))));
            }
        }
        return 0;
    }

    int nameWidth() {
        return 30;
    }

    int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "level": 
            case "support-level": {
                return o1.level.compareToIgnoreCase(o2.level) * negate;
            }
            case "description": {
                return o1.description.compareToIgnoreCase(o2.description) * negate;
            }
        }
        return 0;
    }

    String shortGav(Row r) {
        return MavenGav.parseGav((String)r.gav).getArtifactId();
    }

    String shortDescription(Row r) {
        if (r.deprecated) {
            return "DEPRECATED: " + r.description;
        }
        return r.description;
    }

    String nativeSupported(Row r) {
        return r.nativeSupported ? "x" : "";
    }

    static String fixQuarkusSince(String since) {
        if (since != null && since.startsWith("0")) {
            return "1.0";
        }
        return since;
    }

    static List<String> findComponentNames(CamelCatalog catalog) {
        List answer = catalog.findComponentNames();
        ArrayList<String> copy = new ArrayList<String>(answer);
        copy.removeIf(String::isBlank);
        return copy;
    }

    static class Row {
        String name;
        String title;
        String level;
        String since;
        boolean nativeSupported;
        String description;
        String label;
        String gav;
        boolean deprecated;

        Row() {
        }
    }
}

