/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.bind;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.dsl.jbang.core.commands.bind.BindingProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.TemplateProvider;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public class UriBindingProvider
implements BindingProvider {
    private static final Pattern CAMEL_ENDPOINT_URI_PATTERN = Pattern.compile("^[a-z0-9+][a-zA-Z0-9-+]*:.*$");

    @Override
    public String getEndpoint(BindingProvider.EndpointType type, String uriExpression, Map<String, Object> endpointProperties, TemplateProvider templateProvider) throws Exception {
        String endpointUri = uriExpression;
        Map endpointUriProperties = new HashMap();
        if (uriExpression.contains("?")) {
            endpointUri = StringHelper.before((String)uriExpression, (String)"?");
            String query = StringHelper.after((String)uriExpression, (String)"?");
            if (query != null) {
                endpointUriProperties = URISupport.parseQuery((String)query, (boolean)true);
            }
        }
        endpointProperties.putAll(endpointUriProperties);
        InputStream is = type == BindingProvider.EndpointType.STEP ? templateProvider.getStepTemplate("uri") : templateProvider.getEndpointTemplate("uri");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        context = context.replaceFirst("\\{\\{ \\.URI }}", endpointUri);
        context = context.replaceFirst("\\{\\{ \\.EndpointProperties }}\n", templateProvider.asEndpointProperties(endpointProperties));
        return context;
    }

    @Override
    public boolean canHandle(String uriExpression) {
        return CAMEL_ENDPOINT_URI_PATTERN.matcher(uriExpression).matches();
    }
}

