/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.bind;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.dsl.jbang.core.commands.bind.BindingProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.ObjectReferenceBindingProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.TemplateProvider;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.github.GitHubResourceResolver;
import org.apache.camel.impl.engine.DefaultResourceResolvers;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

public class PipeProvider
extends ObjectReferenceBindingProvider {
    private static final String prefix = "kamelet:";

    public PipeProvider() {
        super("camel.apache.org/v1", "Kamelet");
    }

    @Override
    public String getEndpoint(BindingProvider.EndpointType type, String uriExpression, Map<String, Object> endpointProperties, TemplateProvider templateProvider) throws Exception {
        if (uriExpression.startsWith(prefix)) {
            return super.getEndpoint(type, StringHelper.after((String)uriExpression, (String)prefix), endpointProperties, templateProvider);
        }
        return super.getEndpoint(type, uriExpression, endpointProperties, templateProvider);
    }

    @Override
    protected Map<String, Object> getEndpointUriProperties(BindingProvider.EndpointType type, String objectName, String uriExpression, Map<String, Object> endpointProperties) throws Exception {
        return this.kameletProperties(objectName, super.getEndpointUriProperties(type, objectName, uriExpression, endpointProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> kameletProperties(String kamelet, Map<String, Object> userProperties) throws Exception {
        String loc;
        InputStream is;
        Resource res;
        HashMap<String, Object> endpointProperties = new HashMap<String, Object>();
        try (DefaultResourceResolvers.FileResolver resolver = new DefaultResourceResolvers.FileResolver();){
            res = resolver.resolve("file:" + kamelet + ".kamelet.yaml");
        }
        if (res.exists()) {
            is = res.getInputStream();
            loc = res.getLocation();
        } else {
            resolver = new GitHubResourceResolver();
            try {
                res = resolver.resolve("github:apache:camel-kamelets:main:kamelets/" + kamelet + ".kamelet.yaml");
            }
            finally {
                resolver.close();
            }
            loc = res.getLocation();
            URL u = URI.create(loc).toURL();
            is = u.openStream();
        }
        if (is != null) {
            try {
                Set required;
                LoadSettings local = LoadSettings.builder().setLabel(loc).build();
                StreamReader reader = new StreamReader(local, (Reader)new YamlUnicodeReader(is));
                ParserImpl parser = new ParserImpl(local, reader);
                Composer composer = new Composer(local, (Parser)parser);
                Node root = composer.getSingleNode().orElse(null);
                if (root != null && (required = YamlDeserializerSupport.asStringSet((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/definition/required"))) != null && !required.isEmpty()) {
                    for (String req : required) {
                        if (userProperties.containsKey(req)) continue;
                        String type = YamlDeserializerSupport.asText((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)("/spec/definition/properties/" + req + "/type")));
                        String example = YamlDeserializerSupport.asText((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)("/spec/definition/properties/" + req + "/example")));
                        StringBuilder vb = new StringBuilder();
                        if (example != null) {
                            if ("string".equals(type)) {
                                vb.append("\"");
                            }
                            vb.append(example);
                            if ("string".equals(type)) {
                                vb.append("\"");
                            }
                        } else {
                            vb.append("\"value\"");
                        }
                        endpointProperties.put(req, vb.toString());
                    }
                }
                IOHelper.close((Closeable)is);
            }
            catch (Exception e) {
                System.err.println("Error parsing Kamelet: " + loc + " due to: " + e.getMessage());
            }
        } else {
            System.err.println("Kamelet not found on github: " + kamelet);
        }
        endpointProperties.putAll(userProperties);
        return endpointProperties;
    }

    @Override
    public boolean canHandle(String uriExpression) {
        return uriExpression.startsWith(prefix) || !uriExpression.contains(":");
    }
}

