/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.bind;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.camel.CamelException;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.bind.BindingProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.KnativeBrokerBindingProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.KnativeChannelBindingProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.ObjectReferenceBindingProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.PipeProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.StrimziKafkaTopicBindingProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.TemplateProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.UriBindingProvider;
import org.apache.camel.dsl.jbang.core.common.JSonHelper;
import org.apache.camel.dsl.jbang.core.common.YamlHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

@CommandLine.Command(name="bind", description={"Bind source and sink Kamelets as a new Camel integration"}, sortOptions=false, showDefaultValues=true)
public class Bind
extends CamelCommand {
    @CommandLine.Parameters(description={"Name of binding file to be saved"}, arity="1", paramLabel="<file>", parameterConsumer=FileConsumer.class)
    Path filePath;
    String file;
    @CommandLine.Option(names={"--source"}, description={"Source (from) such as a Kamelet or Camel endpoint uri"}, required=true)
    String source;
    @CommandLine.Option(names={"--step"}, description={"Optional steps such as a Kamelet or Camel endpoint uri"})
    String[] steps;
    @CommandLine.Option(names={"--sink"}, description={"Sink (to) such as a Kamelet or Camel endpoint uri"}, required=true)
    String sink;
    @CommandLine.Option(names={"--error-handler"}, description={"Add error handler (none|log|sink:<endpoint>). Sink endpoints are expected in the format \"[[apigroup/]version:]kind:[namespace/]name\", plain Camel URIs or Kamelet name."})
    String errorHandler;
    @CommandLine.Option(names={"--property"}, description={"Adds a pipe property in the form of [source|sink|error-handler|step-<n>].<key>=<value> where <n> is the step number starting from 1"}, arity="0")
    String[] properties;
    @CommandLine.Option(names={"--output"}, defaultValue="file", description={"Output format generated by this command (supports: file, yaml or json)."})
    String output;
    private final TemplateProvider templateProvider;
    private final BindingProvider[] bindingProviders = new BindingProvider[]{new PipeProvider(), new KnativeBrokerBindingProvider(), new KnativeChannelBindingProvider(), new StrimziKafkaTopicBindingProvider(), new ObjectReferenceBindingProvider(), new UriBindingProvider()};

    public Bind(CamelJBangMain main) {
        this(main, new TemplateProvider(){});
    }

    public Bind(CamelJBangMain main, TemplateProvider templateProvider) {
        super(main);
        this.templateProvider = templateProvider;
    }

    @Override
    public Integer doCall() throws Exception {
        String pipe = this.constructPipe();
        if (pipe.isEmpty()) {
            this.printer().printErr("Failed to construct Pipe resource");
            return -1;
        }
        return this.dumpPipe(pipe);
    }

    public String constructPipe() throws Exception {
        try {
            String sourceEndpoint = this.resolveEndpoint(BindingProvider.EndpointType.SOURCE, this.source, this.getProperties("source"));
            String sinkEndpoint = this.resolveEndpoint(BindingProvider.EndpointType.SINK, this.sink, this.getProperties("sink"));
            InputStream is = this.templateProvider.getPipeTemplate();
            String context = IOHelper.loadText((InputStream)is);
            IOHelper.close((Closeable)is);
            String stepsContext = "";
            if (this.steps != null) {
                StringBuilder sb = new StringBuilder("\n  steps:\n");
                for (int i = 0; i < this.steps.length; ++i) {
                    sb.append(this.resolveEndpoint(BindingProvider.EndpointType.STEP, this.steps[i], this.getProperties("step-%d".formatted(i + 1))));
                    if (i >= this.steps.length - 1) continue;
                    sb.append("\n");
                }
                stepsContext = sb.toString();
            }
            String errorHandlerContext = "";
            if (this.errorHandler != null) {
                String errorHandlerSpec;
                String errorHandlerType;
                StringBuilder sb = new StringBuilder("\n  errorHandler:\n");
                Map<String, Object> errorHandlerParameters = this.getProperties("error-handler");
                String[] errorHandlerTokens = this.errorHandler.split(":", 2);
                switch (errorHandlerType = errorHandlerTokens[0]) {
                    case "sink": {
                        if (errorHandlerTokens.length != 2) {
                            this.printer().printErr("Invalid error handler syntax. Type 'sink' needs an endpoint configuration (ie sink:endpointUri)");
                            return "";
                        }
                        String endpointUri = errorHandlerTokens[1];
                        Map<String, Object> errorHandlerSinkProperties = this.getProperties("error-handler.sink");
                        errorHandlerSinkProperties.keySet().stream().map(key -> "sink." + key).filter(errorHandlerParameters::containsKey).forEach(errorHandlerParameters::remove);
                        String endpoint = this.resolveEndpoint(BindingProvider.EndpointType.ERROR_HANDLER, endpointUri, errorHandlerSinkProperties);
                        is = this.templateProvider.getErrorHandlerTemplate("sink");
                        errorHandlerSpec = IOHelper.loadText((InputStream)is);
                        IOHelper.close((Closeable)is);
                        errorHandlerSpec = errorHandlerSpec.replaceFirst("\\{\\{ \\.Endpoint }}", endpoint);
                        errorHandlerSpec = errorHandlerSpec.replaceFirst("\\{\\{ \\.ErrorHandlerParameter }}", this.templateProvider.asErrorHandlerParameters(errorHandlerParameters));
                        break;
                    }
                    case "log": {
                        is = this.templateProvider.getErrorHandlerTemplate("log");
                        errorHandlerSpec = IOHelper.loadText((InputStream)is);
                        IOHelper.close((Closeable)is);
                        errorHandlerSpec = errorHandlerSpec.replaceFirst("\\{\\{ \\.ErrorHandlerParameter }}", this.templateProvider.asErrorHandlerParameters(errorHandlerParameters));
                        break;
                    }
                    default: {
                        errorHandlerSpec = "    none: {}";
                    }
                }
                sb.append(errorHandlerSpec);
                errorHandlerContext = sb.toString();
            }
            String name = FileUtil.onlyName((String)this.file, (boolean)false);
            context = context.replaceFirst("\\{\\{ \\.Name }}", name);
            context = context.replaceFirst("\\{\\{ \\.Source }}\n", sourceEndpoint);
            context = context.replaceFirst("\\{\\{ \\.Sink }}\n", sinkEndpoint);
            context = context.replaceFirst("\\{\\{ \\.Steps }}", stepsContext);
            context = context.replaceFirst("\\{\\{ \\.ErrorHandler }}", errorHandlerContext);
            return context;
        }
        catch (Exception e) {
            this.printer().printErr(e);
            return "";
        }
    }

    private String resolveEndpoint(BindingProvider.EndpointType endpointType, String uriExpression, Map<String, Object> endpointProperties) throws Exception {
        for (BindingProvider provider : this.bindingProviders) {
            if (!provider.canHandle(uriExpression)) continue;
            String context = provider.getEndpoint(endpointType, uriExpression, endpointProperties, this.templateProvider);
            int additionalIndent = this.templateProvider.getAdditionalIndent(endpointType);
            if (additionalIndent > 0) {
                context = Arrays.stream(context.split("\n")).map(line -> " ".repeat(additionalIndent) + line).collect(Collectors.joining("\n"));
            }
            return context;
        }
        throw new CamelException("Failed to resolve endpoint URI expression %s - no matching binding provider found".formatted(uriExpression));
    }

    public int dumpPipe(String pipe) throws Exception {
        switch (this.output) {
            case "file": {
                if (this.file.endsWith(".yaml")) {
                    IOHelper.writeText((String)pipe, (OutputStream)new FileOutputStream(this.file, false));
                    break;
                }
                if (this.file.endsWith(".json")) {
                    IOHelper.writeText((String)Jsoner.serialize((Object)YamlHelper.yaml().loadAs(pipe, Map.class)), (OutputStream)new FileOutputStream(this.file, false));
                    break;
                }
                IOHelper.writeText((String)pipe, (OutputStream)new FileOutputStream(this.file + ".yaml", false));
                break;
            }
            case "yaml": {
                this.printer().println(pipe);
                break;
            }
            case "json": {
                this.printer().println(JSonHelper.prettyPrint(Jsoner.serialize((Object)YamlHelper.yaml().loadAs(pipe, Map.class)), 2).replaceAll("\\\\/", "/"));
                break;
            }
            default: {
                this.printer().printErr("Unsupported output format '%s' (supported: file, yaml, json)".formatted(this.output));
                return -1;
            }
        }
        return 0;
    }

    private Map<String, Object> getProperties(String keyPrefix) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.properties != null) {
            for (String propertyExpression : this.properties) {
                if (!propertyExpression.startsWith(keyPrefix + ".")) continue;
                String[] keyValue = propertyExpression.split("=", 2);
                if (keyValue.length != 2) {
                    this.printer().printErr("property '%s' does not follow format [source|sink|error-handler|step-<n>].<key>=<value>".formatted(propertyExpression));
                    continue;
                }
                props.put(keyValue[0].substring(keyPrefix.length() + 1), keyValue[1]);
            }
        }
        return props;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSink(String sink) {
        this.sink = sink;
    }

    public void setSteps(String[] steps) {
        this.steps = steps;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    static class FileConsumer
    extends CamelCommand.ParameterConsumer<Bind> {
        FileConsumer() {
        }

        @Override
        protected void doConsumeParameters(Stack<String> args, Bind cmd) {
            cmd.file = args.pop();
        }
    }
}

