/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.camel.dsl.jbang.core.common.CamelCommandHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.fusesource.jansi.Ansi;

public class MessageTableHelper {
    private boolean loggingColor;
    private boolean pretty;
    private boolean showExchangeProperties;
    private boolean showExchangeVariables;
    private ColorChooser exchangeIdColorChooser;

    public boolean isLoggingColor() {
        return this.loggingColor;
    }

    public void setLoggingColor(boolean loggingColor) {
        this.loggingColor = loggingColor;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public boolean isShowExchangeProperties() {
        return this.showExchangeProperties;
    }

    public void setShowExchangeProperties(boolean showExchangeProperties) {
        this.showExchangeProperties = showExchangeProperties;
    }

    public boolean isShowExchangeVariables() {
        return this.showExchangeVariables;
    }

    public void setShowExchangeVariables(boolean showExchangeVariables) {
        this.showExchangeVariables = showExchangeVariables;
    }

    public ColorChooser getExchangeIdColorChooser() {
        return this.exchangeIdColorChooser;
    }

    public void setExchangeIdColorChooser(ColorChooser exchangeIdColorChooser) {
        this.exchangeIdColorChooser = exchangeIdColorChooser;
    }

    public String getDataAsTable(String exchangeId, String exchangePattern, JsonObject endpoint, JsonObject endpointService, JsonObject root, JsonObject cause) {
        String value;
        TableRow eRow;
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        String tab0 = null;
        String tab0b = null;
        String tab1 = null;
        String tab1b = null;
        String tab2 = null;
        String tab3 = null;
        String tab4 = null;
        String tab5 = null;
        String tab6 = null;
        if (endpoint != null) {
            eRow = new TableRow("Endpoint", null, null, endpoint.getString("endpoint"));
            tab0 = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(eRow), Arrays.asList(new Column().dataAlign(HorizontalAlign.LEFT).minWidth(this.showExchangeProperties || this.showExchangeVariables ? 12 : 10).with(TableRow::kindAsString), new Column().dataAlign(HorizontalAlign.LEFT).with(TableRow::valueAsString)));
        }
        if (endpointService != null) {
            Map arr;
            eRow = new TableRow("Service", null, null, endpointService.getString("serviceUrl"));
            TableRow eRow2 = null;
            StringJoiner sj = new StringJoiner(", ");
            String protocol = endpointService.getString("serviceProtocol");
            if (protocol != null) {
                sj.add("protocol=" + protocol);
            }
            if ((arr = endpointService.getMap("serviceMetadata")) != null) {
                arr.forEach((k, v) -> sj.add(String.valueOf(k) + "=" + String.valueOf(v)));
            }
            if (sj.length() > 0) {
                String data = "(" + String.valueOf(sj) + ")";
                eRow2 = new TableRow(null, null, null, data);
            }
            tab0b = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, eRow2 != null ? List.of(eRow, eRow2) : List.of(eRow), Arrays.asList(new Column().dataAlign(HorizontalAlign.LEFT).minWidth(this.showExchangeProperties || this.showExchangeVariables ? 12 : 10).with(TableRow::kindAsString), new Column().dataAlign(HorizontalAlign.LEFT).with(TableRow::valueAsString)));
        }
        if (root != null) {
            JsonObject jo;
            JsonArray arr;
            if (exchangeId != null) {
                eRow = new TableRow("Exchange", root.getString("exchangeType"), exchangePattern, exchangeId);
                tab1 = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(eRow), Arrays.asList(new Column().dataAlign(HorizontalAlign.LEFT).minWidth(this.showExchangeProperties || this.showExchangeVariables ? 12 : 10).with(TableRow::kindAsString), new Column().dataAlign(HorizontalAlign.LEFT).with(TableRow::typeAsString)));
                tab1b = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(eRow), Arrays.asList(new Column().dataAlign(HorizontalAlign.CENTER).minWidth(18).maxWidth(18).with(TableRow::mepAsKey), new Column().dataAlign(HorizontalAlign.RIGHT).maxWidth(80).with(TableRow::exchangeIdAsValue)));
            }
            if ((arr = (JsonArray)root.getCollection("exchangeVariables")) != null) {
                for (Object o : arr) {
                    jo = (JsonObject)o;
                    rows.add(new TableRow("Variable", jo.getString("type"), jo.getString("key"), jo.get((Object)"value")));
                }
            }
            if ((arr = (JsonArray)root.getCollection("exchangeProperties")) != null) {
                for (Object o : arr) {
                    jo = (JsonObject)o;
                    rows.add(new TableRow("Property", jo.getString("type"), jo.getString("key"), jo.get((Object)"value")));
                }
            }
            if ((arr = (JsonArray)root.getCollection("internalExchangeProperties")) != null) {
                for (Object o : arr) {
                    jo = (JsonObject)o;
                    rows.add(new TableRow("Property", jo.getString("type"), jo.getString("key"), jo.get((Object)"value")));
                }
            }
            if (!rows.isEmpty()) {
                tab2 = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().dataAlign(HorizontalAlign.LEFT).minWidth(this.showExchangeProperties || this.showExchangeVariables ? 12 : 10).with(TableRow::kindAsString), new Column().dataAlign(HorizontalAlign.LEFT).minWidth(25).maxWidth(50, OverflowBehaviour.CLIP_LEFT).with(TableRow::typeAsString), new Column().dataAlign(HorizontalAlign.RIGHT).minWidth(25).maxWidth(40, OverflowBehaviour.NEWLINE).with(TableRow::keyAsString), new Column().dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(TableRow::valueAsString)));
            }
            rows.clear();
            if (root.getString("messageType") != null) {
                TableRow msgRow = new TableRow("Message", root.getString("messageType"), null, null);
                tab3 = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(msgRow), Arrays.asList(new Column().dataAlign(HorizontalAlign.LEFT).minWidth(this.showExchangeProperties || this.showExchangeVariables ? 12 : 10).with(TableRow::kindAsString), new Column().dataAlign(HorizontalAlign.LEFT).with(TableRow::typeAsString)));
            }
            if ((arr = (JsonArray)root.getCollection("headers")) != null) {
                for (Object o : arr) {
                    long val;
                    jo = (JsonObject)o;
                    String key = jo.getString("key");
                    Object value2 = jo.get((Object)"value");
                    if ("CamelMessageTimestamp".equals(key) && (val = jo.getLongOrDefault("value", 0L).longValue()) > 0L) {
                        String df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(val);
                        String since = TimeUtils.printSince((long)val);
                        value2 = "(" + df + " / " + since + " ago)";
                        value2 = this.loggingColor ? val + " " + Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(value2).reset().toString() : val + " " + String.valueOf(value2);
                    }
                    rows.add(new TableRow("Header", jo.getString("type"), key, value2));
                }
            }
            if (!rows.isEmpty()) {
                tab4 = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().dataAlign(HorizontalAlign.LEFT).minWidth(this.showExchangeProperties || this.showExchangeVariables ? 12 : 10).with(TableRow::kindAsString), new Column().dataAlign(HorizontalAlign.LEFT).minWidth(25).maxWidth(50, OverflowBehaviour.CLIP_LEFT).with(TableRow::typeAsString), new Column().dataAlign(HorizontalAlign.RIGHT).minWidth(25).maxWidth(40, OverflowBehaviour.NEWLINE).with(TableRow::keyAsString), new Column().dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(TableRow::valueAsString)));
            }
            rows.clear();
            JsonObject jo2 = (JsonObject)root.getMap("body");
            if (jo2 != null) {
                TableRow bodyRow = new TableRow("Body", jo2.getString("type"), null, jo2.get((Object)"value"), jo2.getLong("size"), jo2.getLong("position"));
                tab5 = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(bodyRow), Arrays.asList(new Column().dataAlign(HorizontalAlign.LEFT).minWidth(this.showExchangeProperties || this.showExchangeVariables ? 12 : 10).with(TableRow::kindAsString), new Column().dataAlign(HorizontalAlign.LEFT).with(TableRow::typeAndLengthAsString)));
                if (bodyRow.value != null) {
                    tab6 = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(bodyRow), Collections.singletonList(new Column().dataAlign(HorizontalAlign.LEFT).maxWidth(160, OverflowBehaviour.NEWLINE).with(b -> this.pretty ? bodyRow.valueAsStringPretty() : bodyRow.valueAsString())));
                }
            }
        }
        String tab7 = null;
        if (cause != null) {
            eRow = new TableRow("Exception", cause.getString("type"), null, cause.get((Object)"message"));
            tab7 = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(eRow), Arrays.asList(new Column().dataAlign(HorizontalAlign.LEFT).minWidth(this.showExchangeProperties || this.showExchangeVariables ? 12 : 10).with(TableRow::kindAsStringRed), new Column().dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.CLIP_LEFT).with(TableRow::typeAsString), new Column().dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(TableRow::valueAsStringRed)));
        }
        String tab8 = null;
        if (cause != null && (value = cause.getString("stackTrace")) != null) {
            value = Jsoner.unescape((String)value);
            eRow = new TableRow("Stacktrace", null, null, value);
            tab8 = AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(eRow), Collections.singletonList(new Column().dataAlign(HorizontalAlign.LEFT).maxWidth(160, OverflowBehaviour.NEWLINE).with(TableRow::valueAsStringRed)));
        }
        Object answer = "";
        if (tab0 != null && !tab0.isEmpty()) {
            answer = (String)answer + tab0 + System.lineSeparator();
        }
        if (tab0b != null && !tab0b.isEmpty()) {
            answer = (String)answer + tab0b + System.lineSeparator();
        }
        if (tab1 != null && tab1b != null && !tab1.isEmpty()) {
            answer = (String)answer + tab1 + tab1b + System.lineSeparator();
        }
        if (tab2 != null && !tab2.isEmpty()) {
            answer = (String)answer + tab2 + System.lineSeparator();
        }
        if (tab3 != null && !tab3.isEmpty()) {
            answer = (String)answer + tab3 + System.lineSeparator();
        }
        if (tab4 != null && !tab4.isEmpty()) {
            answer = (String)answer + tab4 + System.lineSeparator();
        }
        if (tab5 != null && !tab5.isEmpty()) {
            answer = (String)answer + tab5 + System.lineSeparator();
        }
        if (tab6 != null && !tab6.isEmpty()) {
            answer = (String)answer + tab6 + System.lineSeparator();
        }
        if (tab7 != null && !tab7.isEmpty()) {
            answer = (String)answer + tab7 + System.lineSeparator();
        }
        if (tab8 != null && !tab8.isEmpty()) {
            answer = (String)answer + tab8 + System.lineSeparator();
        }
        return answer;
    }

    @FunctionalInterface
    public static interface ColorChooser {
        public Ansi.Color color(String var1);
    }

    private class TableRow {
        String kind;
        String type;
        String key;
        Object value;
        Long position;
        Long size;

        TableRow(String kind, String type, String key, Object value) {
            this(kind, type, key, value, null, null);
        }

        TableRow(String kind, String type, String key, Object value, Long size, Long position) {
            this.kind = kind;
            this.type = type;
            this.key = key;
            this.value = value;
            this.position = position;
            this.size = size;
        }

        String valueAsString() {
            if (this.value == null || "null".equals(this.value)) {
                this.value = MessageTableHelper.this.loggingColor ? Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(this.value).reset().toString() : "null";
            }
            return this.value.toString();
        }

        String valueAsStringPretty() {
            return CamelCommandHelper.valueAsStringPretty(this.value, MessageTableHelper.this.loggingColor);
        }

        String valueAsStringRed() {
            if (this.value != null) {
                if (MessageTableHelper.this.loggingColor) {
                    return Ansi.ansi().fgRed().a(this.value).reset().toString();
                }
                return this.value.toString();
            }
            return "";
        }

        String keyAsString() {
            if (this.key == null) {
                return "";
            }
            return this.key;
        }

        String kindAsString() {
            return this.kind;
        }

        String kindAsStringRed() {
            if (MessageTableHelper.this.loggingColor) {
                return Ansi.ansi().fgRed().a(this.kind).reset().toString();
            }
            return this.kind;
        }

        String typeAsString() {
            Object s;
            if (this.type == null) {
                s = "null";
            } else if (this.type.startsWith("java.util.concurrent")) {
                s = this.type.substring(21);
            } else if (this.type.startsWith("java.lang.") || this.type.startsWith("java.util.")) {
                s = this.type.substring(10);
            } else if (this.type.startsWith("org.apache.camel.support.")) {
                s = this.type.substring(25);
            } else if (this.type.equals("org.apache.camel.converter.stream.CachedOutputStream.WrappedInputStream")) {
                s = "WrappedInputStream";
            } else if (this.type.startsWith("org.apache.camel.converter.stream.")) {
                s = this.type.substring(34);
            } else if (this.type.length() > 34) {
                int pos = this.type.lastIndexOf(46);
                if (pos == -1) {
                    pos = this.type.length() - 34;
                }
                s = this.type.substring(pos + 1);
            } else {
                s = this.type;
            }
            s = "(" + (String)s + ")";
            if (MessageTableHelper.this.loggingColor) {
                s = Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a((String)s).reset().toString();
            }
            return s;
        }

        String typeAndLengthAsString() {
            Object s = this.type == null ? "null" : (this.type.startsWith("java.util.concurrent") ? this.type.substring(21) : (this.type.startsWith("java.lang.") || this.type.startsWith("java.util.") ? this.type.substring(10) : (this.type.startsWith("org.apache.camel.support.") ? this.type.substring(25) : (this.type.equals("org.apache.camel.converter.stream.CachedOutputStream.WrappedInputStream") ? "WrappedInputStream" : (this.type.startsWith("org.apache.camel.converter.stream.") ? this.type.substring(34) : this.type)))));
            s = "(" + (String)s + ")";
            int l = this.valueLength();
            long sz = this.size != null ? this.size : -1L;
            long p = this.position != null ? this.position : -1L;
            StringBuilder sb = new StringBuilder();
            if (sz != -1L) {
                sb.append(" size: ").append(sz);
            }
            if (p != -1L) {
                sb.append(" pos: ").append(p);
            }
            if (l != -1) {
                sb.append(" bytes: ").append(l);
            }
            if (!sb.isEmpty()) {
                s = (String)s + " (" + sb.toString().trim() + ")";
            }
            if (MessageTableHelper.this.loggingColor) {
                s = Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a((String)s).reset().toString();
            }
            return s;
        }

        String mepAsKey() {
            String s = this.key;
            if (MessageTableHelper.this.loggingColor) {
                s = Ansi.ansi().fgBrightMagenta().a(Ansi.Attribute.INTENSITY_FAINT).a(s).reset().toString();
            }
            return s;
        }

        String exchangeIdAsValue() {
            if (this.value == null) {
                return "";
            }
            String s = this.value.toString();
            if (MessageTableHelper.this.loggingColor) {
                Ansi.Color color = MessageTableHelper.this.exchangeIdColorChooser != null ? MessageTableHelper.this.exchangeIdColorChooser.color(s) : Ansi.Color.DEFAULT;
                s = Ansi.ansi().fg(color).a(s).reset().toString();
            }
            return s;
        }

        int valueLength() {
            if (this.value == null) {
                return -1;
            }
            return this.valueAsString().length();
        }
    }
}

