/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.common.LoggingLevelCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="logger", description={"List or change logging levels"}, sortOptions=false, showDefaultValues=true)
public class LoggerAction
extends ActionBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--logging-level"}, completionCandidates=LoggingLevelCompletionCandidates.class, description={"To change logging level (${COMPLETION-CANDIDATES})"})
    String loggingLevel;
    @CommandLine.Option(names={"--logger"}, description={"The logger name"}, defaultValue="root")
    String logger;

    public LoggerAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (this.loggingLevel == null) {
            return this.callList();
        }
        if (this.name == null) {
            this.name = "*";
        }
        return this.callChangeLoggingLevel();
    }

    protected Integer callChangeLoggingLevel() throws Exception {
        List<Long> pids = this.findPids(this.name);
        for (long pid : pids) {
            JsonObject root = new JsonObject();
            root.put((Object)"action", (Object)"logger");
            Path f = this.getActionFile(Long.toString(pid));
            root.put((Object)"command", (Object)"set-logging-level");
            root.put((Object)"logger-name", (Object)this.logger);
            root.put((Object)"logging-level", (Object)this.loggingLevel);
            Files.writeString(f, (CharSequence)root.toJson(), new OpenOption[0]);
        }
        return 0;
    }

    protected Integer callList() {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids("*");
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject jo;
                Row row = new Row();
                row.pid = Long.toString(ph.pid());
                row.uptime = LoggerAction.extractSince(ph);
                row.ago = TimeUtils.printSince((long)row.uptime);
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                if ((jo = (JsonObject)root.get((Object)"logger")) != null) {
                    Map levels = jo.getMap("levels");
                    levels.forEach((k, v) -> {
                        Row cp = row.copy();
                        cp.logger = k;
                        cp.level = v;
                        rows.add(cp);
                    });
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.ago), new Column().header("LOGGER").dataAlign(HorizontalAlign.LEFT).with(r -> r.logger), new Column().header("LEVEL").dataAlign(HorizontalAlign.RIGHT).with(r -> r.level))));
        }
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String ago;
        long uptime;
        String logger;
        String level;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

