/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Run;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.action.MessageTableHelper;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.main.KameletMain;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;

@CommandLine.Command(name="send", description={"Send messages to endpoints"}, sortOptions=false, showDefaultValues=true)
public class CamelSendAction
extends ActionBaseCommand {
    @CommandLine.Parameters(description={"To use an existing running Camel integration for sending the message (name or pid)"}, arity="0..1")
    String name;
    @CommandLine.Option(names={"--endpoint", "--uri"}, description={"Endpoint where to send the message (can be uri, pattern, or refer to a route id)"})
    String endpoint;
    @CommandLine.Option(names={"--poll"}, description={"Poll instead of sending a message. This can be used to receive latest message from a Kafka topic or JMS queue."})
    boolean poll;
    @CommandLine.Option(names={"--reply"}, description={"Whether to expect a reply message (InOut vs InOut messaging style)"})
    boolean reply;
    @CommandLine.Option(names={"--reply-file"}, description={"Saves reply message to the file with the given name (override if exists)"})
    String replyFile;
    @CommandLine.Option(names={"--body"}, description={"Message body to send (prefix with file: to refer to loading message body from file)"})
    String body;
    @CommandLine.Option(names={"--header"}, description={"Message header (key=value)"})
    List<String> headers;
    @CommandLine.Option(names={"--timeout"}, defaultValue="20000", description={"Timeout in millis waiting for message to be sent (and reply message if InOut messaging)"})
    long timeout = 20000L;
    @CommandLine.Option(names={"--show-exchange-properties"}, defaultValue="false", description={"Show exchange properties from response message (InOut)"})
    boolean showExchangeProperties;
    @CommandLine.Option(names={"--show-exchange-variables"}, defaultValue="false", description={"Show exchange variables from response message (InOut)"})
    boolean showExchangeVariables;
    @CommandLine.Option(names={"--show-headers"}, defaultValue="true", description={"Show message headers from response message (InOut)"})
    boolean showHeaders = true;
    @CommandLine.Option(names={"--show-body"}, defaultValue="true", description={"Show message body from response message (InOut)"})
    boolean showBody = true;
    @CommandLine.Option(names={"--show-exception"}, defaultValue="true", description={"Show exception and stacktrace for failed messages"})
    boolean showException = true;
    @CommandLine.Option(names={"--pretty"}, description={"Pretty print response message body (InOut) when using JSon or XML format"})
    boolean pretty;
    @CommandLine.Option(names={"--logging-color"}, defaultValue="true", description={"Use colored logging"})
    boolean loggingColor = true;
    private volatile long pid;
    private MessageTableHelper tableHelper;

    public CamelSendAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (this.headers != null) {
            for (String h : this.headers) {
                if (h.contains("=")) continue;
                this.printer().println("Header must be in key=value format, was: " + h);
                return 0;
            }
        }
        if (this.name != null) {
            return this.doCall(this.name);
        }
        return this.doCallLocal();
    }

    protected Path writeSendData() {
        Comparable<Path> f;
        Path outputFile = this.getOutputFile(Long.toString(this.pid));
        PathUtils.deleteFile(outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"send");
        root.put((Object)"endpoint", (Object)this.endpoint);
        root.put((Object)"poll", (Object)this.poll);
        if (this.timeout < 5000L) {
            this.timeout = 5000L;
        }
        root.put((Object)"pollTimeout", (Object)this.timeout);
        String mep = this.reply || this.replyFile != null ? "InOut" : "InOnly";
        root.put((Object)"exchangePattern", (Object)mep);
        if (this.body != null) {
            if (this.body.startsWith("file:") && ((File)(f = new File(this.body.substring(5)))).exists() && ((File)f).isFile()) {
                this.body = "file:" + ((File)f).getAbsolutePath();
            }
            root.put((Object)"body", (Object)this.body);
        }
        if (this.headers != null) {
            JsonArray arr = new JsonArray();
            for (String h : this.headers) {
                JsonObject jo = new JsonObject();
                jo.put((Object)"key", (Object)StringHelper.before((String)h, (String)"="));
                jo.put((Object)"value", (Object)StringHelper.after((String)h, (String)"="));
                arr.add((Object)jo);
            }
            root.put((Object)"headers", (Object)arr);
        }
        f = this.getActionFile(Long.toString(this.pid));
        try {
            String text = root.toJson();
            Files.writeString(f, (CharSequence)text, new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outputFile;
    }

    public Integer doCall(String name) throws Exception {
        List<Long> pids = this.findPids(name);
        if (pids.size() != 1) {
            this.printer().println("Name or pid " + name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        this.pid = pids.get(0);
        Path outputFile = this.writeSendData();
        this.showStatus(outputFile);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showStatus(Path outputFile) throws Exception {
        block14: {
            try {
                JsonObject jo = this.waitForOutputFile(outputFile);
                if (jo != null) {
                    this.printStatusLine(jo);
                    String exchangeId = jo.getString("exchangeId");
                    JsonObject message = (JsonObject)jo.getMap("message");
                    JsonObject cause = (JsonObject)jo.getMap("exception");
                    if (message == null && cause == null) break block14;
                    if (this.replyFile != null) {
                        Path target = Path.of(this.replyFile, new String[0]);
                        String json = jo.toJson();
                        if (this.pretty) {
                            json = Jsoner.prettyPrint((String)json, (int)2);
                        }
                        try {
                            Files.writeString(target, (CharSequence)json, new OpenOption[0]);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!this.showExchangeProperties && message != null) {
                        message.remove((Object)"exchangeProperties");
                    }
                    if (!this.showExchangeVariables && message != null) {
                        message.remove((Object)"exchangeVariables");
                    }
                    if (!this.showHeaders && message != null) {
                        message.remove((Object)"headers");
                    }
                    if (!this.showBody && message != null) {
                        message.remove((Object)"body");
                    }
                    if (!this.showException && cause != null) {
                        cause = null;
                    }
                    if (this.replyFile == null) {
                        this.tableHelper = new MessageTableHelper();
                        this.tableHelper.setPretty(this.pretty);
                        this.tableHelper.setLoggingColor(this.loggingColor);
                        this.tableHelper.setShowExchangeProperties(this.showExchangeProperties);
                        this.tableHelper.setShowExchangeVariables(this.showExchangeVariables);
                        String mep = this.reply || this.replyFile != null ? "InOut" : "InOnly";
                        String table = this.tableHelper.getDataAsTable(exchangeId, mep, jo, null, message, cause);
                        this.printer().println(table);
                    }
                    break block14;
                }
                this.printer().println("Send timeout");
            }
            finally {
                PathUtils.deleteFile(outputFile);
            }
        }
    }

    private Integer doCallLocal() throws Exception {
        final AtomicReference ref = new AtomicReference();
        Run run = new Run(this.getMain()){

            @Override
            protected int runKameletMain(KameletMain main) throws Exception {
                ref.set(main);
                return super.runKameletMain(main);
            }
        };
        run.empty = true;
        final CountDownLatch latch = new CountDownLatch(1);
        this.pid = ProcessHandle.current().pid();
        final Path outputFile = this.writeSendData();
        Thread t = new Thread("CamelJBangSendStatus"){

            @Override
            public void run() {
                try {
                    CamelSendAction.this.showStatus(outputFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    latch.countDown();
                    KameletMain main = (KameletMain)ref.get();
                    if (main != null) {
                        main.completed();
                    }
                }
            }
        };
        t.start();
        Integer exit = run.call();
        latch.await(this.timeout + 10000L, TimeUnit.MILLISECONDS);
        return exit;
    }

    private void printStatusLine(JsonObject jo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String ts = sdf.format(new Date(jo.getLong("timestamp")));
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(ts).reset());
        } else {
            this.printer().print(ts);
        }
        this.printer().print("  ");
        String p = String.format("%5.5s", this.pid);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgMagenta().a(p).reset());
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(" --- ").reset());
        } else {
            this.printer().print(p);
            this.printer().print(" --- ");
        }
        String ids = jo.getString("endpoint");
        if (ids != null) {
            if (ids.length() > 40) {
                ids = ids.substring(0, 40);
            }
            ids = String.format("%40.40s", ids);
            if (this.loggingColor) {
                AnsiConsole.out().print((Object)Ansi.ansi().fgCyan().a(ids).reset());
            } else {
                this.printer().print(ids);
            }
        }
        this.printer().print(" : ");
        this.printer().print(this.getStatus(jo));
        String e = TimeUtils.printDuration((long)jo.getLong("elapsed"), (boolean)true);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(" (" + e + ")").reset());
        } else {
            this.printer().print("(" + e + ")");
        }
        this.printer().println();
    }

    private String getStatus(JsonObject r) {
        String status;
        boolean failed = "failed".equals(r.getString("status")) || "error".equals(r.getString("status"));
        boolean timeout = "timeout".equals(r.getString("status"));
        boolean reply = r.containsKey((Object)"message");
        Ansi.Color c = Ansi.Color.GREEN;
        if (failed) {
            status = "Failed (exception)";
            c = Ansi.Color.RED;
        } else if (this.replyFile != null) {
            status = this.poll ? "Poll save to fill (success)" : "Reply save to file (success)";
        } else if (reply) {
            status = this.poll ? "Poll received (success)" : "Reply received (success)";
        } else if (timeout) {
            status = "Timeout";
            c = Ansi.Color.YELLOW;
        } else {
            status = this.poll ? "Poll (success)" : "Sent (success)";
        }
        if (this.loggingColor) {
            return Ansi.ansi().fg(c).a(status).reset().toString();
        }
        return status;
    }

    protected JsonObject waitForOutputFile(Path outputFile) {
        StopWatch watch = new StopWatch();
        long wait = this.timeout + 10000L;
        while (watch.taken() < wait) {
            File f = outputFile.toFile();
            try {
                Thread.sleep(20L);
                if (!Files.exists(outputFile, new LinkOption[0]) || f.length() <= 0L) continue;
                String text = Files.readString(outputFile);
                return (JsonObject)Jsoner.deserialize((String)text);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

