/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

@CommandLine.Command(name="route-dump", description={"Dump Camel route in XML or YAML format"}, sortOptions=false, showDefaultValues=true)
public class CamelRouteDumpAction
extends ActionBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--format"}, description={"Output format (xml or yaml)"}, defaultValue="xml")
    String format;
    @CommandLine.Option(names={"--raw"}, description={"To output raw without metadata"})
    boolean raw;
    @CommandLine.Option(names={"--uri-as-parameters"}, description={"Whether to expand URIs into separated key/value parameters (only in use for YAML format)"})
    boolean uriAsParameters;
    @CommandLine.Option(names={"--filter"}, description={"Filter route by filename (multiple names can be separated by comma)"})
    String filter;
    @CommandLine.Option(names={"--sort"}, completionCandidates=NameIdCompletionCandidates.class, description={"Sort route by name or id"}, defaultValue="name")
    String sort;
    private volatile long pid;

    public CamelRouteDumpAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        this.pid = pids.get(0);
        Path outputFile = this.getOutputFile(Long.toString(this.pid));
        PathUtils.deleteFile(outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"route-dump");
        root.put((Object)"filter", (Object)"*");
        root.put((Object)"format", (Object)this.format);
        root.put((Object)"uriAsParameters", (Object)this.uriAsParameters);
        Path file = this.getActionFile(Long.toString(this.pid));
        try {
            Files.writeString(file, (CharSequence)root.toJson(), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject jo = this.waitForOutputFile(outputFile);
        if (jo != null) {
            JsonArray arr = (JsonArray)jo.get((Object)"routes");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject o = (JsonObject)arr.get(i);
                Row row = new Row();
                row.location = CamelRouteDumpAction.extractSourceName(o.getString("source"));
                row.routeId = o.getString("routeId");
                if (rows.contains(row)) continue;
                List lines = (List)o.getCollection("code");
                if (lines != null) {
                    for (JsonObject line : lines) {
                        Code code = new Code();
                        code.line = line.getInteger("line");
                        code.code = line.getString("code");
                        row.code.add(code);
                    }
                }
                boolean add = true;
                if (this.filter != null) {
                    Object f = this.filter;
                    boolean negate = this.filter.startsWith("-");
                    if (negate) {
                        f = ((String)f).substring(1);
                    }
                    if (!((String)f).endsWith("*")) {
                        f = (String)f + "*";
                    }
                    boolean match = PatternHelper.matchPattern((String)row.location, (String)f);
                    if (negate) {
                        boolean bl = match = !match;
                    }
                    if (!match) {
                        add = false;
                    }
                }
                if (!add) continue;
                rows.add(row);
            }
        } else {
            this.printer().println("Response from running Camel with PID " + this.pid + " not received within 5 seconds");
            return 1;
        }
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printSource(rows);
        }
        PathUtils.deleteFile(outputFile);
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "name": {
                return o1.location.compareToIgnoreCase(o2.location) * negate;
            }
            case "id": {
                return o1.routeId.compareToIgnoreCase(o2.routeId) * negate;
            }
        }
        return 0;
    }

    protected void printSource(List<Row> rows) {
        for (Row row : rows) {
            this.printer().println();
            if (!this.raw) {
                this.printer().printf("Source: %s%n", row.location);
                this.printer().println("--------------------------------------------------------------------------------");
            }
            for (int i = 0; i < row.code.size(); ++i) {
                Code code = row.code.get(i);
                String c = Jsoner.unescape((String)code.code);
                if (this.raw) {
                    this.printer().printf("%s%n", c);
                    continue;
                }
                this.printer().printf("%4d: %s%n", code.line, c);
            }
            this.printer().println();
        }
    }

    protected JsonObject waitForOutputFile(Path outputFile) {
        return CamelRouteDumpAction.getJsonObject(outputFile);
    }

    public static String extractSourceName(String loc) {
        if ((loc = LoggerHelper.stripSourceLocationLineNumber((String)loc)) != null && loc.contains(":")) {
            loc = loc.substring(loc.indexOf(58) + 1);
            loc = FileUtil.stripPath((String)loc);
        }
        return loc;
    }

    private static class Row {
        String location;
        String routeId;
        List<Code> code = new ArrayList<Code>();

        private Row() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            if (!Objects.equals(this.location, row.location)) {
                return false;
            }
            return this.routeId.equals(row.routeId);
        }

        public int hashCode() {
            return this.routeId.hashCode();
        }
    }

    private static class Code {
        int line;
        String code;

        private Code() {
        }
    }

    public static class NameIdCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("name", "id").iterator();
        }
    }
}

