/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.camel.catalog.impl.TimePatternConverter;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.action.MessageTableHelper;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.fusesource.jansi.Ansi;
import picocli.CommandLine;

@CommandLine.Command(name="receive", description={"Receive and dump messages from remote endpoints"}, sortOptions=false, showDefaultValues=true)
public class CamelReceiveAction
extends ActionBaseCommand {
    private static final int NAME_MAX_WIDTH = 25;
    private static final int NAME_MIN_WIDTH = 10;
    private CommandHelper.ReadConsoleTask waitUserTask;
    @CommandLine.Parameters(description={"Name or pid of running Camel integration. (default selects all)"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--action"}, completionCandidates=ActionCompletionCandidates.class, defaultValue="status", description={"Action to start, stop, clear, list status, or dump messages"})
    String action;
    @CommandLine.Option(names={"--endpoint", "--uri"}, description={"Endpoint to receive messages from (can be uri or pattern to refer to existing endpoint)"})
    String endpoint;
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age for showing status of messages"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--follow"}, defaultValue="true", description={"Keep following and outputting new messages (press enter to exit)."})
    boolean follow = true;
    @CommandLine.Option(names={"--prefix"}, defaultValue="auto", completionCandidates=PrefixCompletionCandidates.class, description={"Print prefix with running Camel integration name. auto=only prefix when running multiple integrations. true=always prefix. false=prefix off."})
    String prefix = "auto";
    @CommandLine.Option(names={"--tail"}, defaultValue="-1", description={"The number of messages from the end to show. Use -1 to read from the beginning. Use 0 to read only new lines. Defaults to showing all messages from beginning."})
    int tail = -1;
    @CommandLine.Option(names={"--since"}, description={"Return messages newer than a relative duration like 5s, 2m, or 1h. The value is in seconds if no unit specified."})
    String since;
    @CommandLine.Option(names={"--find"}, description={"Find and highlight matching text (ignore case)."}, arity="0..*")
    String[] find;
    @CommandLine.Option(names={"--grep"}, description={"Filter messages to only output matching text (ignore case)."}, arity="0..*")
    String[] grep;
    @CommandLine.Option(names={"--show-exchange-properties"}, defaultValue="false", description={"Show exchange properties in received messages"})
    boolean showExchangeProperties;
    @CommandLine.Option(names={"--show-exchange-variables"}, defaultValue="false", description={"Show exchange variables in received messages"})
    boolean showExchangeVariables;
    @CommandLine.Option(names={"--show-headers"}, defaultValue="true", description={"Show message headers in received messages"})
    boolean showHeaders = true;
    @CommandLine.Option(names={"--show-body"}, defaultValue="true", description={"Show message body in received messages"})
    boolean showBody = true;
    @CommandLine.Option(names={"--only-body"}, defaultValue="false", description={"Show only message body in received messages"})
    boolean onlyBody;
    @CommandLine.Option(names={"--logging-color"}, defaultValue="true", description={"Use colored logging"})
    boolean loggingColor = true;
    @CommandLine.Option(names={"--compact"}, defaultValue="true", description={"Compact output (no empty line separating messages)"})
    boolean compact = true;
    @CommandLine.Option(names={"--short-uri"}, description={"List endpoint URI without query parameters (short)"})
    boolean shortUri;
    @CommandLine.Option(names={"--wide-uri"}, description={"List endpoint URI in full details"})
    boolean wideUri;
    @CommandLine.Option(names={"--mask"}, description={"Whether to mask endpoint URIs to avoid printing sensitive information such as password or access keys"})
    boolean mask;
    @CommandLine.Option(names={"--pretty"}, description={"Pretty print message body when using JSon or XML format"})
    boolean pretty;
    String findAnsi;
    private int nameMaxWidth;
    private boolean prefixShown;
    private MessageTableHelper tableHelper;
    private final Map<String, Ansi.Color> nameColors = new HashMap<String, Ansi.Color>();

    public CamelReceiveAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        boolean autoDump = false;
        if (this.endpoint != null) {
            this.action = "start";
            autoDump = true;
        }
        if ("dump".equals(this.action)) {
            return this.doDumpCall();
        }
        if ("status".equals(this.action)) {
            return this.doStatusCall();
        }
        List<Long> pids = this.findPids(this.name);
        for (long pid : pids) {
            String error;
            if ("clear".equals(this.action)) {
                Path f = this.getReceiveFile("" + pid);
                if (!Files.exists(f, new LinkOption[0])) continue;
                Files.writeString(f, (CharSequence)"{}", new OpenOption[0]);
                continue;
            }
            Path outputFile = this.getOutputFile(Long.toString(pid));
            PathUtils.deleteFile(outputFile);
            JsonObject root = new JsonObject();
            root.put((Object)"action", (Object)"receive");
            if ("start".equals(this.action)) {
                root.put((Object)"enabled", (Object)"true");
                if (this.endpoint != null) {
                    root.put((Object)"endpoint", (Object)this.endpoint);
                } else {
                    root.put((Object)"endpoint", (Object)"*");
                }
            } else if ("stop".equals(this.action)) {
                root.put((Object)"enabled", (Object)"false");
            }
            Path f = this.getActionFile(Long.toString(pid));
            Files.writeString(f, (CharSequence)root.toJson(), new OpenOption[0]);
            JsonObject jo = this.waitForOutputFile(outputFile);
            if (jo == null || (error = jo.getString("error")) == null) continue;
            error = Jsoner.unescape((String)error);
            String url = jo.getString("url");
            List stackTrace = (List)jo.getCollection("stackTrace");
            if (url != null) {
                this.printer().println("Error starting to receive messages from: " + url + " due to: " + error);
            } else {
                this.printer().println("Error starting to receive messages due to: " + error);
            }
            this.printer().println(StringHelper.fillChars((char)'-', (int)120));
            this.printer().println(StringHelper.padString((int)1, (int)55) + "STACK-TRACE");
            this.printer().println(StringHelper.fillChars((char)'-', (int)120));
            StringBuilder sb = new StringBuilder();
            for (String s : stackTrace) {
                sb.append(String.format("\t%s%n", s));
            }
            this.printer().println(String.valueOf(sb));
        }
        if (autoDump) {
            return this.doDumpCall();
        }
        return 0;
    }

    protected JsonObject waitForOutputFile(Path outputFile) {
        return CamelReceiveAction.getJsonObject(outputFile);
    }

    protected Integer doStatusCall() {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                StatusRow row = new StatusRow();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                row.uptime = CamelReceiveAction.extractSince(ph);
                row.age = TimeUtils.printSince((long)row.uptime);
                JsonObject jo = (JsonObject)root.getMap("receive");
                if (jo != null) {
                    row.enabled = jo.getBoolean("enabled");
                    row.counter = jo.getLong("total");
                    row.firstTimestamp = jo.getLongOrDefault("firstTimestamp", 0L);
                    row.lastTimestamp = jo.getLongOrDefault("lastTimestamp", 0L);
                    JsonArray arr = (JsonArray)jo.getCollection("endpoints");
                    if (arr != null) {
                        for (Object e : arr) {
                            jo = (JsonObject)e;
                            row.uri = jo.getString("uri");
                            if (this.mask) {
                                row.uri = URISupport.sanitizeUri((String)row.uri);
                            }
                            rows.add(row);
                            row = row.copy();
                        }
                    } else {
                        rows.add(row);
                    }
                }
            }
        });
        rows.sort(this::sortStatusRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.age), new Column().header("STATUS").with(this::getStatus), new Column().header("TOTAL").with(r -> r.enabled ? "" + r.counter : ""), new Column().header("SINCE").headerAlign(HorizontalAlign.CENTER).with(this::getMessageAgo), new Column().header("ENDPOINT").visible(!this.wideUri).dataAlign(HorizontalAlign.LEFT).maxWidth(90, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getEndpointUri), new Column().header("ENDPOINT").visible(this.wideUri).dataAlign(HorizontalAlign.LEFT).maxWidth(140, OverflowBehaviour.NEWLINE).with(r -> r.uri))));
        }
        return 0;
    }

    private String getStatus(StatusRow r) {
        if (r.enabled) {
            return "Enabled";
        }
        return "Disabled";
    }

    protected int sortStatusRow(StatusRow o1, StatusRow o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    protected Integer doDumpCall() throws Exception {
        this.tableHelper = new MessageTableHelper();
        this.tableHelper.setPretty(this.pretty);
        this.tableHelper.setLoggingColor(this.loggingColor);
        LinkedHashMap<Long, Pid> pids = new LinkedHashMap<Long, Pid>();
        this.updatePids(pids);
        if (!pids.isEmpty()) {
            String f;
            int i;
            if (this.find != null) {
                this.findAnsi = Ansi.ansi().fg(Ansi.Color.BLACK).bg(Ansi.Color.YELLOW).a("$0").reset().toString();
                for (i = 0; i < this.find.length; ++i) {
                    f = this.find[i];
                    this.find[i] = f = Pattern.quote(f);
                }
            }
            if (this.grep != null) {
                this.findAnsi = Ansi.ansi().fg(Ansi.Color.BLACK).bg(Ansi.Color.YELLOW).a("$0").reset().toString();
                for (i = 0; i < this.grep.length; ++i) {
                    f = this.grep[i];
                    this.grep[i] = f = Pattern.quote(f);
                }
            }
            Date limit = null;
            if (this.since != null) {
                long millis = StringHelper.isDigit((String)this.since) ? TimePatternConverter.toMilliSeconds((String)this.since) * 1000L : TimePatternConverter.toMilliSeconds((String)this.since);
                limit = new Date(System.currentTimeMillis() - millis);
            }
            if (this.tail != 0) {
                this.tailReceiveFiles(pids, this.tail);
                this.dumpReceiveFiles(pids, this.tail, limit);
            }
        }
        if (this.follow) {
            boolean waitMessage = true;
            AtomicBoolean running = new AtomicBoolean(true);
            Thread t = new Thread(() -> {
                this.waitUserTask = new CommandHelper.ReadConsoleTask(() -> running.set(false));
                this.waitUserTask.run();
            }, "WaitForUser");
            t.start();
            boolean more = true;
            boolean init = true;
            StopWatch watch = new StopWatch();
            do {
                int lines;
                if (pids.isEmpty()) {
                    if (waitMessage) {
                        this.printer().println("Waiting for messages ...");
                        waitMessage = false;
                    }
                    Thread.sleep(500L);
                    this.updatePids(pids);
                    continue;
                }
                waitMessage = true;
                if (watch.taken() > 500L) {
                    this.updatePids(pids);
                    watch.restart();
                }
                if ((lines = this.readReceiveFiles(pids)) > 0) {
                    more = this.dumpReceiveFiles(pids, 0, null);
                    init = false;
                    continue;
                }
                if (lines != 0) break;
                if (init) {
                    this.printer().println("Waiting for messages ...");
                    init = false;
                }
                Thread.sleep(100L);
            } while (more && running.get());
        }
        return 0;
    }

    private void tailReceiveFiles(Map<Long, Pid> pids, int tail) throws Exception {
        for (Pid pid : pids.values()) {
            String line;
            Path file = this.getReceiveFile(pid.pid);
            if (!Files.exists(file, new LinkOption[0]) || Files.size(file) <= 0L) continue;
            pid.reader = new LineNumberReader(Files.newBufferedReader(file));
            pid.fifo = tail <= 0 ? new ArrayDeque<String>() : new ArrayBlockingQueue<String>(tail);
            do {
                if ((line = pid.reader.readLine()) == null) continue;
                while (!pid.fifo.offer(line)) {
                    pid.fifo.poll();
                }
            } while (line != null);
        }
    }

    private void updatePids(Map<Long, Pid> rows) {
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                int len;
                Pid row = new Pid();
                row.pid = Long.toString(ph.pid());
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                if ((len = row.name.length()) < 10) {
                    len = 10;
                }
                if (len > 25) {
                    len = 25;
                }
                if (len > this.nameMaxWidth) {
                    this.nameMaxWidth = len;
                }
                if (!rows.containsKey(ph.pid())) {
                    rows.put(ph.pid(), row);
                }
            }
        });
        HashSet<Long> remove = new HashSet<Long>();
        for (long pid : rows.keySet()) {
            if (pids.contains(pid)) continue;
            remove.add(pid);
        }
        for (long pid : remove) {
            rows.remove(pid);
        }
    }

    private int readReceiveFiles(Map<Long, Pid> pids) throws Exception {
        int lines = 0;
        for (Pid pid : pids.values()) {
            String line;
            Path file;
            if (pid.reader == null && Files.exists(file = this.getReceiveFile(pid.pid), new LinkOption[0])) {
                pid.reader = new LineNumberReader(Files.newBufferedReader(file));
                if (this.tail == 0) {
                    long size = Files.size(file);
                    pid.reader.skip(size);
                }
            }
            if (pid.reader == null) continue;
            do {
                try {
                    line = pid.reader.readLine();
                    if (line == null) continue;
                    ++lines;
                    if (pid.fifo == null || pid.fifo instanceof ArrayBlockingQueue) {
                        pid.fifo = new ArrayDeque<String>();
                    }
                    pid.fifo.offer(line);
                }
                catch (IOException e) {
                    line = null;
                }
            } while (line != null);
        }
        return lines;
    }

    private List<Row> parseReceiveLine(Pid pid, String line) {
        JsonObject root = null;
        try {
            root = (JsonObject)Jsoner.deserialize((String)line);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (root != null) {
            ArrayList<Row> rows = new ArrayList<Row>();
            JsonArray arr = (JsonArray)root.getCollection("messages");
            if (arr != null) {
                for (Object o : arr) {
                    Long ts;
                    JsonObject es;
                    Row row = new Row(pid);
                    row.pid = pid.pid;
                    row.name = pid.name;
                    JsonObject jo = (JsonObject)o;
                    row.uid = jo.getLong("uid");
                    String uri = jo.getString("endpointUri");
                    if (uri != null) {
                        row.endpoint = new JsonObject();
                        if (this.mask) {
                            uri = URISupport.sanitizeUri((String)uri);
                        }
                        row.endpoint.put((Object)"endpoint", (Object)uri);
                        row.endpoint.put((Object)"remote", (Object)jo.getBooleanOrDefault("remoteEndpoint", true));
                    }
                    if ((es = (JsonObject)jo.getMap("endpointService")) != null) {
                        row.endpointService = es;
                    }
                    if ((ts = jo.getLong("timestamp")) != null) {
                        row.timestamp = ts;
                    }
                    row.message = (JsonObject)jo.getMap("message");
                    row.message.remove((Object)"exchangeId");
                    row.message.remove((Object)"exchangePattern");
                    if (this.onlyBody) {
                        row.message.remove((Object)"exchangeProperties");
                        row.message.remove((Object)"exchangeVariables");
                        row.message.remove((Object)"headers");
                        row.message.remove((Object)"messageType");
                    } else {
                        if (!this.showExchangeProperties) {
                            row.message.remove((Object)"exchangeProperties");
                        }
                        if (!this.showExchangeVariables) {
                            row.message.remove((Object)"exchangeVariables");
                        }
                        if (!this.showHeaders) {
                            row.message.remove((Object)"headers");
                        }
                        if (!this.showBody) {
                            row.message.remove((Object)"body");
                        }
                    }
                    rows.add(row);
                }
            }
            return rows;
        }
        return null;
    }

    private boolean dumpReceiveFiles(Map<Long, Pid> pids, int tail, Date limit) {
        int pos;
        HashSet<String> names = new HashSet<String>();
        List<Row> rows = new ArrayList();
        for (Pid pid : pids.values()) {
            Queue<String> queue = pid.fifo;
            if (queue == null) continue;
            for (String l : queue) {
                names.add(pid.name);
                List<Row> parsed = this.parseReceiveLine(pid, l);
                if (parsed == null || parsed.isEmpty()) continue;
                rows.addAll(parsed);
            }
            pid.fifo.clear();
        }
        if (names.size() > 1) {
            HashMap lastTimestamp = new HashMap();
            rows.sort((r1, r2) -> {
                long t1 = r1.timestamp;
                long t2 = r2.timestamp;
                if (t1 == 0L) {
                    t1 = (Long)lastTimestamp.get(r1.name);
                }
                if (t1 == 0L) {
                    t1 = (Long)lastTimestamp.get(r2.name);
                }
                if (t1 == 0L && t2 == 0L) {
                    return 0;
                }
                if (t1 == 0L) {
                    return -1;
                }
                if (t2 == 0L) {
                    return 1;
                }
                lastTimestamp.put(r1.name, t1);
                lastTimestamp.put(r2.name, t2);
                return Long.compare(t1, t2);
            });
        }
        if (tail > 0 && (pos = rows.size() - tail) > 0) {
            rows = rows.subList(pos, rows.size());
        }
        for (Row r : rows) {
            this.printDump(r.name, pids.size(), r, limit);
        }
        return true;
    }

    private boolean isValidGrep(String line) {
        if (this.grep == null) {
            return true;
        }
        for (String g : this.grep) {
            boolean m = Pattern.compile("(?i)" + g).matcher(line).find();
            if (!m) continue;
            return true;
        }
        return false;
    }

    private boolean isValidSince(Date limit, long timestamp) {
        if (limit == null || timestamp == 0L) {
            return true;
        }
        Date row = new Date(timestamp);
        return row.compareTo(limit) >= 0;
    }

    protected void printDump(String name, int pids, Row row, Date limit) {
        boolean valid;
        if (!this.prefixShown && ("false".equals(this.prefix) || "auto".equals(this.prefix) && pids <= 1)) {
            name = null;
        }
        this.prefixShown = name != null;
        String data = this.getDataAsTable(row);
        boolean bl = valid = this.isValidSince(limit, row.timestamp) && this.isValidGrep(data);
        if (!valid) {
            return;
        }
        Object nameWithPrefix = null;
        if (name != null) {
            if (this.loggingColor) {
                Ansi.Color color = this.nameColors.get(name);
                if (color == null) {
                    int idx = this.nameColors.size() % 6 + 1;
                    color = Ansi.Color.values()[idx];
                    this.nameColors.put(name, color);
                }
                String n = String.format("%-" + this.nameMaxWidth + "s", name);
                nameWithPrefix = Ansi.ansi().fg(color).a(n).a("| ").reset().toString();
            } else {
                nameWithPrefix = String.format("%-" + this.nameMaxWidth + "s", name) + "| ";
            }
            this.printer().print((String)nameWithPrefix);
        }
        String header = String.format("Received Message: (%s)", row.uid);
        if (this.loggingColor) {
            this.printer().println(Ansi.ansi().fgGreen().a(header).reset().toString());
        } else {
            this.printer().println(header);
        }
        String[] lines = data.split(System.lineSeparator());
        if (lines.length > 0) {
            for (String line : lines) {
                if (this.find != null) {
                    for (String f : this.find) {
                        line = line.replaceAll("(?i)" + f, this.findAnsi);
                    }
                }
                if (this.grep != null) {
                    for (String g : this.grep) {
                        line = line.replaceAll("(?i)" + g, this.findAnsi);
                    }
                }
                if (nameWithPrefix != null) {
                    this.printer().print((String)nameWithPrefix);
                }
                this.printer().print(" ");
                this.printer().println(line);
            }
            if (!this.compact) {
                if (nameWithPrefix != null) {
                    this.printer().println((String)nameWithPrefix);
                } else {
                    this.printer().println();
                }
            }
        }
    }

    private String getDataAsTable(Row r) {
        return this.tableHelper.getDataAsTable(null, null, r.endpoint, r.endpointService, r.message, null);
    }

    protected String getEndpointUri(StatusRow r) {
        int pos;
        String u = r.uri;
        if (this.shortUri && (pos = u.indexOf(63)) > 0) {
            u = u.substring(0, pos);
        }
        return u;
    }

    protected String getMessageAgo(StatusRow r) {
        if (r.lastTimestamp > 0L) {
            return TimeUtils.printSince((long)r.lastTimestamp);
        }
        return "";
    }

    private static class StatusRow {
        String pid;
        String name;
        String age;
        long uptime;
        boolean enabled;
        long counter;
        long firstTimestamp;
        long lastTimestamp;
        String uri;

        private StatusRow() {
        }

        StatusRow copy() {
            try {
                return (StatusRow)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static class Pid {
        String pid;
        String name;
        Queue<String> fifo;
        LineNumberReader reader;

        private Pid() {
        }
    }

    private static class Row {
        Pid parent;
        String pid;
        String name;
        long uid;
        long timestamp;
        JsonObject endpoint;
        JsonObject endpointService;
        JsonObject message;

        Row(Pid parent) {
            this.parent = parent;
        }
    }

    public static class ActionCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("dump", "start", "stop", "status", "clear").iterator();
        }
    }

    public static class PrefixCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("auto", "true", "false").iterator();
        }
    }
}

