/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.nio.file.Path;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

public abstract class CamelProcessorAction
extends ActionBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--id"}, description={"Processor ids (multiple ids can be separated by comma)"}, defaultValue="*")
    String id = "*";

    public CamelProcessorAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        List<Long> pids = this.findPids(this.name);
        for (long pid : pids) {
            JsonObject root = new JsonObject();
            root.put((Object)"action", (Object)"processor");
            root.put((Object)"id", (Object)this.id);
            Path f = this.getActionFile(Long.toString(pid));
            this.onAction(root);
            PathUtils.writeTextSafely(root.toJson(), f);
        }
        return 0;
    }

    protected abstract void onAction(JsonObject var1);
}

