/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.nio.file.Path;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="gc", description={"Trigger Java Memory Garbage Collector"}, sortOptions=false, showDefaultValues=true)
public class CamelGCAction
extends ActionBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration. (default selects all)"}, arity="0..1")
    String name = "*";

    public CamelGCAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        List<Long> pids = this.findPids(this.name);
        for (long pid : pids) {
            JsonObject root = new JsonObject();
            root.put((Object)"action", (Object)"gc");
            Path f = this.getActionFile(Long.toString(pid));
            PathUtils.writeTextSafely(root.toJson(), f);
        }
        return 0;
    }
}

