/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Run;
import org.apache.camel.main.KameletMain;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import picocli.CommandLine;

@CommandLine.Command(name="route", description={"Transform Camel routes to XML or YAML format"}, sortOptions=false, showDefaultValues=true)
public class TransformRoute
extends CamelCommand {
    @CommandLine.Parameters(description={"The Camel file(s) to run. If no files specified then application.properties is used as source for which files to run."}, arity="0..9", paramLabel="<files>", parameterConsumer=FilesConsumer.class)
    Path[] filePaths;
    List<String> files = new ArrayList<String>();
    @CommandLine.Option(names={"--output"}, description={"File or directory to store transformed files. If none provide then output is printed to console."})
    private String output;
    @CommandLine.Option(names={"--format"}, description={"Output format (xml or yaml), if only yaml files are provided, the format defaults to xml and vice versa"})
    String format;
    @CommandLine.Option(names={"--resolve-placeholders"}, defaultValue="false", description={"Whether to resolve property placeholders in the dumped output"})
    boolean resolvePlaceholders;
    @CommandLine.Option(names={"--uri-as-parameters"}, defaultValue="true", description={"Whether to expand URIs into separated key/value parameters (only in use for YAML format)"})
    boolean uriAsParameters = true;
    @CommandLine.Option(names={"--ignore-loading-error"}, description={"Whether to ignore route loading and compilation errors (use this with care!)"})
    boolean ignoreLoadingError;

    public TransformRoute(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (this.format == null) {
            this.format = this.files.stream().allMatch(file -> file.endsWith(".yaml")) ? "xml" : "yaml";
        }
        Object dump = this.output;
        if (this.output == null) {
            dump = ".camel-jbang/transform-output." + this.format;
        }
        final String target = dump;
        Run run = new Run(this.getMain()){

            @Override
            protected void doAddInitialProperty(KameletMain main) {
                main.addInitialProperty("camel.main.dumpRoutes", TransformRoute.this.format);
                main.addInitialProperty("camel.main.dumpRoutesInclude", "routes,rests,routeConfigurations,beans,dataFormats");
                main.addInitialProperty("camel.main.dumpRoutesLog", "false");
                main.addInitialProperty("camel.main.dumpRoutesResolvePlaceholders", Boolean.toString(TransformRoute.this.resolvePlaceholders));
                main.addInitialProperty("camel.main.dumpRoutesUriAsParameters", Boolean.toString(TransformRoute.this.uriAsParameters));
                main.addInitialProperty("camel.main.dumpRoutesOutput", target);
                main.addInitialProperty("camel.jbang.transform", "true");
                main.addInitialProperty("camel.component.properties.ignoreMissingProperty", "true");
                if (this.ignoreLoadingError) {
                    main.addInitialProperty("camel.language.bean.validate", "false");
                }
            }
        };
        run.files = this.files;
        run.maxSeconds = 1;
        Integer exit = run.runTransform(this.ignoreLoadingError);
        if (exit != null && exit != 0) {
            return exit;
        }
        if (this.output == null && (dump = this.waitForDumpFile(Path.of(target, new String[0]))) != null) {
            this.printer().println((String)dump);
        }
        return 0;
    }

    protected String waitForDumpFile(Path dumpFile) {
        StopWatch watch = new StopWatch();
        while (watch.taken() < 5000L) {
            String string;
            block10: {
                Thread.sleep(100L);
                if (!Files.exists(dumpFile, new LinkOption[0])) continue;
                InputStream is = Files.newInputStream(dumpFile, new OpenOption[0]);
                try {
                    string = IOHelper.loadText((InputStream)is);
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception exception) {}
                }
                is.close();
            }
            return string;
        }
        return null;
    }

    static class FilesConsumer
    extends CamelCommand.ParameterConsumer<TransformRoute> {
        FilesConsumer() {
        }

        @Override
        protected void doConsumeParameters(Stack<String> args, TransformRoute cmd) {
            String arg = args.pop();
            cmd.files.add(arg);
        }
    }
}

