/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.nio.file.Path;
import java.util.Stack;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Run;
import org.apache.camel.dsl.jbang.core.common.LoggingLevelCompletionCandidates;
import picocli.CommandLine;

@CommandLine.Command(name="script", description={"Run Camel integration as shell script for terminal scripting"}, sortOptions=false, showDefaultValues=true)
public class Script
extends CamelCommand {
    @CommandLine.Parameters(description={"Name of file"}, arity="1", paramLabel="<file>", parameterConsumer=FileConsumer.class)
    Path filePath;
    String file;
    @CommandLine.Option(names={"--max-messages"}, defaultValue="0", description={"Max number of messages to process before stopping"})
    int maxMessages;
    @CommandLine.Option(names={"--max-seconds"}, defaultValue="0", description={"Max seconds to run before stopping"})
    int maxSeconds;
    @CommandLine.Option(names={"--max-idle-seconds"}, defaultValue="1", description={"For how long time in seconds Camel can be idle before stopping"})
    int maxIdleSeconds;
    @CommandLine.Option(names={"--logging"}, defaultValue="false", description={"Can be used to turn on logging (logs to file in <user home>/.camel directory)"})
    boolean logging;
    @CommandLine.Option(names={"--logging-level"}, completionCandidates=LoggingLevelCompletionCandidates.class, defaultValue="info", description={"Logging level (${COMPLETION-CANDIDATES})"})
    String loggingLevel;
    @CommandLine.Option(names={"--properties"}, description={"Load properties file for route placeholders (ex. /path/to/file.properties"})
    String propertiesFiles;
    @CommandLine.Option(names={"--prop", "--property"}, description={"Additional properties (override existing)"}, arity="0")
    String[] property;

    public Script(CamelJBangMain main) {
        super(main);
    }

    @Override
    public boolean disarrangeLogging() {
        return false;
    }

    @Override
    public Integer doCall() throws Exception {
        if (this.file != null && this.file.startsWith("./")) {
            this.file = this.file.substring(2);
        }
        Run run = new Run(this.getMain());
        run.logging = this.logging;
        run.loggingLevel = this.loggingLevel;
        run.loggingColor = false;
        run.maxSeconds = this.maxSeconds;
        run.maxMessages = this.maxMessages;
        run.maxIdleSeconds = this.maxIdleSeconds;
        run.property = this.property;
        run.propertiesFiles = this.propertiesFiles;
        return run.runScript(this.file);
    }

    static class FileConsumer
    extends CamelCommand.ParameterConsumer<Script> {
        FileConsumer() {
        }

        @Override
        protected void doConsumeParameters(Stack<String> args, Script cmd) {
            cmd.file = args.pop();
        }
    }
}

