/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ReflectionHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public final class RunHelper {
    private RunHelper() {
    }

    public static String mavenArtifactId(Path pomPath) {
        if (Files.exists(pomPath, new LinkOption[0]) && Files.isRegularFile(pomPath, new LinkOption[0])) {
            String string;
            block9: {
                MavenXpp3Reader mavenReader = new MavenXpp3Reader();
                BufferedReader reader = Files.newBufferedReader(pomPath);
                try {
                    Model model = mavenReader.read((Reader)reader);
                    model.setPomFile(pomPath.toFile());
                    string = model.getArtifactId();
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ((Reader)reader).close();
            }
            return string;
        }
        return null;
    }

    public static Model loadMavenModel(Path pomPath) throws Exception {
        Model answer = null;
        if (Files.exists(pomPath, new LinkOption[0]) && Files.isRegularFile(pomPath, new LinkOption[0])) {
            MavenXpp3Reader mavenReader = new MavenXpp3Reader();
            try (BufferedReader reader = Files.newBufferedReader(pomPath);){
                answer = mavenReader.read((Reader)reader);
                answer.setPomFile(pomPath.toFile());
            }
        }
        return answer;
    }

    public static List<String> scanMavenDependenciesFromPom(Path pomPath) throws Exception {
        Model model = RunHelper.loadMavenModel(pomPath);
        if (model != null) {
            return RunHelper.scanMavenDependenciesFromModel(pomPath, model, false);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<String> scanMavenDependenciesFromModel(Path pomPath, Model model, boolean includeDependencyManagement) throws Exception {
        String camelVersion = null;
        String camelSpringBootVersion = null;
        String springBootVersion = null;
        String quarkusVersion = null;
        StringJoiner sj = new StringJoiner(",");
        for (Repository r : model.getRepositories()) {
            sj.add(r.getUrl());
        }
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        if (sj.length() > 0) {
            downloader.setRepositories(sj.toString());
        }
        downloader.build();
        ArrayList<String> answer = new ArrayList<String>();
        if (model.getDependencyManagement() != null) {
            for (Dependency d : model.getDependencyManagement().getDependencies()) {
                String gav;
                String g = RunHelper.resolveDependencyPlaceholder(d.getGroupId(), pomPath, downloader);
                String a = RunHelper.resolveDependencyPlaceholder(d.getArtifactId(), pomPath, downloader);
                String v = RunHelper.resolveDependencyPlaceholder(d.getVersion(), pomPath, downloader);
                if (v == null) continue;
                if ("camel-bom".equals(a)) {
                    camelVersion = v;
                } else if ("camel-spring-boot-bom".equals(a)) {
                    camelSpringBootVersion = v;
                } else if ("org.springframework.boot".equals(g) && "spring-boot-dependencies".equals(a)) {
                    springBootVersion = v;
                } else if ("quarkus-bom".equals(a)) {
                    quarkusVersion = v;
                }
                if (!includeDependencyManagement || answer.contains(gav = "mvn:" + g + ":" + a + ":" + v)) continue;
                answer.add(gav);
            }
        }
        for (Dependency d : model.getDependencies()) {
            String scope = d.getScope();
            boolean accept = scope == null || "compile".equals(scope);
            if (!accept) continue;
            String g = RunHelper.resolveDependencyPlaceholder(d.getGroupId(), pomPath, downloader);
            String a = RunHelper.resolveDependencyPlaceholder(d.getArtifactId(), pomPath, downloader);
            String v = RunHelper.resolveDependencyPlaceholder(d.getVersion(), pomPath, downloader);
            if (v == null && "org.apache.camel".equals(g)) {
                v = camelVersion;
            } else if (v == null && "org.apache.camel.springboot".equals(g)) {
                v = camelSpringBootVersion;
            } else if (v == null && "org.springframework.boot".equals(g)) {
                v = springBootVersion;
            } else if (v == null && "io.quarkus.platform".equals(g)) {
                v = quarkusVersion;
            }
            String gav = "mvn:" + g + ":" + a;
            if (v != null) {
                gav = gav + ":" + v;
            }
            if (answer.contains(gav)) continue;
            answer.add(gav);
        }
        return answer;
    }

    private static String resolveDependencyPlaceholder(String value, Path pomPath, MavenDependencyDownloader downloader) {
        if (value != null && value.startsWith("${") && value.endsWith("}")) {
            value = value.substring(2, value.length() - 1);
            value = RunHelper.findMavenProperty(pomPath, value, downloader);
        }
        return value;
    }

    public static List<String> scanMavenOrGradleProject(Path parentPath) {
        ArrayList<String> answer = new ArrayList<String>();
        Stream<Path> s = Stream.concat(RunHelper.walk(Path.of(parentPath.toFile().getAbsolutePath(), "src/main/java")), RunHelper.walk(Path.of(parentPath.toFile().getAbsolutePath(), "src/main/resources")));
        s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).forEach(answer::add);
        return answer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findMavenProperty(Path pomPath, String placeholder, MavenDependencyDownloader downloader) {
        if (!Files.exists(pomPath, new LinkOption[0])) return null;
        if (!Files.isRegularFile(pomPath, new LinkOption[0])) return null;
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        try (BufferedReader reader = Files.newBufferedReader(pomPath);){
            boolean exists;
            Model model = mavenReader.read((Reader)reader);
            model.setPomFile(pomPath.toFile());
            String p = model.getProperties().getProperty(placeholder);
            if (p != null && p.startsWith("${") && p.endsWith("}")) {
                p = p.substring(2, p.length() - 1);
                p = model.getProperties().getProperty(p);
            }
            if (("project.version".equals(p) || "project.version".equals(placeholder)) && (p = model.getVersion()) == null && model.getParent() != null) {
                p = model.getParent().getVersion();
            }
            if (p != null) {
                String string = p;
                return string;
            }
            if (model.getParent() == null) return null;
            p = model.getParent().getRelativePath();
            if (p == null) return null;
            String dir = FileUtil.onlyPath((String)pomPath.toAbsolutePath().toString());
            p = FileUtil.compactPath((String)(dir + "/" + p));
            boolean bl = exists = Files.exists(pomPath = Paths.get(p, new String[0]), new LinkOption[0]) && Files.isRegularFile(pomPath, new LinkOption[0]);
            if (exists) {
                String string = RunHelper.findMavenProperty(pomPath, placeholder, downloader);
                return string;
            }
            if (downloader == null) return null;
            MavenArtifact ma = downloader.downloadArtifact(model.getParent().getGroupId(), model.getParent().getArtifactId() + ":pom", model.getParent().getVersion());
            if (ma == null) return null;
            String string = RunHelper.findMavenProperty(ma.getFile(), placeholder, downloader);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Deprecated
    public static String findMavenProperty(File f, String placeholder, MavenDependencyDownloader downloader) {
        return RunHelper.findMavenProperty(f.toPath(), placeholder, downloader);
    }

    public static Stream<Path> walk(Path dir) {
        try {
            if (Files.isDirectory(dir, new LinkOption[0])) {
                return Files.walk(dir, new FileVisitOption[0]);
            }
            return Stream.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isInCamelCatalog(String artifactId) {
        return RunHelper.isInCamelCatalog((CamelCatalog)new DefaultCamelCatalog(), artifactId);
    }

    public static boolean isInCamelCatalog(CamelCatalog catalog, String artifactId) {
        String a;
        for (String n : catalog.findComponentNames()) {
            a = catalog.componentModel(n).getArtifactId();
            if (!artifactId.equals(a)) continue;
            return true;
        }
        for (String n : catalog.findLanguageNames()) {
            a = catalog.languageModel(n).getArtifactId();
            if (!artifactId.equals(a)) continue;
            return true;
        }
        for (String n : catalog.findDataFormatNames()) {
            a = catalog.dataFormatModel(n).getArtifactId();
            if (!artifactId.equals(a)) continue;
            return true;
        }
        for (String n : catalog.findOtherNames()) {
            a = catalog.otherModel(n).getArtifactId();
            if (!artifactId.equals(a)) continue;
            return true;
        }
        return false;
    }

    public static void doWithFields(Class<?> clazz, ReflectionHelper.FieldCallback fc) throws IllegalArgumentException {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                fc.doWith(field);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void dirToFiles(String dir, List<String> files) {
        files.clear();
        try {
            Files.list(Paths.get(dir, new String[0])).filter(p -> {
                try {
                    return Files.isRegularFile(p, new LinkOption[0]) && !Files.isHidden(p);
                }
                catch (IOException e) {
                    return false;
                }
            }).forEach(f -> files.add(dir + "/" + String.valueOf(f.getFileName())));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void addCamelJBangCommand(List<String> cmds) {
        if (FileUtil.isWindows()) {
            String jbangDir = System.getenv().getOrDefault("JBANG_DIR", System.getProperty("user.home") + "\\.jbang");
            cmds.add(0, jbangDir + "\\bin\\camel.cmd");
        } else {
            cmds.add(0, "camel");
        }
    }
}

