/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.ExportQuarkus;
import org.apache.camel.dsl.jbang.core.commands.ExportSpringBoot;
import org.apache.camel.dsl.jbang.core.commands.RunHelper;
import org.apache.camel.dsl.jbang.core.common.CamelCommandHelper;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.GistHelper;
import org.apache.camel.dsl.jbang.core.common.GitHubHelper;
import org.apache.camel.dsl.jbang.core.common.LoggingLevelCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.dsl.jbang.core.common.PropertyResolver;
import org.apache.camel.dsl.jbang.core.common.RuntimeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeTypeConverter;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.Source;
import org.apache.camel.dsl.jbang.core.common.SourceHelper;
import org.apache.camel.dsl.jbang.core.common.SourceScheme;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.main.KameletMain;
import org.apache.camel.main.download.DownloadListener;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.camel.xml.io.util.XmlStreamDetector;
import org.apache.camel.xml.io.util.XmlStreamInfo;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run as local Camel integration"}, sortOptions=false, showDefaultValues=true)
public class Run
extends CamelCommand {
    public static final String RUN_JAVA_SH = "classpath:templates/run-java.sh";
    public static final String RUN_SETTINGS_FILE = "camel-jbang-run.properties";
    public static final String RUN_PLATFORM_DIR = ".camel-jbang-run";
    private static final String[] ACCEPTED_XML_ROOT_ELEMENT_NAMES = new String[]{"route", "routes", "routeTemplate", "routeTemplates", "templatedRoute", "templatedRoutes", "rest", "rests", "routeConfiguration", "beans", "blueprint", "camel"};
    private static final Set<String> ACCEPTED_XML_ROOT_ELEMENTS = new HashSet<String>(Arrays.asList(ACCEPTED_XML_ROOT_ELEMENT_NAMES));
    private static final String OPENAPI_GENERATED_FILE = ".camel-jbang/generated-openapi.yaml";
    private static final String CLIPBOARD_GENERATED_FILE = ".camel-jbang/generated-clipboard";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^\\s*package\\s+([a-zA-Z][.\\w]*)\\s*;.*$", 8);
    private static final Pattern CLASS_PATTERN = Pattern.compile("^\\s*public class\\s+([a-zA-Z0-9]*)[\\s+|;].*$", 8);
    public boolean exportRun;
    protected Path exportBaseDir;
    boolean scriptRun;
    boolean transformRun;
    boolean transformMessageRun;
    boolean debugRun;
    private Path logFile;
    public long spawnPid;
    private Printer quietPrinter;
    @CommandLine.Parameters(description={"The Camel file(s) to run. If no files specified then application.properties is used as source for which files to run."}, arity="0..9", paramLabel="<files>", parameterConsumer=FilesConsumer.class)
    Path[] filePaths;
    public List<String> files = new ArrayList<String>();
    @CommandLine.Option(names={"--runtime"}, completionCandidates=RuntimeCompletionCandidates.class, defaultValue="camel-main", converter={RuntimeTypeConverter.class}, description={"Runtime (${COMPLETION-CANDIDATES})"})
    RuntimeType runtime = RuntimeType.main;
    @CommandLine.Option(names={"--source-dir"}, description={"Source directory for dynamically loading Camel file(s) to run. When using this, then files cannot be specified at the same time."})
    String sourceDir;
    @CommandLine.Option(names={"--background"}, defaultValue="false", description={"Run in the background"})
    public boolean background;
    @CommandLine.Option(names={"--background-wait"}, defaultValue="true", description={"To wait for run in background to startup successfully, before returning"})
    public boolean backgroundWait = true;
    @CommandLine.Option(names={"--empty"}, defaultValue="false", description={"Run an empty Camel without loading source files"})
    public boolean empty;
    @CommandLine.Option(names={"--camel-version"}, description={"To run using a different Camel version than the default version."})
    String camelVersion;
    @CommandLine.Option(names={"--camel-spring-boot-version"}, description={"To run using a different Camel Spring Boot version than the default version."})
    String camelSpringBootVersion;
    @CommandLine.Option(names={"--kamelets-version"}, description={"Apache Camel Kamelets version"})
    String kameletsVersion;
    @CommandLine.Option(names={"--quarkus-group-id"}, description={"Quarkus Platform Maven groupId"}, defaultValue="io.quarkus.platform")
    String quarkusGroupId = "io.quarkus.platform";
    @CommandLine.Option(names={"--quarkus-artifact-id"}, description={"Quarkus Platform Maven artifactId"}, defaultValue="quarkus-bom")
    String quarkusArtifactId = "quarkus-bom";
    @CommandLine.Option(names={"--quarkus-version"}, description={"Quarkus Platform version"}, defaultValue="3.27.0")
    String quarkusVersion = "3.27.0";
    @CommandLine.Option(names={"--spring-boot-version"}, description={"Spring Boot version"}, defaultValue="3.5.7")
    String springBootVersion = "3.5.7";
    @CommandLine.Option(names={"--profile"}, scope=CommandLine.ScopeType.INHERIT, defaultValue="dev", description={"Profile to run (dev, test, or prod)."})
    String profile = "dev";
    @CommandLine.Option(names={"--dep", "--dependency"}, description={"Add additional dependencies"}, split=",")
    List<String> dependencies = new ArrayList<String>();
    @CommandLine.Option(names={"--repos"}, description={"Additional maven repositories (Use commas to separate multiple repositories)"})
    String repositories;
    @CommandLine.Option(names={"--gav"}, description={"The Maven group:artifact:version (used during exporting)"})
    String gav;
    @CommandLine.Option(names={"--maven-settings"}, description={"Optional location of Maven settings.xml file to configure servers, repositories, mirrors and proxies. If set to \"false\", not even the default ~/.m2/settings.xml will be used."})
    String mavenSettings;
    @CommandLine.Option(names={"--maven-settings-security"}, description={"Optional location of Maven settings-security.xml file to decrypt settings.xml"})
    String mavenSettingsSecurity;
    @CommandLine.Option(names={"--maven-central-enabled"}, defaultValue="true", description={"Whether downloading JARs from Maven Central repository is enabled"})
    boolean mavenCentralEnabled = true;
    @CommandLine.Option(names={"--maven-apache-snapshot-enabled"}, defaultValue="true", description={"Whether downloading JARs from ASF Maven Snapshot repository is enabled"})
    boolean mavenApacheSnapshotEnabled = true;
    @CommandLine.Option(names={"--fresh"}, defaultValue="false", description={"Make sure we use fresh (i.e. non-cached) resources"})
    boolean fresh;
    @CommandLine.Option(names={"--download"}, defaultValue="true", description={"Whether to allow automatic downloading JAR dependencies (over the internet)"})
    boolean download = true;
    @CommandLine.Option(names={"--package-scan-jars"}, defaultValue="false", description={"Whether to automatic package scan JARs for custom Spring or Quarkus beans making them available for Camel JBang"})
    boolean packageScanJars;
    @CommandLine.Option(names={"--jvm-debug"}, parameterConsumer=DebugConsumer.class, paramLabel="<true|false|port>", description={"To enable JVM remote debugging on port 4004 by default. The supported values are true to enable the remote debugging, false to disable the remote debugging or a number to use a custom port"})
    int jvmDebugPort;
    @CommandLine.Option(names={"--name"}, defaultValue="CamelJBang", description={"The name of the Camel application"})
    String name;
    @CommandLine.Option(names={"--exclude"}, description={"Exclude files by name or pattern"})
    List<String> excludes = new ArrayList<String>();
    @CommandLine.Option(names={"--logging"}, defaultValue="true", description={"Can be used to turn off logging"})
    boolean logging = true;
    @CommandLine.Option(names={"--logging-level"}, completionCandidates=LoggingLevelCompletionCandidates.class, defaultValue="info", description={"Logging level (${COMPLETION-CANDIDATES})"})
    String loggingLevel;
    @CommandLine.Option(names={"--logging-color"}, defaultValue="true", description={"Use colored logging"})
    boolean loggingColor = true;
    @CommandLine.Option(names={"--logging-json"}, defaultValue="false", description={"Use JSON logging (ECS Layout)"})
    boolean loggingJson;
    @CommandLine.Option(names={"--logging-config-path"}, description={"Path to file with custom logging configuration"})
    String loggingConfigPath;
    @CommandLine.Option(names={"--logging-category"}, description={"Used for individual logging levels (ex: org.apache.kafka=DEBUG)"})
    List<String> loggingCategory = new ArrayList<String>();
    @CommandLine.Option(names={"--max-messages"}, defaultValue="0", description={"Max number of messages to process before stopping"})
    int maxMessages;
    @CommandLine.Option(names={"--max-seconds"}, defaultValue="0", description={"Max seconds to run before stopping"})
    int maxSeconds;
    @CommandLine.Option(names={"--max-idle-seconds"}, defaultValue="0", description={"For how long time in seconds Camel can be idle before stopping"})
    int maxIdleSeconds;
    @CommandLine.Option(names={"--reload", "--dev"}, description={"Enables dev mode (live reload when source files are updated and saved)"})
    boolean dev;
    @CommandLine.Option(names={"--trace"}, defaultValue="false", description={"Enables trace logging of the routed messages"})
    boolean trace;
    @CommandLine.Option(names={"--properties"}, description={"comma separated list of properties file (ex. /path/to/file.properties,/path/to/other.properties"})
    String propertiesFiles;
    @CommandLine.Option(names={"--prop", "--property"}, description={"Additional properties (override existing)"}, arity="0")
    String[] property;
    @CommandLine.Option(names={"--stub"}, description={"Stubs all the matching endpoint with the given component name or pattern. Multiple names can be separated by comma. (all = everything)."})
    String stub;
    @CommandLine.Option(names={"--jfr"}, defaultValue="false", description={"Enables Java Flight Recorder saving recording to disk on exit"})
    boolean jfr;
    @CommandLine.Option(names={"--jfr-profile"}, description={"Java Flight Recorder profile to use (such as default or profile)"})
    String jfrProfile;
    @CommandLine.Option(names={"--local-kamelet-dir"}, description={"Local directory (or github link) for loading Kamelets (takes precedence). Multiple directories can be specified separated by comma."})
    String localKameletDir;
    @CommandLine.Option(names={"--port"}, description={"Embeds a local HTTP server on this port"}, defaultValue="8080")
    int port;
    @CommandLine.Option(names={"--management-port"}, description={"To use a dedicated port for HTTP management"})
    int managementPort = -1;
    @CommandLine.Option(names={"--console"}, defaultValue="false", description={"Developer console at /q/dev on local HTTP server (port 8080 by default)"})
    boolean console;
    @CommandLine.Option(names={"--health"}, defaultValue="false", description={"Deprecated: use --observe instead. Health check at /q/health on local HTTP server (port 8080 by default)"})
    boolean health;
    @CommandLine.Option(names={"--metrics"}, defaultValue="false", description={"Deprecated: use --observe instead. Metrics (Micrometer and Prometheus) at /q/metrics on local HTTP server (port 8080 by default)"})
    boolean metrics;
    @CommandLine.Option(names={"--observe"}, defaultValue="false", description={"Enable observability services"})
    boolean observe;
    @CommandLine.Option(names={"--modeline"}, defaultValue="true", description={"Whether to support JBang style //DEPS to specify additional dependencies"})
    boolean modeline = true;
    @CommandLine.Option(names={"--open-api"}, description={"Adds an OpenAPI spec from the given file (json or yaml file)"})
    String openapi;
    @CommandLine.Option(names={"--code"}, description={"Run the given text or file as Java DSL routes"})
    String code;
    @CommandLine.Option(names={"--verbose"}, defaultValue="false", description={"Verbose output of startup activity (dependency resolution and downloading"})
    boolean verbose;
    @CommandLine.Option(names={"--ignore-loading-error"}, defaultValue="false", description={"Whether to ignore route loading and compilation errors (use this with care!)"})
    protected boolean ignoreLoadingError;
    @CommandLine.Option(names={"--lazy-bean"}, defaultValue="false", description={"Whether to use lazy bean initialization (can help with complex classloading issues)"})
    protected boolean lazyBean;
    @CommandLine.Option(names={"--prompt"}, defaultValue="false", description={"Allow user to type in required parameters in prompt if not present in application"})
    boolean prompt;
    @CommandLine.Option(names={"--skip-plugins"}, defaultValue="false", description={"Skip plugins during export"})
    boolean skipPlugins;

    public Run(CamelJBangMain main) {
        super(main);
    }

    @Override
    public boolean disarrangeLogging() {
        if (this.exportRun) {
            return false;
        }
        if (RuntimeType.quarkus == this.runtime) {
            return true;
        }
        return RuntimeType.springBoot == this.runtime;
    }

    @Override
    public Integer doCall() throws Exception {
        if (!this.exportRun) {
            this.printConfigurationValues("Running integration with the following configuration:");
        }
        return this.run();
    }

    public Integer runExport() throws Exception {
        return this.runExport(false);
    }

    protected Integer runExport(boolean ignoreLoadingError) throws Exception {
        this.exportRun = true;
        this.ignoreLoadingError = ignoreLoadingError;
        return this.run();
    }

    protected Integer runTransform(boolean ignoreLoadingError) throws Exception {
        this.transformRun = true;
        this.ignoreLoadingError = ignoreLoadingError;
        this.name = "transform";
        return this.run();
    }

    public Integer runTransformMessage(String camelVersion, String repositories) throws Exception {
        this.transformMessageRun = true;
        this.background = true;
        this.camelVersion = camelVersion;
        this.repositories = repositories;
        this.empty = true;
        this.ignoreLoadingError = true;
        this.name = "transform";
        return this.run();
    }

    protected Integer runScript(String file) throws Exception {
        this.files.add(file);
        this.scriptRun = true;
        return this.run();
    }

    protected Integer runDebug() throws Exception {
        this.debugRun = true;
        return this.run();
    }

    private boolean isDebugMode() {
        return this.jvmDebugPort > 0;
    }

    private void writeSetting(KameletMain main, Properties existing, String key, String value) {
        String val;
        String string = val = existing != null ? existing.getProperty(key, value) : value;
        if (val != null) {
            main.addInitialProperty(key, val);
            this.writeSettings(key, val);
        }
    }

    private void writeSetting(KameletMain main, Properties existing, String key, Supplier<String> value) {
        String val;
        String string = val = existing != null ? existing.getProperty(key, value.get()) : value.get();
        if (val != null) {
            main.addInitialProperty(key, val);
            this.writeSettings(key, val);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Properties loadProfilePropertiesFile(Path file) throws Exception {
        String value;
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        if (Files.exists(file, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                prop.load(is);
            }
        }
        if ((value = prop.getProperty("camel.main.routesIncludePattern")) != null) {
            StringJoiner sj = new StringJoiner(",");
            for (String string : value.split(",")) {
                void var8_10;
                if (!string.contains(":")) {
                    String string2 = "file:" + string;
                }
                sj.add((CharSequence)var8_10);
            }
            value = sj.toString();
            prop.setProperty("camel.main.routesIncludePattern", value);
        }
        return prop;
    }

    /*
     * WARNING - void declaration
     */
    private int run() throws Exception {
        DefaultCamelCatalog catalog;
        String string;
        Object name;
        boolean autoDetectFiles;
        String[] codeFile;
        String name2;
        Path first;
        Path baseDir;
        if (!this.empty && !this.files.isEmpty() && this.sourceDir != null) {
            this.printer().printErr("Cannot specify both file(s) and source-dir at the same time.");
            return 1;
        }
        Path path = baseDir = this.exportBaseDir != null ? this.exportBaseDir : Path.of(".", new String[0]);
        if (this.sourceDir == null && this.files != null && this.files.size() == 1 && Files.isDirectory(first = Path.of(name2 = FileUtil.stripTrailingSeparator((String)this.files.get(0)), new String[0]), new LinkOption[0])) {
            baseDir = first;
            RunHelper.dirToFiles(name2, this.files);
        }
        if (!this.exportRun) {
            if (RuntimeType.quarkus == this.runtime) {
                return this.runQuarkus();
            }
            if (RuntimeType.springBoot == this.runtime) {
                return this.runSpringBoot();
            }
        }
        Path work = CommandLineHelper.getWorkDir();
        Run.removeDir(work);
        if (!Files.exists(work, new LinkOption[0])) {
            try {
                Files.createDirectories(work, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.printer().println("WARN: Failed to create working directory: " + String.valueOf(work.toAbsolutePath()));
            }
        }
        Properties profileProperties = !this.empty ? this.loadProfileProperties(baseDir) : null;
        this.configureLogging(baseDir);
        if (this.openapi != null) {
            this.generateOpenApi();
        }
        if (!this.empty && this.code != null) {
            String name3 = "CodeRoute";
            boolean file = false;
            Path codePath = Paths.get(this.code, new String[0]);
            if (Files.isRegularFile(codePath, new LinkOption[0]) && Files.exists(codePath, new LinkOption[0])) {
                boolean java = codePath.getFileName().toString().endsWith(".java");
                if (!java) {
                    this.printer().printErr("Only java source files is accepted when using --code parameter");
                    return 1;
                }
                this.code = Files.readString(codePath);
                name3 = FileUtil.onlyName((String)codePath.getFileName().toString());
                file = true;
            }
            codeFile = this.loadFromCode(this.code, name3, file);
            this.files.add(0, (String)codeFile);
        }
        boolean bl = autoDetectFiles = this.files.isEmpty() || RUN_JAVA_SH.equals(this.files.get(0));
        if (!this.empty && autoDetectFiles) {
            if (this.sourceDir != null) {
                try {
                    Path sourceDirPath = Paths.get(this.sourceDir, new String[0]);
                    Files.list(sourceDirPath).forEach(p -> this.files.add(sourceDirPath.resolve(p.getFileName()).toString()));
                }
                catch (IOException sourceDirPath) {}
            } else {
                String routes;
                String string2 = routes = profileProperties != null ? profileProperties.getProperty("camel.main.routesIncludePattern") : null;
                if (routes == null) {
                    if (!this.exportRun) {
                        String run = "run";
                        if (this.transformRun) {
                            run = "transform";
                        } else if (this.debugRun) {
                            run = "debug";
                        }
                        System.err.println("Cannot " + run + " because application.properties file does not exist or camel.main.routesIncludePattern is not configured");
                        return 1;
                    }
                    try {
                        Files.list(Paths.get(".", new String[0])).map(p -> p.getFileName().toString()).forEach(this.files::add);
                    }
                    catch (IOException run) {
                        // empty catch block
                    }
                }
            }
        }
        if (!this.files.isEmpty()) {
            this.files = this.files.stream().distinct().collect(Collectors.toList());
        }
        KameletMain main = this.createMainInstance();
        main.setProfile(this.profile);
        if (this.repositories != null && !this.repositories.isBlank()) {
            main.setRepositories(this.repositories);
        }
        main.setDownload(this.download);
        main.setPackageScanJars(this.packageScanJars);
        main.setFresh(this.fresh);
        main.setMavenSettings(this.mavenSettings);
        main.setMavenSettingsSecurity(this.mavenSettingsSecurity);
        main.setMavenCentralEnabled(this.mavenCentralEnabled);
        main.setMavenApacheSnapshotEnabled(this.mavenApacheSnapshotEnabled);
        main.setDownloadListener((DownloadListener)new RunDownloadListener());
        main.setAppName("Apache Camel (JBang)");
        if (this.stub != null) {
            if ("all".equals(this.stub)) {
                this.stub = "*";
            }
            String[] sj = new StringJoiner(",");
            codeFile = this.stub.split(",");
            int n = codeFile.length;
            for (int i = 0; i < n; ++i) {
                Object n2 = codeFile[i];
                boolean colon = ((String)n2).contains(":");
                if (!colon && !((String)n2).endsWith("*")) {
                    n2 = (String)n2 + "*";
                }
                sj.add((CharSequence)n2);
            }
            this.stub = sj.toString();
            this.writeSetting(main, profileProperties, "camel.jbang.stub", this.stub);
            main.setStubPattern(this.stub);
        }
        if (this.dev) {
            this.writeSetting(main, profileProperties, "camel.main.routesReloadEnabled", "true");
            this.writeSetting(main, profileProperties, "camel.main.shutdownTimeout", "5");
        }
        if (this.sourceDir != null) {
            this.writeSetting(main, profileProperties, "camel.jbang.sourceDir", this.sourceDir);
        }
        if (this.trace) {
            this.writeSetting(main, profileProperties, "camel.main.tracing", "true");
        }
        if (this.modeline) {
            this.writeSetting(main, profileProperties, "camel.main.modeline", "true");
            main.configure().withModeline(true);
        }
        if (this.ignoreLoadingError) {
            this.writeSetting(main, profileProperties, "camel.jbang.ignoreLoadingError", "true");
        }
        if (this.lazyBean) {
            this.writeSetting(main, profileProperties, "camel.jbang.lazyBean", "true");
        }
        if (this.prompt) {
            this.writeSetting(main, profileProperties, "camel.jbang.prompt", "true");
        }
        this.writeSetting(main, profileProperties, "camel.jbang.compileWorkDir", Paths.get(".camel-jbang", "compile").toString());
        if (this.gav != null) {
            this.writeSetting(main, profileProperties, "camel.jbang.gav", this.gav);
        }
        this.writeSetting(main, profileProperties, "camel.jbang.openApi", this.openapi);
        if (this.repositories != null) {
            this.writeSetting(main, profileProperties, "camel.jbang.repos", this.repositories);
        }
        this.writeSetting(main, profileProperties, "camel.jbang.health", this.health ? "true" : "false");
        this.writeSetting(main, profileProperties, "camel.jbang.metrics", this.metrics ? "true" : "false");
        this.writeSetting(main, profileProperties, "camel.jbang.console", this.console ? "true" : "false");
        this.writeSetting(main, profileProperties, "camel.jbang.verbose", this.verbose ? "true" : "false");
        this.writeSetting(main, profileProperties, "camel.jbang.camel-version", new DefaultCamelCatalog().getCatalogVersion());
        this.writeSetting(main, profileProperties, "camel.jbang.springBootVersion", this.springBootVersion);
        this.writeSetting(main, profileProperties, "camel.jbang.quarkusVersion", this.quarkusVersion);
        this.writeSetting(main, profileProperties, "camel.jbang.quarkusGroupId", this.quarkusGroupId);
        this.writeSetting(main, profileProperties, "camel.jbang.quarkusArtifactId", this.quarkusArtifactId);
        if (this.observe) {
            main.addInitialProperty("camel.jbang.dependencies", "camel:observability-services");
        }
        if (this.property != null) {
            for (String p2 : this.property) {
                String k = StringHelper.before((String)p2, (String)"=");
                String v2 = StringHelper.after((String)p2, (String)"=");
                if (k == null || v2 == null) continue;
                main.addArgumentProperty(k, v2);
                this.writeSettings(k, v2);
            }
        }
        if (this.exportRun) {
            if (!this.verbose) {
                main.setSilent(true);
            }
            main.addInitialProperty("camel.jbang.export", "true");
            main.setStubPattern("*");
            main.addInitialProperty("camel.main.autoStartup", "false");
            main.addInitialProperty("camel.main.durationMaxSeconds", "-1");
        } else if (this.debugRun) {
            main.addInitialProperty("camel.jbang.debug", "true");
        } else if (this.transformRun) {
            main.setSilent(true);
            main.setStubPattern("*");
            main.addInitialProperty("camel.main.autoStartup", "false");
            main.addInitialProperty("camel.main.durationMaxSeconds", "-1");
        } else if (this.transformMessageRun) {
            main.addInitialProperty("camel.main.autoStartup", "false");
        } else if (this.scriptRun) {
            main.addInitialProperty("camel.main.durationMaxIdleSeconds", "1");
        }
        this.doAddInitialProperty(main);
        this.writeSetting(main, profileProperties, "camel.main.durationMaxMessages", () -> this.maxMessages > 0 ? String.valueOf(this.maxMessages) : null);
        this.writeSetting(main, profileProperties, "camel.main.durationMaxSeconds", () -> this.maxSeconds > 0 ? String.valueOf(this.maxSeconds) : null);
        this.writeSetting(main, profileProperties, "camel.main.durationMaxIdleSeconds", () -> this.maxIdleSeconds > 0 ? String.valueOf(this.maxIdleSeconds) : null);
        this.writeSetting(main, profileProperties, "camel.server.port", () -> this.port > 0 && this.port != 8080 ? String.valueOf(this.port) : null);
        if (this.managementPort != -1) {
            this.writeSetting(main, profileProperties, "camel.management.port", () -> String.valueOf(this.managementPort));
        }
        this.writeSetting(main, profileProperties, "camel.jbang.jfr", this.jfr || this.jfrProfile != null ? "jfr" : null);
        this.writeSetting(main, profileProperties, "camel.jbang.jfr-profile", this.jfrProfile != null ? this.jfrProfile : null);
        this.writeSetting(main, profileProperties, "camel.jbang.kameletsVersion", this.kameletsVersion);
        StringJoiner js = new StringJoiner(",");
        StringJoiner sjReload = new StringJoiner(",");
        StringJoiner sjClasspathFiles = new StringJoiner(",");
        StringJoiner sjScriptFiles = new StringJoiner(",");
        StringJoiner sjGroovyFiles = new StringJoiner(",");
        StringJoiner sjTlsFiles = new StringJoiner(",");
        StringJoiner sjKamelets = new StringJoiner(",");
        StringJoiner sjJKubeFiles = new StringJoiner(",");
        if (this.openapi != null) {
            this.files.add(OPENAPI_GENERATED_FILE);
        }
        if (this.files.size() == 1 && (this.files.get(0).endsWith("pom.xml") || this.files.get(0).endsWith("build.gradle"))) {
            Path projectDir = Path.of(this.files.get(0), new String[0]).toAbsolutePath();
            if (this.name == null || "CamelJBang".equals(this.name)) {
                this.name = RunHelper.mavenArtifactId(projectDir);
            }
            this.files = RunHelper.scanMavenOrGradleProject(projectDir.getParent());
            List<String> list = RunHelper.scanMavenDependenciesFromPom(projectDir);
            this.addDependencies(list.toArray(new String[0]));
        }
        if (this.profile != null && Files.exists(Paths.get((String)(name = String.valueOf(baseDir) + "/application-" + this.profile + ".properties"), new String[0]), new LinkOption[0]) && !this.files.contains(name)) {
            this.files.add((String)name);
        }
        for (String string3 : this.files) {
            void var15_43;
            String string4;
            String string5;
            Path inputPath;
            void var15_40;
            void var15_36;
            if (string3.startsWith("clipboard") && !Files.exists(Paths.get(string3, new String[0]), new LinkOption[0])) {
                String string6 = this.loadFromClipboard(string3);
            } else {
                if (this.skipFile(string3)) continue;
                if (this.isScriptFile(string3)) {
                    sjScriptFiles.add(string3);
                    continue;
                }
                if (this.isGroovyFile(string3)) {
                    sjGroovyFiles.add("file:" + string3);
                    if (!this.dev) continue;
                    sjReload.add(string3);
                    continue;
                }
                if (this.isTlsFile(string3)) {
                    sjTlsFiles.add(string3);
                    continue;
                }
                if (this.jkubeFile(string3)) {
                    sjJKubeFiles.add(string3);
                    continue;
                }
                if (!this.knownFile(string3) && !string3.endsWith(".properties")) {
                    sjClasspathFiles.add(string3);
                    continue;
                }
            }
            if (var15_36.endsWith(".properties")) {
                void var15_38;
                if (!this.acceptPropertiesFile((String)var15_36)) continue;
                if (!ResourceHelper.hasScheme((String)var15_36) && !var15_36.startsWith("github:")) {
                    String string7 = "file:" + (String)var15_36;
                }
                this.propertiesFiles = ObjectHelper.isEmpty((String)this.propertiesFiles) ? var15_38 : this.propertiesFiles + "," + (String)var15_38;
                if (!this.dev || !var15_38.startsWith("file:")) continue;
                sjReload.add(var15_38.substring(5));
                continue;
            }
            if (!ResourceHelper.hasScheme((String)var15_36) && !var15_36.startsWith("github:")) {
                String string8 = "file:" + (String)var15_36;
            }
            if (!(!var15_40.startsWith("file:") || Files.exists(inputPath = Paths.get(var15_40.substring(5), new String[0]), new LinkOption[0]) && Files.isRegularFile(inputPath, new LinkOption[0]))) {
                this.printer().printErr("File does not exist: " + (String)var15_40);
                return 1;
            }
            if (var15_40.startsWith("file:") && var15_40.endsWith(".kamelet.yaml")) {
                sjKamelets.add((CharSequence)var15_40);
            }
            if (!var15_40.startsWith("https://github.com/") ? var15_40.startsWith("https://gist.github.com/") && (string5 = this.evalGistSource(main, (String)var15_40)) == null : (string4 = this.evalGithubSource(main, (String)var15_40)) == null) continue;
            if ("CamelJBang".equals(this.name)) {
                String s = StringHelper.after((String)var15_43, (String)":");
                if (s.contains(":")) {
                    s = StringHelper.afterLast((String)s, (String)":");
                }
                this.name = FileUtil.onlyName((String)s);
            }
            js.add((CharSequence)var15_43);
            if (!this.dev || !var15_43.startsWith("file:")) continue;
            sjReload.add(var15_43.substring(5));
        }
        this.writeSetting(main, profileProperties, "camel.main.name", this.name);
        if (this.sourceDir != null) {
            Path dirPath = Paths.get(this.sourceDir, new String[0]);
            if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) {
                this.printer().printErr("Directory does not exist: " + this.sourceDir);
                return 1;
            }
            String string9 = "file:" + this.sourceDir + "/**?optional=true";
            main.addInitialProperty("camel.main.routesIncludePattern", string9);
            this.writeSettings("camel.main.routesIncludePattern", string9);
        } else if (js.length() > 0) {
            main.addInitialProperty("camel.main.routesIncludePattern", js.toString());
            this.writeSettings("camel.main.routesIncludePattern", js.toString());
        } else {
            this.writeSetting(main, profileProperties, "camel.main.routesIncludePattern", () -> null);
        }
        if (sjClasspathFiles.length() > 0) {
            main.addInitialProperty("camel.jbang.classpathFiles", sjClasspathFiles.toString());
            this.writeSettings("camel.jbang.classpathFiles", sjClasspathFiles.toString());
        } else {
            this.writeSetting(main, profileProperties, "camel.jbang.classpathFiles", () -> null);
        }
        if (sjScriptFiles.length() > 0) {
            main.addInitialProperty("camel.jbang.scriptFiles", sjScriptFiles.toString());
            this.writeSettings("camel.jbang.scriptFiles", sjScriptFiles.toString());
        } else {
            this.writeSetting(main, profileProperties, "camel.jbang.scriptFiles", () -> null);
        }
        if (sjGroovyFiles.length() > 0) {
            main.addInitialProperty("camel.jbang.groovyFiles", sjGroovyFiles.toString());
            this.writeSettings("camel.jbang.groovyFiles", sjGroovyFiles.toString());
        } else {
            this.writeSetting(main, profileProperties, "camel.jbang.groovyFiles", () -> null);
        }
        if (sjTlsFiles.length() > 0) {
            main.addInitialProperty("camel.jbang.tlsFiles", sjTlsFiles.toString());
            this.writeSettings("camel.jbang.tlsFiles", sjTlsFiles.toString());
        } else {
            this.writeSetting(main, profileProperties, "camel.jbang.tlsFiles", () -> null);
        }
        if (sjJKubeFiles.length() > 0) {
            main.addInitialProperty("camel.jbang.jkubeFiles", sjJKubeFiles.toString());
            this.writeSettings("camel.jbang.jkubeFiles", sjJKubeFiles.toString());
        } else {
            this.writeSetting(main, profileProperties, "camel.jbang.jkubeFiles", () -> null);
        }
        if (sjKamelets.length() > 0) {
            Object loc = main.getInitialProperties().getProperty("camel.component.kamelet.location");
            loc = loc != null ? (String)loc + "," + String.valueOf(sjKamelets) : sjKamelets.toString();
            main.addInitialProperty("camel.component.kamelet.location", (String)loc);
            this.writeSettings("camel.component.kamelet.location", (String)loc);
        } else {
            this.writeSetting(main, profileProperties, "camel.component.kamelet.location", () -> null);
        }
        this.setupReload(main, sjReload);
        if (this.propertiesFiles != null) {
            String[] filesLocation = this.propertiesFiles.split(",");
            ArrayList<String> arrayList = new ArrayList<String>(List.of(filesLocation));
            arrayList.sort((o1, o2) -> {
                if (o1.endsWith("application.properties")) {
                    return 1;
                }
                if (o2.endsWith("application.properties")) {
                    return -1;
                }
                return 0;
            });
            StringBuilder locations = new StringBuilder();
            for (String string10 : arrayList) {
                void var18_51;
                if (!string10.startsWith("file:")) {
                    void var18_54;
                    if (!string10.startsWith("/")) {
                        String string11 = Paths.get(FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath().toString(), string10).toString();
                    }
                    String string12 = "file://" + (String)var18_54;
                }
                if (!locations.isEmpty()) {
                    locations.append(",");
                }
                locations.append((String)var18_51);
            }
            Object loc = main.getInitialProperties().getProperty("camel.component.properties.location");
            loc = loc != null ? (String)loc + "," + String.valueOf(locations) : locations.toString();
            main.addInitialProperty("camel.component.properties.location", (String)loc);
            this.writeSettings("camel.component.properties.location", (String)loc);
            main.setPropertyPlaceholderLocations((String)loc);
        }
        this.addDependencies(RuntimeUtil.getDependenciesAsArray(profileProperties));
        if (!this.dependencies.isEmpty()) {
            String joined = String.join((CharSequence)",", this.dependencies);
            main.addInitialProperty("camel.jbang.dependencies", joined);
            this.writeSettings("camel.jbang.dependencies", joined);
        }
        if (this.camelVersion != null && this.camelVersion.equals(string = (catalog = new DefaultCamelCatalog()).getCatalogVersion())) {
            this.camelVersion = null;
        }
        if (!this.exportRun && this.camelVersion != null || this.isDebugMode()) {
            boolean custom = false;
            if (this.camelVersion != null) {
                boolean bl2 = custom = this.camelVersion.contains("-") && !this.camelVersion.endsWith("-SNAPSHOT");
                if (custom) {
                    boolean bl3 = custom = !this.camelVersion.matches(".*-(RC|M)\\d$");
                }
            }
            if (custom) {
                return this.runCustomCamelVersion(main);
            }
            return this.runCamelVersion(main);
        }
        if (this.debugRun) {
            return this.runDebug(main);
        }
        if (this.background) {
            return this.runBackground(main);
        }
        try {
            return this.runKameletMain(main);
        }
        catch (Exception ex) {
            if (this.ignoreLoadingError) {
                this.printer().printErr(ex);
                return 0;
            }
            throw ex;
        }
    }

    protected void addDependencies(String ... deps) {
        String[] depsArray = Optional.ofNullable(deps).orElse(new String[0]);
        List<String> depsList = Arrays.stream(depsArray).filter(tok -> !tok.isEmpty()).toList();
        this.dependencies.addAll(depsList);
    }

    protected int runQuarkus() throws Exception {
        if (this.background) {
            this.printer().println("Run Camel Quarkus with --background is not supported");
            return 1;
        }
        AtomicReference<Process> processRef = new AtomicReference<Process>();
        Path runDirPath = Paths.get(RUN_PLATFORM_DIR, Long.toString(System.currentTimeMillis()));
        if (!this.background) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Process process = (Process)processRef.get();
                    if (process != null) {
                        process.destroy();
                        for (int i = 0; i < 30 && process.isAlive(); ++i) {
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    Run.removeDir(runDirPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }
        Files.createDirectories(runDirPath, new FileAttribute[0]);
        ExportQuarkus eq = new ExportQuarkus(this.getMain());
        eq.javaLiveReload = this.dev;
        eq.symbolicLink = this.dev;
        eq.mavenWrapper = true;
        eq.gradleWrapper = false;
        eq.quarkusVersion = PropertyResolver.fromSystemProperty("camel.jbang.quarkusVersion", () -> this.quarkusVersion);
        eq.quarkusGroupId = PropertyResolver.fromSystemProperty("camel.jbang.quarkusGroupId", () -> this.quarkusGroupId);
        eq.quarkusArtifactId = PropertyResolver.fromSystemProperty("camel.jbang.quarkusArtifactId", () -> this.quarkusArtifactId);
        eq.camelVersion = this.camelVersion;
        eq.kameletsVersion = this.kameletsVersion;
        eq.exportDir = runDirPath.toString();
        eq.localKameletDir = this.localKameletDir;
        eq.excludes = this.excludes;
        eq.filePaths = this.filePaths;
        eq.files = this.files;
        eq.name = this.name;
        eq.verbose = this.verbose;
        eq.port = this.port;
        eq.managementPort = this.managementPort;
        eq.gav = this.gav;
        if (eq.gav == null) {
            if (eq.name == null) {
                eq.name = "jbang-run-dummy";
            }
            eq.gav = "org.example.project:" + eq.name + ":1.0-SNAPSHOT";
        }
        eq.dependencies = this.dependencies;
        eq.addDependencies("camel:cli-connector");
        eq.fresh = this.fresh;
        eq.download = this.download;
        eq.skipPlugins = this.skipPlugins;
        eq.packageScanJars = this.packageScanJars;
        eq.quiet = true;
        eq.logging = false;
        eq.loggingLevel = "off";
        eq.ignoreLoadingError = this.ignoreLoadingError;
        eq.lazyBean = this.lazyBean;
        eq.applicationProperties = this.property;
        this.printer().println("Running using Quarkus v" + eq.quarkusVersion + " (preparing and downloading files)");
        int exit = eq.export();
        if (exit != 0) {
            return exit;
        }
        String mvnw = "/mvnw";
        if (FileUtil.isWindows()) {
            mvnw = "/mvnw.cmd";
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(String.valueOf(runDirPath) + mvnw, "--quiet", "--file", runDirPath.toRealPath(new LinkOption[0]).resolve("pom.xml").toString(), "package", "quarkus:" + (this.dev ? "dev" : "run"));
        pb.inheritIO();
        Process p = pb.start();
        processRef.set(p);
        this.spawnPid = p.pid();
        return p.waitFor();
    }

    protected int runSpringBoot() throws Exception {
        if (this.background) {
            this.printer().println("Run Camel Spring Boot with --background is not supported");
            return 1;
        }
        AtomicReference<Process> processRef = new AtomicReference<Process>();
        Path runDirPath = Paths.get(RUN_PLATFORM_DIR, Long.toString(System.currentTimeMillis()));
        if (!this.background) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Process process = (Process)processRef.get();
                    if (process != null) {
                        process.destroy();
                        for (int i = 0; i < 30 && process.isAlive(); ++i) {
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    Run.removeDir(runDirPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }
        Files.createDirectories(runDirPath, new FileAttribute[0]);
        ExportSpringBoot eq = new ExportSpringBoot(this.getMain());
        eq.javaLiveReload = false;
        eq.symbolicLink = this.dev;
        eq.mavenWrapper = true;
        eq.gradleWrapper = false;
        eq.springBootVersion = this.springBootVersion;
        eq.camelVersion = this.camelVersion;
        eq.camelSpringBootVersion = PropertyResolver.fromSystemProperty("camel.jbang.camelSpringBootVersion", () -> this.camelSpringBootVersion != null ? this.camelSpringBootVersion : this.camelVersion);
        eq.kameletsVersion = this.kameletsVersion;
        eq.exportDir = runDirPath.toString();
        eq.localKameletDir = this.localKameletDir;
        eq.excludes = this.excludes;
        eq.filePaths = this.filePaths;
        eq.files = this.files;
        eq.name = this.name;
        eq.verbose = this.verbose;
        eq.port = this.port;
        eq.managementPort = this.managementPort;
        eq.gav = this.gav;
        eq.repositories = this.repositories;
        if (eq.gav == null) {
            if (eq.name == null) {
                eq.name = "jbang-run-dummy";
            }
            eq.gav = "org.example.project:" + eq.name + ":1.0-SNAPSHOT";
        }
        eq.dependencies.addAll(this.dependencies);
        eq.addDependencies("camel:cli-connector");
        if (this.dev) {
            eq.addDependencies("mvn:org.springframework.boot:spring-boot-devtools");
        }
        eq.fresh = this.fresh;
        eq.download = this.download;
        eq.skipPlugins = this.skipPlugins;
        eq.packageScanJars = this.packageScanJars;
        eq.quiet = true;
        eq.logging = false;
        eq.loggingLevel = "off";
        eq.ignoreLoadingError = this.ignoreLoadingError;
        eq.lazyBean = this.lazyBean;
        eq.applicationProperties = this.property;
        this.printer().println("Running using Spring Boot v" + eq.springBootVersion + " (preparing and downloading files)");
        int exit = eq.export();
        if (exit != 0) {
            return exit;
        }
        try (InputStream is = Run.class.getClassLoader().getResourceAsStream("spring-boot-logback.xml");){
            Path logbackPath = Paths.get(eq.exportDir, "src/main/resources/logback.xml");
            Files.createDirectories(logbackPath.getParent(), new FileAttribute[0]);
            Files.copy(is, logbackPath, StandardCopyOption.REPLACE_EXISTING);
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        String mvnw = "/mvnw";
        if (FileUtil.isWindows()) {
            mvnw = "/mvnw.cmd";
        }
        pb.command(String.valueOf(runDirPath) + mvnw, "--quiet", "--file", runDirPath.toRealPath(new LinkOption[0]).resolve("pom.xml").toString(), "spring-boot:run");
        pb.inheritIO();
        Process p = pb.start();
        processRef.set(p);
        this.spawnPid = p.pid();
        return p.waitFor();
    }

    private boolean acceptPropertiesFile(String file) {
        String name = FileUtil.onlyName((String)file);
        if (this.profile != null && name.startsWith("application-")) {
            return ("application-" + this.profile).equals(name);
        }
        return true;
    }

    protected void doAddInitialProperty(KameletMain main) {
    }

    private void setupReload(KameletMain main, StringJoiner sjReload) {
        if (this.dev && (this.sourceDir != null || sjReload.length() > 0)) {
            main.addInitialProperty("camel.main.routesReloadEnabled", "true");
            if (this.sourceDir != null) {
                main.addInitialProperty("camel.jbang.sourceDir", this.sourceDir);
                main.addInitialProperty("camel.main.routesReloadDirectory", this.sourceDir);
                main.addInitialProperty("camel.main.routesReloadPattern", "*");
                main.addInitialProperty("camel.main.routesReloadDirectoryRecursive", "true");
            } else {
                String pattern = sjReload.toString();
                String reloadDir = ".";
                for (String r : sjReload.toString().split(",")) {
                    String path = FileUtil.onlyPath((String)r);
                    if (path == null || path.equals(".camel-jbang")) continue;
                    reloadDir = path;
                    break;
                }
                main.addInitialProperty("camel.main.routesReloadDirectory", reloadDir);
                main.addInitialProperty("camel.main.routesReloadPattern", pattern);
                main.addInitialProperty("camel.main.routesReloadDirectoryRecursive", Run.isReloadRecursive(pattern) ? "true" : "false");
            }
            main.addInitialProperty("camel.main.durationMaxAction", "stop");
        }
    }

    private Properties loadProfileProperties(Path baseDir) throws Exception {
        Properties override;
        Properties answer = null;
        if (this.transformMessageRun) {
            return answer;
        }
        Path profilePropertiesPath = this.sourceDir != null ? Paths.get(this.sourceDir, new String[0]).resolve("application.properties") : baseDir.resolve("application.properties");
        answer = this.doLoadAndInitProfileProperties(profilePropertiesPath);
        if (this.profile != null && (override = this.doLoadAndInitProfileProperties(profilePropertiesPath = this.sourceDir != null ? Paths.get(this.sourceDir, new String[0]).resolve("application-" + this.profile + ".properties") : Paths.get("application-" + this.profile + ".properties", new String[0]))) != null) {
            if (answer == null) {
                answer = override;
            } else {
                answer.putAll((Map<?, ?>)override);
            }
        }
        if (this.kameletsVersion == null) {
            this.kameletsVersion = VersionHelper.extractKameletsVersion();
        }
        return answer;
    }

    private Properties doLoadAndInitProfileProperties(Path profilePropertiesPath) throws Exception {
        Properties answer = null;
        if (Files.exists(profilePropertiesPath, new LinkOption[0])) {
            answer = this.loadProfilePropertiesFile(profilePropertiesPath);
            this.loggingLevel = answer.getProperty("loggingLevel", this.loggingLevel);
            this.loggingColor = "true".equals(answer.getProperty("loggingColor", this.loggingColor ? "true" : "false"));
            this.loggingJson = "true".equals(answer.getProperty("loggingJson", this.loggingJson ? "true" : "false"));
            this.repositories = answer.getProperty("camel.jbang.repos", this.repositories);
            this.mavenSettings = answer.getProperty("camel.jbang.maven-settings", this.mavenSettings);
            this.mavenSettingsSecurity = answer.getProperty("camel.jbang.maven-settings-security", this.mavenSettingsSecurity);
            this.mavenCentralEnabled = "true".equals(answer.getProperty("camel.jbang.maven-central-enabled", this.mavenCentralEnabled ? "true" : "false"));
            this.mavenApacheSnapshotEnabled = "true".equals(answer.getProperty("camel.jbang.maven-apache-snapshot-enabled", this.mavenApacheSnapshotEnabled ? "true" : "false"));
            this.openapi = answer.getProperty("camel.jbang.openApi", this.openapi);
            this.download = "true".equals(answer.getProperty("camel.jbang.download", this.download ? "true" : "false"));
            this.packageScanJars = "true".equals(answer.getProperty("camel.jbang.packageScanJars", this.packageScanJars ? "true" : "false"));
            this.background = "true".equals(answer.getProperty("camel.jbang.background", this.background ? "true" : "false"));
            this.backgroundWait = "true".equals(answer.getProperty("camel.jbang.backgroundWait", this.backgroundWait ? "true" : "false"));
            this.jvmDebugPort = Run.parseJvmDebugPort(answer.getProperty("camel.jbang.jvmDebug", Integer.toString(this.jvmDebugPort)));
            this.camelVersion = answer.getProperty("camel.jbang.camel-version", this.camelVersion);
            this.kameletsVersion = answer.getProperty("camel.jbang.kameletsVersion", this.kameletsVersion);
            this.springBootVersion = answer.getProperty("camel.jbang.springBootVersion", this.springBootVersion);
            this.quarkusGroupId = answer.getProperty("camel.jbang.quarkusGroupId", this.quarkusGroupId);
            this.quarkusArtifactId = answer.getProperty("camel.jbang.quarkusArtifactId", this.quarkusArtifactId);
            this.quarkusVersion = answer.getProperty("camel.jbang.quarkusVersion", this.quarkusVersion);
            this.gav = answer.getProperty("camel.jbang.gav", this.gav);
            this.stub = answer.getProperty("camel.jbang.stub", this.stub);
            this.excludes = RuntimeUtil.getCommaSeparatedPropertyAsList(answer, "camel.jbang.excludes", this.excludes);
        }
        return answer;
    }

    private static int parseJvmDebugPort(String value) {
        if (value == null) {
            return 0;
        }
        if (value.equals("true")) {
            return 4004;
        }
        if (value.equals("false")) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    protected int runCamelVersion(KameletMain main) throws Exception {
        String debugSuspend;
        ArrayList<String> cmds;
        if (this.spec != null) {
            cmds = new ArrayList(this.spec.commandLine().getParseResult().originalArgs());
        } else {
            cmds = new ArrayList<String>();
            cmds.add("run");
            if (this.transformMessageRun) {
                cmds.add("--empty");
            }
        }
        if (this.background) {
            cmds.remove("--background=true");
            cmds.remove("--background");
            cmds.remove("--background-wait");
            cmds.remove("--background-wait=false");
            cmds.remove("--background-wait=true");
        }
        if (this.camelVersion != null) {
            cmds.remove("--camel-version=" + this.camelVersion);
        }
        ArrayList<String> jbangArgs = new ArrayList<String>();
        jbangArgs.add("jbang");
        jbangArgs.add("run");
        if (this.camelVersion != null) {
            jbangArgs.add("-Dcamel.jbang.version=" + this.camelVersion);
        }
        if (this.kameletsVersion != null) {
            jbangArgs.add("-Dcamel-kamelets.version=" + this.kameletsVersion);
        }
        if ((debugSuspend = System.getProperty("org.apache.camel.debugger.suspend")) != null) {
            jbangArgs.add("-Dorg.apache.camel.debugger.suspend=" + debugSuspend);
        }
        if (this.isDebugMode()) {
            jbangArgs.add("--debug=" + this.jvmDebugPort);
            cmds.removeIf(arg -> arg.startsWith("--jvm-debug"));
        }
        if (this.repositories != null) {
            jbangArgs.add("--repos=" + this.repositories);
        }
        jbangArgs.add("camel@apache/camel");
        jbangArgs.addAll(cmds);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(jbangArgs);
        if (this.background) {
            return this.runBackgroundProcess(pb, "Camel Main");
        }
        pb.inheritIO();
        Process p = pb.start();
        this.spawnPid = p.pid();
        return p.waitFor();
    }

    protected int runBackground(KameletMain main) throws Exception {
        ArrayList<String> cmds;
        if (this.spec != null) {
            cmds = new ArrayList(this.spec.commandLine().getParseResult().originalArgs());
        } else {
            cmds = new ArrayList<String>();
            cmds.add("run");
            if (this.transformMessageRun) {
                cmds.add("--empty");
            }
        }
        cmds.remove("--background=true");
        cmds.remove("--background");
        cmds.remove("--background-wait=false");
        cmds.remove("--background-wait=true");
        cmds.remove("--background-wait");
        RunHelper.addCamelJBangCommand(cmds);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(cmds);
        return this.runBackgroundProcess(pb, "Camel Main");
    }

    protected int runBackgroundProcess(ProcessBuilder pb, String kind) throws Exception {
        Path logPath = null;
        if (this.backgroundWait) {
            logPath = this.getRunBackgroundLogFile("" + new Random().nextLong());
            try {
                Path logDir = CommandLineHelper.getCamelDir();
                Files.createDirectories(logDir, new FileAttribute[0]);
                Files.createFile(logPath, new FileAttribute[0]);
                logPath.toFile().deleteOnExit();
            }
            catch (IOException logDir) {
                // empty catch block
            }
            pb.redirectErrorStream(true);
            pb.redirectOutput(logPath.toFile());
        }
        Process p = pb.start();
        this.spawnPid = p.pid();
        if (!(this.exportRun || this.transformRun || this.transformMessageRun)) {
            this.printer().println("Running " + kind + ": " + this.name + " in background with PID: " + p.pid() + (this.backgroundWait ? " (waiting to startup)" : ""));
        }
        int ec = 0;
        if (logPath != null) {
            StopWatch watch = new StopWatch();
            int state = 0;
            while (p.isAlive() && watch.taken() < 20000L && state < 5) {
                JsonObject context;
                JsonObject root = this.loadStatus(p.pid());
                if (root != null && (context = (JsonObject)root.get((Object)"context")) != null) {
                    state = context.getInteger("phase");
                }
                if (state >= 5) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    break;
                }
            }
            if (!p.isAlive()) {
                ec = p.exitValue();
                if (ec != 0) {
                    this.printer().println(kind + ": " + this.name + " startup failure");
                    this.printer().println("");
                    String text = Files.readString(logPath);
                    this.printer().print(text);
                }
            } else {
                this.printer().println(kind + ": " + this.name + " (state: " + CamelCommandHelper.extractState(state) + ")");
            }
        }
        if (logPath != null) {
            try {
                Files.deleteIfExists(logPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ec;
    }

    protected int runDebug(KameletMain main) throws Exception {
        return 0;
    }

    protected int runCustomCamelVersion(KameletMain main) throws Exception {
        ArrayList<String> cmds;
        InputStream is = Run.class.getClassLoader().getResourceAsStream("templates/run-custom-camel-version.tmpl");
        String content = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        content = content.replaceFirst("\\{\\{ \\.JavaVersion }}", "21");
        content = this.repositories != null ? content.replaceFirst("\\{\\{ \\.MavenRepositories }}", "//REPOS " + this.repositories) : content.replaceFirst("\\{\\{ \\.MavenRepositories }}", "");
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("//DEPS org.apache.camel:camel-bom:%s@pom%n", this.camelVersion));
        sb.append(String.format("//DEPS org.apache.camel:camel-core:%s%n", this.camelVersion));
        sb.append(String.format("//DEPS org.apache.camel:camel-core-engine:%s%n", this.camelVersion));
        sb.append(String.format("//DEPS org.apache.camel:camel-main:%s%n", this.camelVersion));
        sb.append(String.format("//DEPS org.apache.camel:camel-java-joor-dsl:%s%n", this.camelVersion));
        sb.append(String.format("//DEPS org.apache.camel:camel-kamelet:%s%n", this.camelVersion));
        sb.append(String.format("//DEPS org.apache.camel:camel-kamelet-main:%s%n", this.camelVersion));
        if (VersionHelper.isGE(this.camelVersion, "3.19.0")) {
            sb.append(String.format("//DEPS org.apache.camel:camel-cli-connector:%s%n", this.camelVersion));
        }
        content = content.replaceFirst("\\{\\{ \\.CamelDependencies }}", sb.toString());
        String v = this.camelVersion.substring(0, this.camelVersion.lastIndexOf(46));
        sb = new StringBuilder();
        sb.append(String.format("//DEPS org.apache.camel:camel-jbang-core:%s%n", v));
        sb.append(String.format("//DEPS org.apache.camel:camel-resourceresolver-github:%s%n", v));
        content = content.replaceFirst("\\{\\{ \\.CamelJBangDependencies }}", sb.toString());
        sb = new StringBuilder();
        sb.append(String.format("//DEPS org.apache.camel.kamelets:camel-kamelets:%s%n", this.kameletsVersion));
        content = content.replaceFirst("\\{\\{ \\.CamelKameletsDependencies }}", sb.toString());
        String fn = ".camel-jbang/CustomCamelJBang.java";
        Files.writeString(Paths.get(fn, new String[0]), (CharSequence)content, new OpenOption[0]);
        if (this.spec != null) {
            cmds = new ArrayList(this.spec.commandLine().getParseResult().originalArgs());
        } else {
            cmds = new ArrayList<String>();
            cmds.add("run");
        }
        if (this.background) {
            cmds.remove("--background=true");
            cmds.remove("--background");
            cmds.remove("--background-wait=true");
            cmds.remove("--background-wait=false");
            cmds.remove("--background-wait");
        }
        if (this.repositories != null && !VersionHelper.isGE(v, "3.18.1")) {
            cmds.remove("--repos=" + this.repositories);
        }
        cmds.remove("--camel-version=" + this.camelVersion);
        ArrayList<String> jbangArgs = new ArrayList<String>();
        jbangArgs.add("jbang");
        jbangArgs.add(".camel-jbang/CustomCamelJBang.java");
        jbangArgs.addAll(cmds);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(jbangArgs);
        if (this.background) {
            return this.runBackgroundProcess(pb, "Camel Main");
        }
        pb.inheritIO();
        Process p = pb.start();
        this.spawnPid = p.pid();
        return p.waitFor();
    }

    protected int runKameletMain(KameletMain main) throws Exception {
        main.start();
        main.run();
        if (this.logFile != null) {
            FileUtil.deleteFile((Path)this.logFile);
        }
        return main.getExitCode();
    }

    private String loadFromCode(String code, String name, boolean file) throws IOException {
        String fn = ".camel-jbang/" + name + ".java";
        InputStream is = Run.class.getClassLoader().getResourceAsStream("templates/code-java.tmpl");
        String content = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        if (!file) {
            code = ((String)code).replace("'", "\"");
            code = ((String)code).trim();
        }
        if (!((String)code).endsWith(";")) {
            code = (String)code + ";";
        }
        content = StringHelper.replaceFirst((String)content, (String)"{{ .Name }}", (String)name);
        content = StringHelper.replaceFirst((String)content, (String)"{{ .Code }}", (String)code);
        Files.writeString(Paths.get(fn, new String[0]), (CharSequence)content, new OpenOption[0]);
        return "file:" + fn;
    }

    private String evalGistSource(KameletMain main, String file) throws Exception {
        StringJoiner routes = new StringJoiner(",");
        StringJoiner kamelets = new StringJoiner(",");
        StringJoiner properties = new StringJoiner(",");
        GistHelper.fetchGistUrls(file, routes, kamelets, properties);
        if (properties.length() > 0) {
            main.addInitialProperty("camel.component.properties.location", properties.toString());
        }
        if (kamelets.length() > 0) {
            Object loc = main.getInitialProperties().getProperty("camel.component.kamelet.location");
            loc = loc != null ? String.valueOf(kamelets) + "," + (String)loc : kamelets.toString();
            main.addInitialProperty("camel.component.kamelet.location", (String)loc);
        }
        if (routes.length() > 0) {
            return routes.toString();
        }
        return null;
    }

    private String evalGithubSource(KameletMain main, String file) throws Exception {
        String ext = FileUtil.onlyExt((String)file);
        boolean wildcard = FileUtil.onlyName((String)file, (boolean)false).contains("*");
        if (ext != null && !wildcard) {
            return GitHubHelper.asGithubSingleUrl(file);
        }
        StringJoiner routes = new StringJoiner(",");
        StringJoiner kamelets = new StringJoiner(",");
        StringJoiner properties = new StringJoiner(",");
        GitHubHelper.fetchGithubUrls(file, routes, kamelets, properties);
        if (properties.length() > 0) {
            main.addInitialProperty("camel.component.properties.location", properties.toString());
        }
        if (kamelets.length() > 0) {
            Object loc = main.getInitialProperties().getProperty("camel.component.kamelet.location");
            loc = loc != null ? String.valueOf(kamelets) + "," + (String)loc : kamelets.toString();
            main.addInitialProperty("camel.component.kamelet.location", (String)loc);
        }
        if (routes.length() > 0) {
            return routes.toString();
        }
        return null;
    }

    private String loadFromClipboard(String file) throws UnsupportedFlavorException, IOException {
        String ext = FileUtil.onlyExt((String)file, (boolean)true);
        if (ext == null || ext.isEmpty()) {
            throw new IllegalArgumentException("When running from clipboard, an extension is required to let Camel know what kind of file to use");
        }
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        Object t = c.getData(DataFlavor.stringFlavor);
        if (t != null) {
            String fn = ".camel-jbang/generated-clipboard." + ext;
            if ("java".equals(ext)) {
                String fqn = Run.determineClassName(t.toString());
                if (fqn == null) {
                    return this.loadFromCode(t.toString(), "ClipboardRoute", true);
                }
                String cn = fqn;
                if (fqn.contains(".")) {
                    cn = cn.substring(cn.lastIndexOf(46) + 1);
                }
                fn = cn + ".java";
            }
            Files.writeString(Paths.get(fn, new String[0]), (CharSequence)t.toString(), new OpenOption[0]);
            file = "file:" + fn;
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private KameletMain createMainInstance() {
        KameletMain main;
        if (this.localKameletDir == null || this.localKameletDir.isEmpty()) {
            main = new KameletMain("camel.jbang");
        } else {
            String[] parts;
            StringJoiner sj = new StringJoiner(",");
            for (String string : parts = this.localKameletDir.split(",")) {
                void var7_7;
                void var7_11;
                if (string.startsWith("https://github.com/")) {
                    String string2 = GitHubHelper.asGithubSingleUrl(string);
                } else if (string.startsWith("https://gist.github.com/")) {
                    String string3 = GistHelper.asGistSingleUrl(string);
                }
                String string4 = FileUtil.compactPath((String)var7_11);
                if (!ResourceHelper.hasScheme((String)string4) && !string4.startsWith("github:")) {
                    String string5 = "file:" + string4;
                }
                sj.add((CharSequence)var7_7);
            }
            main = new KameletMain("camel.jbang", sj.toString());
            this.writeSettings("camel.jbang.localKameletDir", sj.toString());
        }
        return main;
    }

    private void configureLogging(Path baseDir) throws Exception {
        if (this.logging) {
            Properties prop = this.loadProfileProperties(baseDir);
            if (prop != null) {
                for (Object obj : prop.keySet()) {
                    String key = obj.toString();
                    String value = prop.getProperty(key);
                    if (key.startsWith("logging.level.")) {
                        key = key.substring(14);
                    } else {
                        if (!key.startsWith("quarkus.log.category.")) continue;
                        if ((key = key.substring(21)).endsWith(".level")) {
                            key = key.substring(0, key.length() - 6);
                        }
                    }
                    key = StringHelper.removeLeadingAndEndingQuotes((String)key);
                    String line = key + "=" + value;
                    String line2 = key + " = " + value;
                    if (this.loggingCategory.contains(line) || this.loggingCategory.contains(line2)) continue;
                    this.loggingCategory.add(line);
                }
            }
            RuntimeUtil.configureLog(this.loggingLevel, this.loggingColor, this.loggingJson, this.scriptRun, false, this.loggingConfigPath, this.loggingCategory);
            this.writeSettings("loggingLevel", this.loggingLevel);
            this.writeSettings("loggingColor", this.loggingColor ? "true" : "false");
            this.writeSettings("loggingJson", this.loggingJson ? "true" : "false");
            if (!this.scriptRun) {
                String name = RuntimeUtil.getPid() + ".log";
                Path logDir = CommandLineHelper.getCamelDir();
                Files.createDirectories(logDir, new FileAttribute[0]);
                this.logFile = logDir.resolve(name);
                try {
                    Files.createFile(this.logFile, new FileAttribute[0]);
                    this.logFile.toFile().deleteOnExit();
                }
                catch (IOException iOException) {}
            }
        } else if (this.exportRun) {
            RuntimeUtil.configureLog(this.loggingLevel, false, false, false, true, null, null);
            this.writeSettings("loggingLevel", this.loggingLevel);
        } else {
            RuntimeUtil.configureLog("off", false, false, false, false, null, null);
            this.writeSettings("loggingLevel", "off");
        }
    }

    private void generateOpenApi() throws Exception {
        Path filePath = Paths.get(this.openapi, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0]) || !Files.isRegularFile(filePath, new LinkOption[0])) {
            throw new FileNotFoundException("Cannot find file: " + String.valueOf(filePath));
        }
        try (InputStream is = Run.class.getClassLoader().getResourceAsStream("templates/rest-dsl.yaml.tmpl");){
            String content = IOHelper.loadText((InputStream)is);
            String onlyName = filePath.toString();
            content = content.replaceFirst("\\{\\{ \\.Spec }}", onlyName);
            Files.writeString(Paths.get(OPENAPI_GENERATED_FILE, new String[0]), (CharSequence)content, new OpenOption[0]);
            this.files.add(this.openapi);
        }
    }

    private boolean knownFile(String file) throws Exception {
        String ext = FileUtil.onlyExt((String)file, (boolean)false);
        if ("kamelet.yaml".equals(ext)) {
            return true;
        }
        String ext2 = FileUtil.onlyExt((String)file, (boolean)true);
        if (ext2 != null) {
            SourceScheme sourceScheme = SourceScheme.fromUri(file);
            if (!sourceScheme.isRemote() && ("xml".equals(ext2) || "yaml".equals(ext2))) {
                Source source = SourceHelper.resolveSource(file);
                if ("xml".equals(ext2)) {
                    XmlStreamDetector detector = new XmlStreamDetector((InputStream)new ByteArrayInputStream(source.content().getBytes(StandardCharsets.UTF_8)));
                    XmlStreamInfo info = detector.information();
                    if (!info.isValid()) {
                        return false;
                    }
                    return ACCEPTED_XML_ROOT_ELEMENTS.contains(info.getRootElementName());
                }
                return source.content().contains("- from:") || source.content().contains("- route:") || source.content().contains("- routeTemplate") || source.content().contains("- route-template:") || source.content().contains("- routeConfiguration:") || source.content().contains("- route-configuration:") || source.content().contains("- rest:") || source.content().contains("- beans:") || source.content().contains("Pipe");
            }
            return SourceHelper.isAcceptedSourceFile(ext2);
        }
        return true;
    }

    private boolean skipFile(String name) {
        Path path;
        if (name.startsWith("github:") || name.startsWith("https://github.com/") || name.startsWith("https://gist.github.com/")) {
            return false;
        }
        if (OPENAPI_GENERATED_FILE.equals(name = FileUtil.stripPath((String)name))) {
            return false;
        }
        if ("pom.xml".equalsIgnoreCase(name)) {
            return true;
        }
        if ("build.gradle".equalsIgnoreCase(name)) {
            return true;
        }
        if ("camel-runner.jar".equals(name)) {
            return true;
        }
        if ("docker-compose.yml".equals(name) || "docker-compose.yaml".equals(name) || "compose.yml".equals(name) || "compose.yaml".equals(name)) {
            return true;
        }
        if (name.equals("NOTICE.txt") || name.equals("LICENSE.txt")) {
            return true;
        }
        if (name.startsWith(".")) {
            boolean ok;
            boolean bl = ok = name.startsWith("..") || name.startsWith("./");
            if (!ok) {
                return true;
            }
        }
        if (Run.isExcluded(name, this.excludes)) {
            return true;
        }
        if (!name.startsWith("classpath:") && Files.exists(path = Path.of(name, new String[0]), new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            return true;
        }
        if (FileUtil.onlyExt((String)name) == null) {
            return true;
        }
        String on = FileUtil.onlyName((String)name, (boolean)true);
        return (on = on.toLowerCase(Locale.ROOT)).startsWith("readme");
    }

    private static boolean isExcluded(String name, List<String> excludes) {
        if (excludes != null) {
            for (String pattern : excludes) {
                if (!AntPathMatcher.INSTANCE.match(pattern = pattern.trim(), name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isGroovyFile(String name) {
        return name.endsWith(".groovy");
    }

    private boolean isScriptFile(String name) {
        return name.endsWith(".sh");
    }

    private boolean isTlsFile(String name) {
        return name.endsWith(".crt") || name.endsWith(".key") || name.endsWith(".pem");
    }

    private boolean jkubeFile(String name) {
        return name.endsWith(".jkube.yaml") || name.endsWith(".jkube.yml");
    }

    private void writeSettings(String key, String value) {
        try {
            String[] lines;
            Properties prop = new Properties();
            prop.setProperty(key, value);
            StringWriter sw = new StringWriter();
            prop.store(sw, null);
            Path runSettingsPath = CommandLineHelper.getWorkDir().resolve(RUN_SETTINGS_FILE);
            StringBuilder content = new StringBuilder();
            for (String line : lines = sw.toString().split(System.lineSeparator())) {
                if (line.startsWith("#")) continue;
                content.append(line).append(System.lineSeparator());
            }
            if (Files.exists(runSettingsPath, new LinkOption[0])) {
                Files.write(runSettingsPath, content.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            } else {
                Files.write(runSettingsPath, content.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void removeDir(Path directory) {
        try {
            if (Files.exists(directory, new LinkOption[0])) {
                Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        try {
                            path.toFile().deleteOnExit();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void delete(Path path) {
        block7: {
            try {
                if (Files.deleteIfExists(path)) break block7;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (!Files.deleteIfExists(path)) {
                    path.toFile().deleteOnExit();
                }
            }
            catch (IOException e) {
                try {
                    path.toFile().deleteOnExit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static String determineClassName(String content) {
        Matcher matcher = PACKAGE_PATTERN.matcher(content);
        String pn = matcher.find() ? matcher.group(1) : null;
        matcher = CLASS_PATTERN.matcher(content);
        String cn = matcher.find() ? matcher.group(1) : null;
        Object fqn = pn != null ? pn + "." + cn : cn;
        return fqn;
    }

    private static boolean isReloadRecursive(String reload) {
        for (String part : reload.split(",")) {
            String dir = FileUtil.onlyPath((String)part);
            if (dir == null) continue;
            return true;
        }
        return false;
    }

    private JsonObject loadStatus(long pid) {
        block8: {
            JsonObject jsonObject;
            block9: {
                Path p = this.getStatusFile(Long.toString(pid));
                if (!Files.exists(p, new LinkOption[0])) break block8;
                InputStream is = Files.newInputStream(p, new OpenOption[0]);
                try {
                    String text = IOHelper.loadText((InputStream)is);
                    jsonObject = (JsonObject)Jsoner.deserialize((String)text);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return jsonObject;
        }
        return null;
    }

    @Override
    protected Printer printer() {
        if (this.exportRun && !this.logging && !this.verbose) {
            if (this.quietPrinter == null) {
                this.quietPrinter = new Printer.QuietPrinter(super.printer());
            }
            CommandHelper.setPrinter(this.quietPrinter);
            return this.quietPrinter;
        }
        return super.printer();
    }

    private class RunDownloadListener
    implements DownloadListener {
        final Set<String> downloaded = new HashSet<String>();
        final Set<String> repos = new HashSet<String>();
        final Set<String> kamelets = new HashSet<String>();

        private RunDownloadListener() {
        }

        public void onDownloadDependency(String groupId, String artifactId, String version) {
            String line = "mvn:" + groupId + ":" + artifactId;
            if (ObjectHelper.isNotEmpty((String)version)) {
                line = line + ":" + version;
            }
            if (!this.downloaded.contains(line)) {
                Run.this.writeSettings("dependency", line);
                this.downloaded.add(line);
            }
        }

        public void onAlreadyDownloadedDependency(String groupId, String artifactId, String version) {
            this.onDownloadDependency(groupId, artifactId, version);
        }

        public void onExtraRepository(String repo) {
            if (!this.repos.contains(repo)) {
                Run.this.writeSettings("repository", repo);
                this.repos.add(repo);
            }
        }

        public void onLoadingKamelet(String name) {
            if (!this.kamelets.contains(name)) {
                Run.this.writeSettings("kamelet", name);
                this.kamelets.add(name);
            }
        }
    }

    static class DebugConsumer
    extends CamelCommand.ParameterConsumer<Run> {
        private static final Pattern DEBUG_ARG_VALUE_PATTERN = Pattern.compile("\\d+|true|false");

        DebugConsumer() {
        }

        @Override
        protected void doConsumeParameters(Stack<String> args, Run cmd) {
            String arg;
            String string = arg = args.isEmpty() ? "" : args.peek();
            if (DEBUG_ARG_VALUE_PATTERN.asPredicate().test(arg)) {
                args.pop();
            } else {
                arg = "true";
            }
            cmd.jvmDebugPort = Run.parseJvmDebugPort(arg);
        }

        @Override
        protected boolean failIfEmptyArgs() {
            return false;
        }
    }

    static class FilesConsumer
    extends CamelCommand.ParameterConsumer<Run> {
        FilesConsumer() {
        }

        @Override
        protected void doConsumeParameters(Stack<String> args, Run cmd) {
            String arg = args.pop();
            cmd.files.add(arg);
        }
    }
}

