/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Stack;
import java.util.function.Supplier;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.jline.builtins.ClasspathResourceUtil;
import org.jline.builtins.Commands;
import org.jline.builtins.ConfigurationPath;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;

@CommandLine.Command(name="nano", description={"Nano editor to edit file"}, footer={"Press Ctrl-X to exit."})
public class Nano
extends CamelCommand {
    @CommandLine.Parameters(description={"Name of file"}, arity="1", paramLabel="<file>", parameterConsumer=FileConsumer.class)
    private Path filePath;
    private String file;

    public Nano(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
        try (Terminal terminal = TerminalBuilder.builder().build();){
            Path appConfig = ClasspathResourceUtil.getResourcePath((String)"/nano/jnanorc", this.getClass()).getParent();
            ConfigurationPath configPath = new ConfigurationPath(appConfig, null);
            Commands.nano((Terminal)terminal, (PrintStream)System.out, (PrintStream)System.err, (Path)workDir.get(), (String[])new String[]{this.file}, (ConfigurationPath)configPath);
        }
        return 0;
    }

    static class FileConsumer
    extends CamelCommand.ParameterConsumer<Nano> {
        FileConsumer() {
        }

        @Override
        protected void doConsumeParameters(Stack<String> args, Nano cmd) {
            cmd.file = args.pop();
        }
    }
}

