/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Stack;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletCatalogHelper;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.GistHelper;
import org.apache.camel.dsl.jbang.core.common.GitHubHelper;
import org.apache.camel.dsl.jbang.core.common.ResourceDoesNotExist;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.github.GistResourceResolver;
import org.apache.camel.github.GitHubResourceResolver;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.commons.io.IOUtils;
import picocli.CommandLine;

@CommandLine.Command(name="init", description={"Creates a new Camel integration"}, sortOptions=false, showDefaultValues=true)
public class Init
extends CamelCommand {
    @CommandLine.Parameters(description={"Name of integration file (or a github link)"}, arity="1", paramLabel="<file>", parameterConsumer=FileConsumer.class)
    private Path filePath;
    private String file;
    @CommandLine.Option(names={"--dir", "--directory"}, description={"Directory relative path where the new Camel integration will be saved"}, defaultValue=".")
    private String directory;
    @CommandLine.Option(names={"--clean-dir", "--clean-directory"}, description={"Whether to clean directory first (deletes all files in directory)"})
    private boolean cleanDirectory;
    @CommandLine.Option(names={"--from-kamelet"}, description={"To be used when extending an existing Kamelet"})
    private String fromKamelet;
    @CommandLine.Option(names={"--kamelets-version"}, description={"Apache Camel Kamelets version"})
    private String kameletsVersion;
    @CommandLine.Option(names={"--pipe"}, description={"When creating a yaml file should it be created as a Pipe CR"})
    private boolean pipe;

    public Init(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        int code = this.execute();
        if (code == 0) {
            this.createWorkingDirectoryIfAbsent();
        }
        return code;
    }

    private int execute() throws Exception {
        Path parentPath;
        Path targetPath;
        if (this.file.startsWith("https://github.com/")) {
            return this.downloadFromGithub();
        }
        if (this.file.startsWith("https://gist.github.com/")) {
            return this.downloadFromGist();
        }
        String ext = FileUtil.onlyExt((String)this.file, (boolean)false);
        if ("yaml".equals(ext) && this.pipe) {
            ext = "init-pipe.yaml";
        }
        if (this.fromKamelet != null && !"kamelet.yaml".equals(ext)) {
            this.printer().println("When extending from an existing Kamelet then file must have extension .kamelet.yaml");
            return 1;
        }
        String name = FileUtil.onlyName((String)this.file, (boolean)false);
        InputStream is = null;
        if ("kamelet.yaml".equals(ext)) {
            if (this.fromKamelet != null) {
                if (this.kameletsVersion == null) {
                    this.kameletsVersion = VersionHelper.extractKameletsVersion();
                }
                is = KameletCatalogHelper.loadKameletYamlSchema(this.fromKamelet, this.kameletsVersion);
            } else {
                ext = this.file.contains("source") ? "kamelet-source.yaml" : (this.file.contains("sink") ? "kamelet-sink.yaml" : "kamelet-action.yaml");
            }
        } else if (ext != null && (ext.startsWith("camel.yaml") || ext.startsWith("camel.xml"))) {
            ext = ext.substring(6);
        }
        if (is == null) {
            is = Init.class.getClassLoader().getResourceAsStream("templates/" + ext + ".tmpl");
        }
        if (is == null) {
            if (this.fromKamelet != null) {
                this.printer().printErr("Existing Kamelet does not exist: " + this.fromKamelet);
            } else {
                this.printer().printErr("Unsupported file type: " + ext);
            }
            return 1;
        }
        String content = IOHelper.loadText(is);
        IOHelper.close((Closeable)is);
        if (!this.directory.equals(".")) {
            if (this.cleanDirectory) {
                CommandHelper.cleanExportDir(this.directory);
            }
            Path dirPath = Paths.get(this.directory, new String[0]);
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        if (!(targetPath = Paths.get(this.file, new String[0])).isAbsolute()) {
            targetPath = Paths.get(this.directory, this.file);
        }
        content = content.replaceFirst("\\{\\{ \\.Name }}", name);
        if (this.fromKamelet != null) {
            content = content.replaceFirst("\\s\\sname:\\s" + this.fromKamelet, "  name: " + name);
            content = content.replaceFirst("camel.apache.org/provider: \"Apache Software Foundation\"", "camel.apache.org/provider: \"Custom\"");
            StringBuilder sb = new StringBuilder();
            String[] lines = content.split("\n");
            boolean top = true;
            for (String line : lines) {
                if (top && line.startsWith("#")) continue;
                top = false;
                sb.append(line);
                sb.append("\n");
            }
            content = sb.toString();
        }
        if ("java".equals(ext)) {
            String packageDeclaration = this.computeJavaPackageDeclaration(targetPath);
            content = content.replaceFirst("\\{\\{ \\.PackageDeclaration }}", packageDeclaration);
        }
        if ((parentPath = targetPath.getParent()) != null) {
            if (".".equals(parentPath.getFileName().toString())) {
                targetPath = Paths.get(this.file, new String[0]);
            } else {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
        }
        Files.writeString(targetPath, (CharSequence)content, new OpenOption[0]);
        return 0;
    }

    private String computeJavaPackageDeclaration(Path targetPath) throws IOException {
        String packagePath;
        String packageName;
        String srcMainJavaPath;
        Object packageDeclaration = "";
        String canonicalPath = targetPath.getParent().toRealPath(new LinkOption[0]).toString();
        int index = canonicalPath.indexOf(srcMainJavaPath = Paths.get("src", "main", "java").toString());
        if (index != -1 && !(packageName = (packagePath = canonicalPath.substring(index + srcMainJavaPath.length() + 1)).replace(File.separatorChar, '.')).isEmpty()) {
            packageDeclaration = "package " + packageName + ";\n\n";
        }
        return packageDeclaration;
    }

    private void createWorkingDirectoryIfAbsent() {
        Path work = CommandLineHelper.getWorkDir();
        if (!Files.exists(work, new LinkOption[0])) {
            try {
                Files.createDirectories(work, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int downloadFromGithub() throws Exception {
        StringJoiner all = new StringJoiner(",");
        String ext = FileUtil.onlyExt((String)this.file);
        boolean wildcard = FileUtil.onlyName((String)this.file, (boolean)false).contains("*");
        if (ext != null && !wildcard) {
            String url = GitHubHelper.asGithubSingleUrl(this.file);
            all.add(url);
        } else {
            GitHubHelper.fetchGithubUrls(this.file, all);
        }
        if (all.length() > 0) {
            if (!this.directory.equals(".")) {
                Path dirPath = Paths.get(this.directory, new String[0]);
                if (this.cleanDirectory) {
                    CommandHelper.cleanExportDir(this.directory);
                }
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            DefaultCamelContext tiny = new DefaultCamelContext();
            GitHubResourceResolver resolver = new GitHubResourceResolver();
            resolver.setCamelContext((CamelContext)tiny);
            for (String u : all.toString().split(",")) {
                Resource resource = resolver.resolve(u);
                if (!resource.exists()) {
                    throw new ResourceDoesNotExist(resource);
                }
                String loc = resource.getLocation();
                String name = FileUtil.stripPath((String)loc);
                Path targetPath = Paths.get(this.directory, name);
                try (OutputStream os = Files.newOutputStream(targetPath, new OpenOption[0]);){
                    IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)os);
                }
            }
        }
        return 0;
    }

    private Integer downloadFromGist() throws Exception {
        StringJoiner all = new StringJoiner(",");
        GistHelper.fetchGistUrls(this.file, all);
        if (all.length() > 0) {
            if (!this.directory.equals(".")) {
                Path dirPath = Paths.get(this.directory, new String[0]);
                if (this.cleanDirectory) {
                    CommandHelper.cleanExportDir(this.directory);
                }
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            DefaultCamelContext tiny = new DefaultCamelContext();
            GistResourceResolver resolver = new GistResourceResolver();
            resolver.setCamelContext((CamelContext)tiny);
            for (String u : all.toString().split(",")) {
                Resource resource = resolver.resolve(u);
                if (!resource.exists()) {
                    throw new ResourceDoesNotExist(resource);
                }
                String loc = resource.getLocation();
                String name = FileUtil.stripPath((String)loc);
                Path targetPath = Paths.get(this.directory, name);
                try (OutputStream os = Files.newOutputStream(targetPath, new OpenOption[0]);){
                    IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)os);
                }
            }
        }
        return 0;
    }

    static class FileConsumer
    extends CamelCommand.ParameterConsumer<Init> {
        FileConsumer() {
        }

        @Override
        protected void doConsumeParameters(Stack<String> args, Init cmd) {
            cmd.file = args.pop();
        }
    }
}

