/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.ExportHelper;
import org.apache.camel.dsl.jbang.core.commands.ExportSpringBoot;
import org.apache.camel.dsl.jbang.core.common.CatalogLoader;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

class ExportQuarkus
extends Export {
    public ExportQuarkus(CamelJBangMain main) {
        super(main);
        this.pomTemplateName = "quarkus-pom.tmpl";
    }

    @Override
    public Integer export() throws Exception {
        String[] ids = this.gav.split(":");
        if (ids.length != 3) {
            this.printer().printErr("--gav must be in syntax: groupId:artifactId:version");
            return 1;
        }
        if (!this.buildTool.equals("maven") && !this.buildTool.equals("gradle")) {
            this.printer().printErr("--build-tool must either be maven or gradle, was: " + this.buildTool);
            return 1;
        }
        this.exportBaseDir = this.exportBaseDir != null ? this.exportBaseDir : Path.of(".", new String[0]);
        Path profile = this.exportBaseDir.resolve("application.properties");
        Path settings = CommandLineHelper.getWorkDir().resolve("camel-jbang-run.properties");
        if (this.fresh || !this.files.isEmpty() || !Files.exists(settings, new LinkOption[0])) {
            this.printer().println("Generating fresh run data");
            int silent = this.runSilently(this.ignoreLoadingError, this.lazyBean, this.verbose);
            if (silent != 0) {
                return silent;
            }
        } else {
            this.printer().println("Reusing existing run data");
        }
        this.printer().println("Exporting as Quarkus project to: " + this.exportDir);
        Path buildDir = Path.of(".camel-jbang/work", new String[0]);
        PathUtils.deleteDirectory(buildDir);
        Files.createDirectories(buildDir, new FileAttribute[0]);
        Path srcJavaDirRoot = buildDir.resolve("src/main/java");
        String srcPackageName = ExportHelper.exportPackageName(ids[0], ids[1], this.packageName);
        Path srcJavaDir = srcPackageName == null ? srcJavaDirRoot : srcJavaDirRoot.resolve(srcPackageName.replace('.', File.separatorChar));
        Files.createDirectories(srcJavaDir, new FileAttribute[0]);
        Path srcResourcesDir = buildDir.resolve("src/main/resources");
        Files.createDirectories(srcResourcesDir, new FileAttribute[0]);
        Path srcCamelResourcesDir = buildDir.resolve("src/main/resources/camel");
        Path srcKameletsResourcesDir = buildDir.resolve("src/main/resources/kamelets");
        this.copySourceFiles(settings, profile, srcJavaDirRoot, srcJavaDir, srcResourcesDir, srcCamelResourcesDir, srcKameletsResourcesDir, srcPackageName);
        this.copySettingsAndProfile(settings, profile, srcResourcesDir, prop -> {
            if (!ExportQuarkus.hasModeline(settings)) {
                prop.remove("camel.main.modeline");
            }
            if (!prop.containsKey("quarkus.http.port")) {
                int port = ExportQuarkus.httpServerPort(settings);
                if (port == -1) {
                    port = 8080;
                }
                if (port != 8080) {
                    prop.put("quarkus.http.port", (Object)port);
                }
            }
            if (!prop.containsKey("quarkus.management.port")) {
                this.port = ExportQuarkus.httpManagementPort(settings);
                if (this.port != -1) {
                    prop.put("quarkus.management.port", (Object)this.port);
                }
            }
            return prop;
        });
        this.copyDockerFiles(".camel-jbang/work");
        String appJar = "target" + File.separator + "quarkus-app" + File.separator + "quarkus-run.jar";
        this.copyReadme(".camel-jbang/work", appJar);
        Set<String> deps = this.resolveDependencies(settings, profile);
        this.copyLocalLibDependencies(deps);
        if ("maven".equals(this.buildTool)) {
            this.createMavenPom(settings, buildDir.resolve("pom.xml"), deps);
            if (this.mavenWrapper) {
                this.copyMavenWrapper();
            }
        } else if ("gradle".equals(this.buildTool)) {
            this.createGradleProperties(buildDir.resolve("gradle.properties"));
            this.createSettingsGradle(buildDir.resolve("settings.gradle"));
            this.createBuildGradle(settings, buildDir.resolve("build.gradle"), deps);
            if (this.gradleWrapper) {
                this.copyGradleWrapper();
            }
        }
        if (this.cleanExportDir || !this.exportDir.equals(".")) {
            CommandHelper.cleanExportDir(this.exportDir);
        }
        PathUtils.copyDirectory(buildDir, Path.of(this.exportDir, new String[0]));
        PathUtils.deleteDirectory(buildDir);
        return 0;
    }

    @Override
    protected void prepareApplicationProperties(Properties properties) {
        String extra;
        super.prepareApplicationProperties(properties);
        StringJoiner sj = new StringJoiner(",");
        StringJoiner sj2 = new StringJoiner(",");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String k = entry.getKey().toString();
            String v = entry.getValue().toString();
            if ("camel.main.routesIncludePattern".equals(k)) {
                v = Arrays.stream(v.split(",")).filter(d -> !d.endsWith(".java")).map(ExportQuarkus::stripPath).map(s -> {
                    if (s.endsWith("kamelet.yaml")) {
                        return "kamelets/" + s;
                    }
                    return "camel/" + s;
                }).collect(Collectors.joining(","));
                sj.add(v);
            }
            if (!"camel.jbang.classpathFiles".equals(k)) continue;
            v = Arrays.stream(v.split(",")).filter(d -> !d.endsWith(".jar")).map(ExportQuarkus::stripPath).collect(Collectors.joining(","));
            sj2.add(v);
        }
        String routes = sj.length() > 0 ? sj.toString() : null;
        String string = extra = sj2.length() > 0 ? sj2.toString() : null;
        if (routes != null || extra != null) {
            sj = new StringJoiner(",");
            String e = properties.getProperty("quarkus.native.resources.includes");
            if (e != null) {
                sj.add(e);
            }
            if (routes != null) {
                sj.add(routes);
            }
            if (extra != null) {
                sj.add(extra);
            }
            if ((extra != null || VersionHelper.isLE(this.quarkusVersion, "3.21.0")) && sj.length() > 0) {
                properties.setProperty("quarkus.native.resources.includes", sj.toString());
            }
        }
        if (VersionHelper.isBetween(this.quarkusVersion, "3.11.0", "3.13.0") && !properties.containsKey("quarkus.camel.openapi.codegen.model-package")) {
            properties.put("quarkus.camel.openapi.codegen.model-package", "org.apache.camel.quarkus");
        }
    }

    private static String stripPath(String fileName) {
        if (fileName.contains(":")) {
            fileName = StringHelper.after((String)fileName, (String)":");
        }
        fileName = FileUtil.stripPath((String)fileName);
        fileName = fileName.replace(".camel-jbang/", "");
        return fileName;
    }

    private void createGradleProperties(Path output) throws Exception {
        InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("templates/quarkus-gradle-properties.tmpl");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        context = context.replaceFirst("\\{\\{ \\.QuarkusGroupId }}", this.quarkusGroupId);
        context = context.replaceFirst("\\{\\{ \\.QuarkusArtifactId }}", this.quarkusArtifactId);
        context = context.replaceAll("\\{\\{ \\.QuarkusVersion }}", this.quarkusVersion);
        Files.writeString(output, (CharSequence)context, new OpenOption[0]);
    }

    private void createSettingsGradle(Path output) throws Exception {
        String[] ids = this.gav.split(":");
        InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("templates/quarkus-settings-gradle.tmpl");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        context = context.replaceFirst("\\{\\{ \\.GroupId }}", ids[0]);
        context = context.replaceFirst("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceFirst("\\{\\{ \\.Version }}", ids[2]);
        Files.writeString(output, (CharSequence)context, new OpenOption[0]);
    }

    private void createBuildGradle(Path settings, Path gradleBuild, Set<String> deps) throws Exception {
        String[] ids = this.gav.split(":");
        InputStream is = ExportSpringBoot.class.getClassLoader().getResourceAsStream("templates/quarkus-build-gradle.tmpl");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)prop, settings.toFile());
        String repos = this.getMavenRepositories(settings, (Properties)prop, this.quarkusVersion);
        CamelCatalog catalog = CatalogLoader.loadQuarkusCatalog(repos, this.quarkusVersion, this.quarkusGroupId, this.download);
        if (this.camelVersion == null) {
            this.camelVersion = catalog.getCatalogVersion();
        }
        context = context.replaceFirst("\\{\\{ \\.GroupId }}", ids[0]);
        context = context.replaceFirst("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceFirst("\\{\\{ \\.Version }}", ids[2]);
        context = context.replaceFirst("\\{\\{ \\.QuarkusGroupId }}", this.quarkusGroupId);
        context = context.replaceFirst("\\{\\{ \\.QuarkusArtifactId }}", this.quarkusArtifactId);
        context = context.replaceAll("\\{\\{ \\.QuarkusVersion }}", this.quarkusVersion);
        context = context.replaceAll("\\{\\{ \\.JavaVersion }}", this.javaVersion);
        context = context.replaceAll("\\{\\{ \\.CamelVersion }}", this.camelVersion);
        if (repos == null || repos.isEmpty()) {
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", "");
        } else {
            StringBuilder sb = new StringBuilder();
            for (String repo : repos.split(",")) {
                sb.append("    maven {\n");
                sb.append("        url '").append(repo).append("'\n");
                if (repo.contains("snapshots")) {
                    sb.append("        mavenContent {\n");
                    sb.append("            snapshotsOnly()\n");
                    sb.append("        }\n");
                }
                sb.append("    }\n");
            }
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", sb.toString());
        }
        ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
        for (String dep : deps) {
            MavenGav gav = this.parseMavenGav(dep);
            String gid = gav.getGroupId();
            String aid = gav.getArtifactId();
            if ("org.apache.camel".equals(gid)) {
                String qaid = aid.replace("camel-", "camel-quarkus-");
                ArtifactModel am = catalog.modelFromMavenGAV("org.apache.camel.quarkus", qaid, null);
                if (am != null) {
                    gav.setGroupId(am.getGroupId());
                    gav.setArtifactId(am.getArtifactId());
                    gav.setVersion(null);
                } else {
                    gav.setVersion(this.camelVersion);
                }
            }
            gavs.add(gav);
        }
        this.replaceQuarkusDependencies(gavs);
        gavs.sort(this.mavenGavComparator());
        StringBuilder sb = new StringBuilder();
        for (MavenGav gav : gavs) {
            if ("lib".equals(gav.getPackaging())) {
                sb.append("    implementation files('lib/").append(gav.getArtifactId()).append("-").append(gav.getVersion()).append(".jar')\n");
                continue;
            }
            if ("camel-kamelets-utils".equals(gav.getArtifactId())) {
                sb.append("    implementation ('").append(gav).append("') {\n");
                sb.append("        exclude group: 'org.apache.camel', module: '*'\n");
                sb.append("    }\n");
                continue;
            }
            sb.append("    implementation '").append(gav).append("'\n");
        }
        context = context.replaceFirst("\\{\\{ \\.CamelDependencies }}", sb.toString());
        Files.writeString(gradleBuild, (CharSequence)context, new OpenOption[0]);
    }

    private void replaceQuarkusDependencies(List<MavenGav> gavs) {
        HashMap<MavenGav, MavenGav> replace = new HashMap<MavenGav, MavenGav>();
        try {
            InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-dependencies.properties");
            if (is != null) {
                Properties prop = new Properties();
                prop.load(is);
                for (String k : prop.stringPropertyNames()) {
                    String v = prop.getProperty(k);
                    MavenGav from = this.parseMavenGav(k);
                    MavenGav to = this.parseMavenGav(v);
                    if (from == null || to == null) continue;
                    replace.put(from, to);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (MavenGav gav : gavs) {
            replace.keySet().stream().filter(q -> ExportQuarkus.compareGav(q, gav)).findFirst().ifPresent(q -> {
                MavenGav to = (MavenGav)replace.get(q);
                gav.setGroupId(to.getGroupId());
                gav.setArtifactId(to.getArtifactId());
                gav.setVersion(to.getVersion());
                gav.setScope(to.getScope());
            });
        }
    }

    @Override
    protected String applicationPropertyLine(String key, String value) {
        boolean dash;
        if (key.startsWith("camel.server.") || key.startsWith("camel.management.")) {
            return null;
        }
        boolean bl = dash = key.startsWith("camel.") || key.startsWith("quarkus.") && !key.startsWith("quarkus.hawtio.");
        if (dash) {
            key = StringHelper.camelCaseToDash((String)key);
        }
        return super.applicationPropertyLine(key, value);
    }

    @Override
    protected void copyDockerFiles(String buildDir) throws Exception {
        Path docker = Path.of(buildDir, new String[0]).resolve("src/main/docker");
        Files.createDirectories(docker, new FileAttribute[0]);
        InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.jvm");
        PathUtils.copyFromStream(is, docker.resolve("Dockerfile.jvm"), true);
        is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.jvm");
        PathUtils.copyFromStream(is, docker.resolve("Dockerfile"), true);
        is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.legacy-jar");
        PathUtils.copyFromStream(is, docker.resolve("Dockerfile.legacy-jar"), true);
        is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.native");
        PathUtils.copyFromStream(is, docker.resolve("Dockerfile.native"), true);
        is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.native-micro");
        PathUtils.copyFromStream(is, docker.resolve("Dockerfile.native-micro"), true);
    }

    private void createMavenPom(Path settings, Path pom, Set<String> deps) throws Exception {
        String mp;
        String[] ids = this.gav.split(":");
        InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("templates/" + this.pomTemplateName);
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)prop, settings);
        String repos = this.getMavenRepositories(settings, (Properties)prop, this.quarkusVersion);
        CamelCatalog catalog = CatalogLoader.loadQuarkusCatalog(repos, this.quarkusVersion, this.quarkusGroupId, this.download);
        if (this.camelVersion == null) {
            this.camelVersion = catalog.getCatalogVersion();
        }
        if ((mp = prop.getProperty("quarkus.management.port")) == null) {
            mp = "9876";
        }
        context = context.replaceAll("\\{\\{ \\.GroupId }}", ids[0]);
        context = context.replaceAll("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceAll("\\{\\{ \\.Version }}", ids[2]);
        context = context.replaceAll("\\{\\{ \\.QuarkusGroupId }}", this.quarkusGroupId);
        context = context.replaceAll("\\{\\{ \\.QuarkusArtifactId }}", this.quarkusArtifactId);
        context = context.replaceAll("\\{\\{ \\.QuarkusVersion }}", this.quarkusVersion);
        context = context.replaceAll("\\{\\{ \\.QuarkusManagementPort }}", mp);
        context = context.replaceAll("\\{\\{ \\.JavaVersion }}", this.javaVersion);
        context = context.replaceAll("\\{\\{ \\.CamelVersion }}", this.camelVersion);
        context = context.replaceAll("\\{\\{ \\.ProjectBuildOutputTimestamp }}", this.getBuildMavenProjectDate());
        context = this.replaceBuildProperties(context);
        if (repos == null || repos.isEmpty()) {
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", "");
        } else {
            String s = ExportQuarkus.mavenRepositoriesAsPomXml(repos);
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", s);
        }
        ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
        for (String dep : deps) {
            MavenGav gav = this.parseMavenGav(dep);
            String gid = gav.getGroupId();
            String aid = gav.getArtifactId();
            if ("org.apache.camel".equals(gid)) {
                String qaid = aid.replace("camel-", "camel-quarkus-");
                ArtifactModel am = catalog.modelFromMavenGAV("org.apache.camel.quarkus", qaid, null);
                if (am != null) {
                    gav.setGroupId(am.getGroupId());
                    gav.setArtifactId(am.getArtifactId());
                    gav.setVersion(null);
                } else {
                    gav.setVersion(this.camelVersion);
                }
            }
            gavs.add(gav);
        }
        this.replaceQuarkusDependencies(gavs);
        gavs.sort(this.mavenGavComparator());
        StringBuilder sb = new StringBuilder();
        for (MavenGav gav : gavs) {
            if ("camel-quarkus-core".equals(gav.getArtifactId()) || "camel-quarkus-microprofile-health".equals(gav.getArtifactId())) continue;
            sb.append("        <dependency>\n");
            sb.append("            <groupId>").append(gav.getGroupId()).append("</groupId>\n");
            sb.append("            <artifactId>").append(gav.getArtifactId()).append("</artifactId>\n");
            if (gav.getVersion() != null) {
                sb.append("            <version>").append(gav.getVersion()).append("</version>\n");
            }
            if (gav.getScope() != null) {
                sb.append("            <scope>").append(gav.getScope()).append("</scope>\n");
            }
            if ("lib".equals(gav.getPackaging())) {
                sb.append("            <scope>system</scope>\n");
                sb.append("            <systemPath>\\$\\{project.basedir}/lib/").append(gav.getArtifactId()).append("-").append(gav.getVersion()).append(".jar</systemPath>\n");
            } else if ("camel-kamelets-utils".equals(gav.getArtifactId())) {
                sb.append("            <exclusions>\n");
                sb.append("                <exclusion>\n");
                sb.append("                    <groupId>org.apache.camel</groupId>\n");
                sb.append("                    <artifactId>*</artifactId>\n");
                sb.append("                </exclusion>\n");
                sb.append("            </exclusions>\n");
            }
            sb.append("        </dependency>\n");
        }
        context = context.replaceFirst("\\{\\{ \\.CamelDependencies }}", sb.toString());
        Files.writeString(pom, (CharSequence)context, new OpenOption[0]);
    }

    @Override
    protected Set<String> resolveDependencies(Path settings, Path profile) throws Exception {
        Set<String> answer = super.resolveDependencies(settings, profile);
        answer.removeIf(s -> s.contains("camel-core"));
        answer.removeIf(s -> s.contains("camel-microprofile-health"));
        return answer;
    }

    private static boolean compareGav(MavenGav g1, MavenGav g2) {
        return g1.getGroupId().equals(g2.getGroupId()) && g1.getArtifactId().equals(g2.getArtifactId());
    }
}

