/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.camel.util.IOHelper;

public final class ExportHelper {
    private ExportHelper() {
    }

    public static void safeCopy(ClassLoader classLoader, String scheme, Path source, Path target, boolean override) throws Exception {
        ExportHelper.safeCopy(classLoader, scheme, source, target, override, false);
    }

    public static void safeCopy(ClassLoader classLoader, String scheme, Path source, Path target, boolean override, boolean symbolicLink) throws Exception {
        block13: {
            if ("classpath".equals(scheme)) {
                try (InputStream ins = classLoader.getResourceAsStream(source.toString());
                     OutputStream outs = Files.newOutputStream(target, new OpenOption[0]);){
                    IOHelper.copy((InputStream)ins, (OutputStream)outs);
                    break block13;
                }
            }
            ExportHelper.safeCopy(source, target, override, symbolicLink);
        }
    }

    public static void safeCopy(Path source, Path target, boolean override) throws Exception {
        ExportHelper.safeCopy(source, target, override, false);
    }

    public static void safeCopy(Path source, Path target, boolean override, boolean symbolicLink) throws Exception {
        if (!Files.exists(source, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(source, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(source);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(child -> {
                    try {
                        ExportHelper.safeCopy(child, target.resolve(child.getFileName()), override, symbolicLink);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            return;
        }
        if (symbolicLink) {
            try {
                Path link = target.toAbsolutePath();
                Path src = source.toAbsolutePath();
                if (Files.exists(link, new LinkOption[0])) {
                    Files.delete(link);
                }
                Files.createSymbolicLink(link, src, new FileAttribute[0]);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!Files.exists(target, new LinkOption[0])) {
            Files.copy(source, target, new CopyOption[0]);
        } else if (override) {
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void safeCopy(InputStream source, Path target) throws Exception {
        if (source == null) {
            return;
        }
        Path dir = target.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (!Files.exists(target, new LinkOption[0])) {
            Files.copy(source, target, new CopyOption[0]);
        }
    }

    public static String exportPackageName(String groupId, String artifactId, String packageName) {
        if ("false".equalsIgnoreCase(packageName)) {
            return null;
        }
        if (packageName != null) {
            return packageName;
        }
        String s = groupId + "." + artifactId;
        StringBuilder sb = new StringBuilder();
        for (char ch : s.toCharArray()) {
            if (ch != '.' && !Character.isAlphabetic(ch) && !Character.isDigit(ch)) continue;
            ch = Character.toLowerCase(ch);
            sb.append(ch);
        }
        return sb.toString();
    }
}

