/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.ExportHelper;
import org.apache.camel.dsl.jbang.core.commands.Run;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletCatalogHelper;
import org.apache.camel.dsl.jbang.core.common.Plugin;
import org.apache.camel.dsl.jbang.core.common.PluginExporter;
import org.apache.camel.dsl.jbang.core.common.PluginHelper;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.dsl.jbang.core.common.RuntimeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeTypeConverter;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.tooling.maven.MavenDownloader;
import org.apache.camel.tooling.maven.MavenDownloaderImpl;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.maven.MavenResolutionException;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

public abstract class ExportBaseCommand
extends CamelCommand {
    protected static final String BUILD_DIR = ".camel-jbang/work";
    protected static final String[] SETTINGS_PROP_SOURCE_KEYS = new String[]{"camel.main.routesIncludePattern", "camel.component.properties.location", "camel.component.kamelet.location", "camel.jbang.classpathFiles", "camel.jbang.localKameletDir", "camel.jbang.groovyFiles", "camel.jbang.scriptFiles", "camel.jbang.tlsFiles", "camel.jbang.jkubeFiles", "kamelet"};
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^\\s*package\\s+([a-zA-Z][.\\w]*)\\s*;.*$", 8);
    private static final Set<String> EXCLUDED_GROUP_IDS = Set.of("org.fusesource.jansi", "org.apache.logging.log4j");
    protected Path exportBaseDir;
    private MavenDownloader downloader;
    private Printer quietPrinter;
    @CommandLine.Parameters(description={"The Camel file(s) to export. If no files is specified then what was last run will be exported."}, arity="0..9", paramLabel="<files>", parameterConsumer=FilesConsumer.class)
    protected Path[] filePaths;
    protected List<String> files = new ArrayList<String>();
    @CommandLine.Option(names={"--repos"}, description={"Additional maven repositories (Use commas to separate multiple repositories)"})
    protected String repositories;
    @CommandLine.Option(names={"--dep", "--dependency"}, description={"Add additional dependencies"}, split=",")
    protected List<String> dependencies = new ArrayList<String>();
    @CommandLine.Option(names={"--runtime"}, completionCandidates=RuntimeCompletionCandidates.class, converter={RuntimeTypeConverter.class}, description={"Runtime (${COMPLETION-CANDIDATES})"})
    protected RuntimeType runtime;
    @CommandLine.Option(names={"--name"}, description={"The integration name. Use this when the name should not get derived otherwise."})
    protected String name;
    @CommandLine.Option(names={"--port"}, description={"Embeds a local HTTP server on this port"}, defaultValue="8080")
    int port;
    @CommandLine.Option(names={"--management-port"}, description={"To use a dedicated port for HTTP management"})
    int managementPort = -1;
    @CommandLine.Option(names={"--gav"}, description={"The Maven group:artifact:version"})
    protected String gav;
    @CommandLine.Option(names={"--exclude"}, description={"Exclude files by name or pattern"})
    protected List<String> excludes = new ArrayList<String>();
    @CommandLine.Option(names={"--maven-settings"}, description={"Optional location of Maven settings.xml file to configure servers, repositories, mirrors and proxies. If set to \"false\", not even the default ~/.m2/settings.xml will be used."})
    protected String mavenSettings;
    @CommandLine.Option(names={"--maven-settings-security"}, description={"Optional location of Maven settings-security.xml file to decrypt settings.xml"})
    protected String mavenSettingsSecurity;
    @CommandLine.Option(names={"--maven-central-enabled"}, defaultValue="true", description={"Whether downloading JARs from Maven Central repository is enabled"})
    protected boolean mavenCentralEnabled = true;
    @CommandLine.Option(names={"--maven-apache-snapshot-enabled"}, defaultValue="true", description={"Whether downloading JARs from ASF Maven Snapshot repository is enabled"})
    protected boolean mavenApacheSnapshotEnabled = true;
    @CommandLine.Option(names={"--main-classname"}, description={"The class name of the Camel Main application class"}, defaultValue="CamelApplication")
    protected String mainClassname = "CamelApplication";
    @CommandLine.Option(names={"--java-version"}, description={"Java version"}, defaultValue="21")
    protected String javaVersion = "21";
    @CommandLine.Option(names={"--camel-version"}, description={"To export using a different Camel version than the default version."})
    protected String camelVersion;
    @CommandLine.Option(names={"--kamelets-version"}, description={"Apache Camel Kamelets version"})
    protected String kameletsVersion;
    @CommandLine.Option(names={"--profile"}, scope=CommandLine.ScopeType.INHERIT, description={"Profile to export (dev, test, or prod)."})
    protected String profile;
    @CommandLine.Option(names={"--local-kamelet-dir"}, description={"Local directory for loading Kamelets (takes precedence)"})
    protected String localKameletDir;
    @CommandLine.Option(names={"--spring-boot-version"}, description={"Spring Boot version"}, defaultValue="3.5.7")
    protected String springBootVersion = "3.5.7";
    @CommandLine.Option(names={"--camel-spring-boot-version"}, description={"Camel version to use with Spring Boot"})
    protected String camelSpringBootVersion;
    @CommandLine.Option(names={"--quarkus-group-id"}, description={"Quarkus Platform Maven groupId"}, defaultValue="io.quarkus.platform")
    protected String quarkusGroupId = "io.quarkus.platform";
    @CommandLine.Option(names={"--quarkus-artifact-id"}, description={"Quarkus Platform Maven artifactId"}, defaultValue="quarkus-bom")
    protected String quarkusArtifactId = "quarkus-bom";
    @CommandLine.Option(names={"--quarkus-version"}, description={"Quarkus Platform version"}, defaultValue="3.27.0")
    protected String quarkusVersion = "3.27.0";
    @CommandLine.Option(names={"--maven-wrapper"}, defaultValue="true", description={"Include Maven Wrapper files in exported project"})
    protected boolean mavenWrapper = true;
    @CommandLine.Option(names={"--gradle-wrapper"}, defaultValue="true", description={"Include Gradle Wrapper files in exported project"})
    protected boolean gradleWrapper = true;
    @CommandLine.Option(names={"--build-tool"}, defaultValue="maven", description={"Build tool to use (maven or gradle)"})
    protected String buildTool = "maven";
    @CommandLine.Option(names={"--open-api"}, description={"Adds an OpenAPI spec from the given file (json or yaml file)"})
    protected String openapi;
    @CommandLine.Option(names={"--observe"}, defaultValue="false", description={"Enable observability services"})
    protected boolean observe;
    @CommandLine.Option(names={"--dir", "--directory"}, description={"Directory where the project will be exported"}, defaultValue=".")
    protected String exportDir;
    @CommandLine.Option(names={"--clean-dir"}, defaultValue="false", description={"If exporting to current directory (default) then all existing files are preserved. Enabling this option will force cleaning current directory including all sub dirs (use this with care)"})
    protected boolean cleanExportDir;
    @CommandLine.Option(names={"--logging-level"}, defaultValue="info", description={"Logging level"})
    protected String loggingLevel = "info";
    @CommandLine.Option(names={"--package-name"}, description={"For Java source files should they have the given package name. By default the package name is computed from the Maven GAV. Use false to turn off and not include package name in the Java source files."})
    protected String packageName;
    @CommandLine.Option(names={"--fresh"}, defaultValue="false", description={"Make sure we use fresh (i.e. non-cached) resources"})
    protected boolean fresh;
    @CommandLine.Option(names={"--download"}, defaultValue="true", description={"Whether to allow automatic downloading JAR dependencies (over the internet)"})
    protected boolean download = true;
    @CommandLine.Option(names={"--package-scan-jars"}, defaultValue="false", description={"Whether to automatic package scan JARs for custom Spring or Quarkus beans making them available for Camel JBang"})
    protected boolean packageScanJars;
    @CommandLine.Option(names={"--build-property"}, description={"Maven/Gradle build properties, ex. --build-property=prop1=foo"})
    protected List<String> buildProperties = new ArrayList<String>();
    @CommandLine.Option(names={"--prop", "--property"}, description={"Camel application properties, ex. --property=prop1=foo"})
    protected String[] applicationProperties;
    @CommandLine.Option(names={"--logging"}, defaultValue="false", description={"Can be used to turn on logging to console (logs by default to file in <user home>/.camel directory)"})
    protected boolean logging;
    @CommandLine.Option(names={"--quiet"}, defaultValue="false", description={"Will be quiet, only print when error occurs"})
    protected boolean quiet;
    @CommandLine.Option(names={"--verbose"}, defaultValue="false", description={"Verbose output of startup activity (dependency resolution and downloading"})
    protected boolean verbose;
    @CommandLine.Option(names={"--ignore-loading-error"}, defaultValue="false", description={"Whether to ignore route loading and compilation errors (use this with care!)"})
    protected boolean ignoreLoadingError;
    @CommandLine.Option(names={"--lazy-bean"}, defaultValue="true", description={"Whether to use lazy bean initialization (can help with complex classloading issues"})
    protected boolean lazyBean = true;
    @CommandLine.Option(names={"--skip-plugins"}, defaultValue="false", description={"Skip plugins during export"})
    protected boolean skipPlugins;
    @CommandLine.Option(names={"--groovy-pre-compiled"}, defaultValue="false", description={"Whether to include pre-compiled Groovy classes in the export (only supported with runtime=camel-main)"})
    protected boolean groovyPrecompiled;
    protected boolean symbolicLink;
    protected boolean javaLiveReload;
    public String pomTemplateName;

    public ExportBaseCommand(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (this.logging) {
            RuntimeUtil.configureLog(this.loggingLevel, false, false, false, false, null, null);
        } else {
            RuntimeUtil.configureLog(this.loggingLevel, false, false, false, true, null, null);
        }
        if (!this.quiet) {
            this.printConfigurationValues("Exporting integration with the following configuration:");
        }
        return this.export();
    }

    protected static String mavenRepositoriesAsPomXml(String repos) {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        sb.append("    <repositories>\n");
        if (!repos.isEmpty()) {
            for (String repo : repos.split(",")) {
                sb.append("        <repository>\n");
                sb.append("            <id>custom").append(i++).append("</id>\n");
                sb.append("            <url>").append(repo).append("</url>\n");
                if (repo.contains("snapshots")) {
                    sb.append("            <releases>\n");
                    sb.append("                <enabled>false</enabled>\n");
                    sb.append("            </releases>\n");
                    sb.append("            <snapshots>\n");
                    sb.append("                <enabled>true</enabled>\n");
                    sb.append("            </snapshots>\n");
                }
                sb.append("        </repository>\n");
            }
        }
        sb.append("    </repositories>\n");
        sb.append("    <pluginRepositories>\n");
        if (!repos.isEmpty()) {
            for (String repo : repos.split(",")) {
                sb.append("        <pluginRepository>\n");
                sb.append("            <id>custom").append(i++).append("</id>\n");
                sb.append("            <url>").append(repo).append("</url>\n");
                if (repo.contains("snapshots")) {
                    sb.append("            <releases>\n");
                    sb.append("                <enabled>false</enabled>\n");
                    sb.append("            </releases>\n");
                    sb.append("            <snapshots>\n");
                    sb.append("                <enabled>true</enabled>\n");
                    sb.append("            </snapshots>\n");
                }
                sb.append("        </pluginRepository>\n");
            }
        }
        sb.append("    </pluginRepositories>\n");
        return sb.toString();
    }

    protected abstract Integer export() throws Exception;

    protected static String getScheme(String name) {
        int pos = name.indexOf(":");
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return null;
    }

    protected Integer runSilently(boolean ignoreLoadingError, boolean lazyBean, boolean verbose) throws Exception {
        Run run = new Run(this.getMain());
        run.exportBaseDir = this.exportBaseDir;
        run.dependencies = this.dependencies;
        run.files = this.files;
        run.name = this.name;
        run.port = this.port;
        run.managementPort = this.managementPort;
        run.excludes = this.excludes;
        run.openapi = this.openapi;
        run.observe = this.observe;
        run.download = this.download;
        run.packageScanJars = this.packageScanJars;
        run.runtime = this.runtime;
        run.camelVersion = this.camelVersion;
        run.camelSpringBootVersion = this.camelSpringBootVersion;
        run.quarkusVersion = this.quarkusVersion;
        run.quarkusGroupId = this.quarkusGroupId;
        run.springBootVersion = this.springBootVersion;
        run.kameletsVersion = this.kameletsVersion;
        run.localKameletDir = this.localKameletDir;
        run.ignoreLoadingError = ignoreLoadingError;
        run.lazyBean = lazyBean;
        run.property = this.applicationProperties;
        run.repositories = this.repositories;
        run.verbose = verbose;
        run.logging = this.logging;
        return run.runExport(ignoreLoadingError);
    }

    protected void addDependencies(String ... deps) {
        String[] depsArray = Optional.ofNullable(deps).orElse(new String[0]);
        this.dependencies.addAll(Arrays.asList(depsArray));
    }

    protected String replaceBuildProperties(String context) {
        String mavenProperties;
        Properties properties = this.mapBuildProperties();
        if (!this.skipPlugins) {
            Set exporters = PluginHelper.getActivePlugins(this.getMain()).values().stream().map(Plugin::getExporter).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            for (PluginExporter exporter : exporters) {
                exporter.getBuildProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::putIfAbsent));
            }
        }
        context = !(mavenProperties = properties.entrySet().stream().map(item -> String.format("        <%s>%s</%s>", item.getKey(), item.getValue(), item.getKey())).collect(Collectors.joining(System.lineSeparator()))).isEmpty() ? context.replaceFirst(Pattern.quote("{{ .BuildProperties }}"), Matcher.quoteReplacement(mavenProperties)) : context.replaceFirst(Pattern.quote("{{ .BuildProperties }}"), "");
        return context;
    }

    protected Set<String> resolveDependencies(Path settings, Path profile) throws Exception {
        TreeSet<String> answer = new TreeSet<String>((o1, o2) -> {
            boolean c1 = o1.contains("org.apache.camel:");
            boolean c2 = o2.contains("org.apache.camel:");
            if (c1 && !c2) {
                return -1;
            }
            if (!c1 && c2) {
                return 1;
            }
            return o1.compareTo((String)o2);
        });
        if (this.kameletsVersion == null) {
            this.kameletsVersion = VersionHelper.extractKameletsVersion();
        }
        for (String d : this.dependencies) {
            answer.add(ExportBaseCommand.normalizeDependency(d));
        }
        List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
        List<String> officialKamelets = KameletCatalogHelper.findKameletNames(this.kameletsVersion);
        boolean kamelets = false;
        boolean asfKamelets = false;
        for (String string : lines) {
            if (!string.startsWith("kamelet=")) continue;
            kamelets = true;
            String name = StringHelper.after((String)string, (String)"kamelet=");
            if (!officialKamelets.contains(name)) continue;
            asfKamelets = true;
            break;
        }
        kamelets |= lines.stream().anyMatch(l -> l.startsWith("camel.main.routesIncludePattern=") && l.contains(".kamelet.yaml") || l.startsWith("camel.component.kamelet.location=") && l.contains(".kamelet.yaml"));
        for (String string : lines) {
            String deps;
            if (string.startsWith("dependency=")) {
                int skip;
                String v = StringHelper.after((String)string, (String)"dependency=");
                int n = skip = v == null || v.contains("org.apache.camel:camel-core-languages") || v.contains("org.apache.camel:camel-java-joor-dsl") || v.contains("camel-endpointdsl") || !kamelets && v.contains("org.apache.camel:camel-kamelet") ? 1 : 0;
                if (skip == 0) {
                    answer.add(v);
                }
                if (!kamelets || v == null || !v.contains("org.apache.camel:camel-kamelet")) continue;
                answer.add("camel:yaml-dsl");
                if (!asfKamelets) continue;
                answer.add("org.apache.camel.kamelets:camel-kamelets:" + this.kameletsVersion);
                if (VersionHelper.compare(this.camelVersion, "4.10.0") >= 0) continue;
                answer.add("org.apache.camel.kamelets:camel-kamelets-utils:" + this.kameletsVersion);
                continue;
            }
            if (string.startsWith("camel.jbang.dependencies=")) {
                deps = StringHelper.after((String)string, (String)"camel.jbang.dependencies=");
                if (deps.isEmpty()) continue;
                for (String d : deps.split(",")) {
                    answer.add(d.trim());
                    if (!kamelets || !d.contains("org.apache.camel:camel-kamelet")) continue;
                    answer.add("camel:yaml-dsl");
                    if (!asfKamelets) continue;
                    answer.add("org.apache.camel.kamelets:camel-kamelets:" + this.kameletsVersion);
                    if (VersionHelper.compare(this.camelVersion, "4.10.0") >= 0) continue;
                    answer.add("org.apache.camel.kamelets:camel-kamelets-utils:" + this.kameletsVersion);
                }
                continue;
            }
            if (string.startsWith("camel.jbang.classpathFiles=")) {
                deps = StringHelper.after((String)string, (String)"camel.jbang.classpathFiles=");
                if (deps.isEmpty()) continue;
                for (String d : deps.split(",")) {
                    if (!d.endsWith(".jar")) continue;
                    answer.add("lib:" + d.trim());
                }
                continue;
            }
            if (string.startsWith("camel.main.routesIncludePattern=")) {
                String routes = StringHelper.after((String)string, (String)"camel.main.routesIncludePattern=");
                if (routes.isEmpty()) continue;
                for (String r : routes.split(",")) {
                    String ext = FileUtil.onlyExt((String)r, (boolean)true);
                    if (ext == null) continue;
                    if ("xml".equals(ext)) {
                        answer.add("mvn:org.apache.camel:camel-xml-io-dsl");
                        continue;
                    }
                    if (!"yaml".equals(ext)) continue;
                    answer.add("mvn:org.apache.camel:camel-yaml-dsl");
                    ext = FileUtil.onlyExt((String)r, (boolean)false);
                    if (!"kamelet.yaml".equals(ext)) continue;
                    answer.add("camel:kamelet");
                    if (!asfKamelets) continue;
                    answer.add("mvn:org.apache.camel.kamelets:camel-kamelets:" + this.kameletsVersion);
                    if (VersionHelper.compare(this.camelVersion, "4.10.0") >= 0) continue;
                    answer.add("mvn:org.apache.camel.kamelets:camel-kamelets-utils:" + this.kameletsVersion);
                }
                continue;
            }
            if (kamelets && string.startsWith("camel.component.kamelet.location=")) {
                answer.add("camel:kamelet");
                answer.add("camel:yaml-dsl");
                if (!asfKamelets) continue;
                answer.add("mvn:org.apache.camel.kamelets:camel-kamelets:" + this.kameletsVersion);
                if (VersionHelper.compare(this.camelVersion, "4.10.0") >= 0) continue;
                answer.add("mvn:org.apache.camel.kamelets:camel-kamelets-utils:" + this.kameletsVersion);
                continue;
            }
            if (!string.startsWith("modeline=")) continue;
            answer.add("camel:dsl-modeline");
        }
        if (profile != null && Files.exists(profile, new LinkOption[0])) {
            CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
            RuntimeUtil.loadProperties((Properties)prop, profile);
            for (String d : RuntimeUtil.getDependenciesAsArray((Properties)prop)) {
                answer.add(d.trim());
            }
            if ("true".equalsIgnoreCase(prop.getProperty("camel.main.devConsoleEnabled")) || "true".equalsIgnoreCase(prop.getProperty("camel.management.devConsoleEnabled")) || "true".equalsIgnoreCase(prop.getProperty("camel.server.devConsoleEnabled"))) {
                answer.add("camel:console");
                answer.add("camel:management");
            }
            if ("true".equalsIgnoreCase(prop.getProperty("camel.management.jolokiaEnabled")) || "true".equalsIgnoreCase(prop.getProperty("camel.server.jolokiaEnabled"))) {
                answer.add("camel:platform-http-jolokia");
            }
            if ("true".equalsIgnoreCase(prop.getProperty("camel.management.metricsEnabled")) || "true".equalsIgnoreCase(prop.getProperty("camel.server.metricsEnabled"))) {
                answer.add("camel:micrometer-prometheus");
            }
        }
        if (!this.skipPlugins) {
            Set exporters = PluginHelper.getActivePlugins(this.getMain()).values().stream().map(Plugin::getExporter).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            for (PluginExporter exporter : exporters) {
                answer.addAll(exporter.getDependencies());
            }
        }
        HashMap<CallSite, String> versions = new HashMap<CallSite, String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String line : answer) {
            MavenGav gav = MavenGav.parseGav((String)line);
            String ga = gav.getGroupId() + ":" + gav.getArtifactId();
            if (!versions.containsKey(ga)) {
                versions.put((CallSite)((Object)ga), gav.getVersion());
                continue;
            }
            hashSet.add(line);
        }
        answer.removeAll(hashSet);
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copySourceFiles(Path settings, Path profile, Path srcJavaDirRoot, Path srcJavaDir, Path srcResourcesDir, Path srcCamelResourcesDir, Path srcKameletsResourcesDir, String packageName) throws Exception {
        Object scheme;
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)prop, settings);
        String localKameletDir = prop.getProperty("camel.jbang.localKameletDir");
        if (localKameletDir != null && (scheme = ExportBaseCommand.getScheme(localKameletDir)) != null) {
            localKameletDir = localKameletDir.substring(((String)scheme).length() + 1);
        }
        for (String k : SETTINGS_PROP_SOURCE_KEYS) {
            String files = "kamelet".equals(k) ? RuntimeUtil.loadPropertiesLines(settings).stream().filter(l -> l.startsWith("kamelet=")).map(l -> StringHelper.after((String)l, (String)"=")).collect(Collectors.joining(",")) : prop.getProperty(k);
            if (files == null || files.isEmpty()) continue;
            for (String f : files.split(",")) {
                boolean web;
                boolean skip;
                String scheme2 = ExportBaseCommand.getScheme(f);
                if (scheme2 != null) {
                    f = f.substring(scheme2.length() + 1);
                }
                if ((skip = profile.getFileName().toString().equals(f)) || "github".equals(scheme2)) continue;
                String ext = FileUtil.onlyExt((String)f, (boolean)true);
                String ext2 = FileUtil.onlyExt((String)f, (boolean)false);
                if (!"kamelet".equals(k) && ext == null) continue;
                boolean java = "java".equals(ext);
                boolean kamelet = "kamelet".equals(k) || "camel.component.kamelet.location".equals(k) || "camel.jbang.localKameletDir".equals(k) || "kamelet.yaml".equalsIgnoreCase(ext2);
                boolean camel = !kamelet && "camel.main.routesIncludePattern".equals(k);
                boolean jkube = "camel.jbang.jkubeFiles".equals(k);
                boolean script = "camel.jbang.scriptFiles".equals(k);
                boolean groovy = "camel.jbang.groovyFiles".equals(k);
                boolean tls = "camel.jbang.tlsFiles".equals(k);
                boolean bl = web = ext != null && List.of("css", "html", "ico", "jpeg", "jpg", "js", "png").contains(ext);
                Path targetDir = java ? srcJavaDir : (camel ? srcCamelResourcesDir : (kamelet ? srcKameletsResourcesDir : (script ? srcJavaDirRoot.getParent().resolve("scripts") : (groovy ? srcResourcesDir.resolve("camel-groovy") : (tls ? srcJavaDirRoot.getParent().resolve("tls") : (web ? srcResourcesDir.resolve("META-INF/resources") : srcResourcesDir))))));
                Files.createDirectories(targetDir, new FileAttribute[0]);
                Path source = "kamelet".equals(k) && localKameletDir != null ? Paths.get(localKameletDir, f + ".kamelet.yaml") : Paths.get(f, new String[0]);
                Path out = Files.isDirectory(source, new LinkOption[0]) ? targetDir : targetDir.resolve(source.getFileName());
                if (!java) {
                    if (kamelet) {
                        ExportHelper.safeCopy(source, out, true, this.symbolicLink);
                        continue;
                    }
                    if (jkube) {
                        f = f.replace(".jkube.yaml", ".yaml");
                        f = f.replace(".jkube.yml", ".yml");
                        out = srcCamelResourcesDir.getParent().getParent().resolve("jkube/" + f);
                        Files.createDirectories(out.getParent(), new FileAttribute[0]);
                        ExportHelper.safeCopy(source, out, true, this.symbolicLink);
                        continue;
                    }
                    Files.createDirectories(out.getParent(), new FileAttribute[0]);
                    ExportHelper.safeCopy(this.getClass().getClassLoader(), scheme2, source, out, true, this.symbolicLink);
                    continue;
                }
                List<String> lines = Files.readAllLines(source);
                Optional<String> hasPackage = lines.stream().filter(l -> l.trim().startsWith("package ")).findFirst();
                if (hasPackage.isPresent()) {
                    String pn = ExportBaseCommand.determinePackageName(hasPackage.get());
                    if (pn == null) throw new IOException("Cannot determine package name from source: " + String.valueOf(source));
                    Path dir = srcJavaDirRoot.resolve(pn.replace('.', '/'));
                    Files.createDirectories(dir, new FileAttribute[0]);
                    out = dir.resolve(source.getFileName());
                } else if (this.javaLiveReload) {
                    out = srcJavaDirRoot.resolve(source.getFileName());
                } else if (packageName != null && !"false".equalsIgnoreCase(packageName)) {
                    lines.add(0, "");
                    lines.add(0, "package " + packageName + ";");
                }
                if (this.javaLiveReload) {
                    ExportHelper.safeCopy(source, out, true, this.symbolicLink);
                    continue;
                }
                OutputStream fos = Files.newOutputStream(out, new OpenOption[0]);
                for (String line : lines) {
                    this.adjustJavaSourceFileLine(line, fos);
                    fos.write(line.getBytes(StandardCharsets.UTF_8));
                    fos.write("\n".getBytes(StandardCharsets.UTF_8));
                }
                IOHelper.close((Closeable)fos);
            }
        }
        if (this.skipPlugins) return;
        Set exporters = PluginHelper.getActivePlugins(this.getMain()).values().stream().map(Plugin::getExporter).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        for (PluginExporter exporter : exporters) {
            exporter.addSourceFiles(srcJavaDirRoot.getParent().getParent().getParent(), packageName, this.getMain().getOut());
        }
    }

    protected void adjustJavaSourceFileLine(String line, OutputStream fos) throws Exception {
    }

    protected void copySettingsAndProfile(Path settings, Path profile, Path targetDir, Function<Properties, Object> customize) throws Exception {
        String line;
        CamelCaseOrderedProperties settingsProps = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)settingsProps, settings);
        CamelCaseOrderedProperties profileProps = new CamelCaseOrderedProperties();
        if (Files.exists(profile, new LinkOption[0])) {
            RuntimeUtil.loadProperties((Properties)profileProps, profile);
        }
        profileProps.putAll((Map<?, ?>)settingsProps);
        this.prepareApplicationProperties((Properties)profileProps);
        for (Map.Entry<Object, Object> entry : settingsProps.entrySet()) {
            String key = entry.getKey().toString();
            boolean bl = !key.startsWith("camel.main") || "camel.main.routesCompileDirectory".equals(key) || "camel.main.routesReloadEnabled".equals(key);
            if (!bl) continue;
            profileProps.remove(key);
        }
        if (customize != null) {
            customize.apply((Properties)profileProps);
        }
        Path appPropsPath = targetDir.resolve("application.properties");
        StringBuilder content = new StringBuilder();
        for (Map.Entry entry : profileProps.entrySet()) {
            boolean skip;
            String k = entry.getKey().toString();
            String v = entry.getValue().toString();
            boolean bl = skip = k.startsWith("camel.jbang.") || k.startsWith("jkube.");
            if (skip) continue;
            v = v.replaceAll("file:", "classpath:");
            if ("camel.main.routesIncludePattern".equals(k)) {
                v = Arrays.stream(v.split(",")).filter(n -> !n.endsWith(".java") && !n.startsWith("file:") && !n.startsWith("classpath:")).collect(Collectors.joining(","));
            }
            if (v.isBlank() || (line = this.applicationPropertyLine(k, v)) == null || line.isBlank()) continue;
            content.append(line).append("\n");
        }
        CamelCaseOrderedProperties userProps = new CamelCaseOrderedProperties();
        this.prepareUserProperties((Properties)userProps);
        for (Map.Entry<Object, Object> entryUserProp : userProps.entrySet()) {
            String uV;
            String uK = entryUserProp.getKey().toString();
            line = this.applicationPropertyLine(uK, uV = entryUserProp.getValue().toString());
            if (line == null || line.isBlank()) continue;
            content.append(line).append("\n");
        }
        Files.writeString(appPropsPath, (CharSequence)content.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    protected void prepareApplicationProperties(Properties properties) {
    }

    protected void prepareUserProperties(Properties properties) {
        properties.putAll(this.propertiesMap(new String[][]{this.applicationProperties}));
    }

    protected Map<String, String> propertiesMap(String[] ... propertySources) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (propertySources != null) {
            for (String[] props : Arrays.stream(propertySources).filter(Objects::nonNull).toList()) {
                for (String s : props) {
                    String[] kv = s.split("=");
                    if (kv.length != 2) {
                        this.printer().println("WARN: property '" + s + "'' has a bad format (should be 'key=value'), skipping.");
                        continue;
                    }
                    result.put(kv[0], kv[1]);
                }
            }
        }
        return result;
    }

    protected boolean hasOpenapi(Set<String> dependencies) {
        return this.openapi != null || dependencies.stream().anyMatch(s -> s.contains("mvn:org.apache.camel:camel-rest-openapi"));
    }

    protected Properties mapBuildProperties() {
        Properties answer = new Properties();
        this.buildProperties.stream().filter(item -> !item.isEmpty()).map(item -> item.split("=")).forEach(toks -> answer.setProperty(toks[0], toks[1]));
        return answer;
    }

    protected void copyMavenWrapper() throws Exception {
        Path wrapperPath = Paths.get(BUILD_DIR, ".mvn/wrapper");
        Files.createDirectories(wrapperPath, new FileAttribute[0]);
        Path mvnwPath = Paths.get(BUILD_DIR, "mvnw");
        Path mvnwCmdPath = Paths.get(BUILD_DIR, "mvnw.cmd");
        Path wrapperJarPath = wrapperPath.resolve("maven-wrapper.jar");
        Path wrapperPropsPath = wrapperPath.resolve("maven-wrapper.properties");
        try (InputStream is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("maven-wrapper/mvnw");){
            Files.copy(is, mvnwPath, StandardCopyOption.REPLACE_EXISTING);
        }
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("maven-wrapper/mvnw.cmd");
        try {
            Files.copy(is, mvnwCmdPath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("maven-wrapper/maven-wrapper.jar");
        try {
            Files.copy(is, wrapperJarPath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("maven-wrapper/maven-wrapper.properties");
        try {
            Files.copy(is, wrapperPropsPath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        FileUtil.setPosixFilePermissions((Path)mvnwPath, (String)"rwxr-xr-x");
        FileUtil.setPosixFilePermissions((Path)mvnwCmdPath, (String)"rwxr-xr-x");
    }

    protected void copyGradleWrapper() throws Exception {
        Path wrapperPath = Paths.get(BUILD_DIR, "gradle/wrapper");
        Files.createDirectories(wrapperPath, new FileAttribute[0]);
        Path gradlewPath = Paths.get(BUILD_DIR, "gradlew");
        Path gradlewBatPath = Paths.get(BUILD_DIR, "gradlew.bat");
        Path wrapperJarPath = wrapperPath.resolve("gradle-wrapper.jar");
        Path wrapperPropsPath = wrapperPath.resolve("gradle-wrapper.properties");
        try (InputStream is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("gradle-wrapper/gradlew");){
            Files.copy(is, gradlewPath, StandardCopyOption.REPLACE_EXISTING);
        }
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("gradle-wrapper/gradlew.bat");
        try {
            Files.copy(is, gradlewBatPath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("gradle-wrapper/gradle-wrapper.jar");
        try {
            Files.copy(is, wrapperJarPath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("gradle-wrapper/gradle-wrapper.properties");
        try {
            Files.copy(is, wrapperPropsPath, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        FileUtil.setPosixFilePermissions((Path)gradlewPath, (String)"rwxr-xr-x");
        FileUtil.setPosixFilePermissions((Path)gradlewBatPath, (String)"rwxr-xr-x");
    }

    protected String applicationPropertyLine(String key, String value) {
        return key + "=" + value;
    }

    protected String getMavenRepositories(Path settings, Properties prop, String camelVersion) throws Exception {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        String propRepositories = prop.getProperty("camel.jbang.repos");
        if (propRepositories != null) {
            answer.add(propRepositories);
        }
        if (camelVersion == null) {
            camelVersion = new DefaultCamelCatalog().getCatalogVersion();
        }
        if (camelVersion.endsWith("-SNAPSHOT")) {
            answer.add("https://repository.apache.org/content/groups/snapshots/");
        }
        List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
        for (String line : lines) {
            if (!line.startsWith("repository=")) continue;
            String r = StringHelper.after((String)line, (String)"repository=");
            answer.add(r);
        }
        if (this.repositories != null) {
            Collections.addAll(answer, this.repositories.split(","));
        }
        return answer.stream().filter(item -> !item.isEmpty()).collect(Collectors.joining(","));
    }

    protected static boolean hasModeline(Path settings) {
        try {
            List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
            return lines.stream().anyMatch(l -> l.startsWith("modeline="));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static int httpServerPort(Path settings) {
        try {
            List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
            String port = lines.stream().filter(l -> l.startsWith("camel.server.port=")).map(s -> StringHelper.after((String)s, (String)"=")).findFirst().orElse("-1");
            return Integer.parseInt(port);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected static int httpManagementPort(Path settings) {
        try {
            List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
            String port = lines.stream().filter(l -> l.startsWith("camel.management.port=")).map(s -> StringHelper.after((String)s, (String)"=")).findFirst().orElse("-1");
            return Integer.parseInt(port);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected static String jibMavenPluginVersion(Path settings, Properties prop) {
        String answer = null;
        if (prop != null) {
            answer = prop.getProperty("camel.jbang.jib-maven-plugin-version");
        }
        if (answer == null) {
            try {
                List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
                answer = lines.stream().filter(l -> l.startsWith("camel.jbang.jib-maven-plugin-version=")).map(s -> StringHelper.after((String)s, (String)"=")).findFirst().orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return answer != null ? answer : "3.4.5";
    }

    protected static String jkubeMavenPluginVersion(Path settings, Properties props) {
        String answer = null;
        if (props != null) {
            answer = props.getProperty("camel.jbang.jkube-maven-plugin-version");
        }
        if (answer == null) {
            try {
                List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
                answer = lines.stream().filter(l -> l.startsWith("camel.jbang.jkube-maven-plugin-version=") || l.startsWith("jkube.version=")).map(s -> StringHelper.after((String)s, (String)"=")).findFirst().orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return answer != null ? answer : "1.18.1";
    }

    @Deprecated
    protected void safeCopy(File source, File target, boolean override) throws Exception {
        ExportHelper.safeCopy(source.toPath(), target.toPath(), override, this.symbolicLink);
    }

    @Deprecated
    protected void safeCopy(InputStream source, File target) throws Exception {
        ExportHelper.safeCopy(source, target.toPath());
    }

    private static String determinePackageName(String content) {
        Matcher matcher = PACKAGE_PATTERN.matcher(content);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static String normalizeDependency(String dependency) {
        if (dependency.startsWith("camel-quarkus-")) {
            return "camel:" + dependency.substring("camel-quarkus-".length());
        }
        if (dependency.startsWith("camel-quarkus:")) {
            return "camel:" + dependency.substring("camel-quarkus:".length());
        }
        if (dependency.startsWith("camel-")) {
            return "camel:" + dependency.substring("camel-".length());
        }
        return dependency;
    }

    protected MavenGav parseMavenGav(String dep) {
        MavenGav gav;
        if (dep.startsWith("lib:") && dep.endsWith(".jar")) {
            String n = dep.substring(4);
            gav = this.parseLocalJar(n = n.substring(0, n.length() - 4));
            if (gav == null) {
                gav = new MavenGav();
                String v = "1.0";
                String a = n;
                int pos = n.lastIndexOf("-");
                if (pos != -1) {
                    a = n.substring(0, pos);
                    v = n.substring(pos + 1);
                }
                gav.setGroupId("local");
                gav.setArtifactId(a);
                gav.setVersion(v);
                gav.setPackaging("lib");
            }
        } else {
            gav = MavenGav.parseGav((String)dep);
        }
        return gav;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private MavenGav parseLocalJar(String dep) {
        block14: {
            Path path = this.exportBaseDir.resolve(dep + ".jar");
            if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.exists(path, new LinkOption[0])) {
                return null;
            }
            try (JarFile jf = new JarFile(path.toFile());){
                MavenGav mavenGav;
                block15: {
                    Optional<JarEntry> je = jf.stream().filter(e -> e.getName().startsWith("META-INF/maven/") && e.getName().endsWith("/pom.properties")).findFirst();
                    if (!je.isPresent()) break block14;
                    JarEntry e2 = je.get();
                    InputStream is = jf.getInputStream(e2);
                    try {
                        Properties prop = new Properties();
                        prop.load(is);
                        MavenGav gav = new MavenGav();
                        gav.setGroupId(prop.getProperty("groupId"));
                        gav.setArtifactId(prop.getProperty("artifactId"));
                        gav.setVersion(prop.getProperty("version"));
                        gav.setPackaging("lib");
                        mavenGav = gav;
                        if (is == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return mavenGav;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected void copyLocalLibDependencies(Set<String> deps) throws Exception {
        for (String d : deps) {
            if (!d.startsWith("lib:")) continue;
            Path libDirPath = Paths.get(BUILD_DIR, "lib");
            Files.createDirectories(libDirPath, new FileAttribute[0]);
            String n = d.substring(4);
            Path sourcePath = Paths.get(n, new String[0]);
            Path targetPath = libDirPath.resolve(n);
            ExportHelper.safeCopy(sourcePath, targetPath, true, this.symbolicLink);
        }
    }

    protected void copyAgentDependencies(Set<String> deps) throws Exception {
        for (String d : deps) {
            if (!d.startsWith("agent:")) continue;
            Path libDirPath = Paths.get(BUILD_DIR, "agent");
            Files.createDirectories(libDirPath, new FileAttribute[0]);
            String n = d.substring(6);
            MavenGav gav = MavenGav.parseGav((String)n);
            this.copyAgentLibDependencies(gav);
        }
    }

    private void copyAgentLibDependencies(MavenGav gav) {
        try {
            List artifacts = this.getDownloader().resolveArtifacts(List.of(gav.toString()), Set.of(), true, gav.getVersion().contains("SNAPSHOT"));
            for (MavenArtifact artifact : artifacts) {
                Path target = Paths.get(BUILD_DIR, "agent", artifact.getFile().getName());
                if (Files.exists(target, new LinkOption[0]) || EXCLUDED_GROUP_IDS.contains(artifact.getGav().getGroupId())) continue;
                Files.copy(artifact.getFile().toPath(), target, new CopyOption[0]);
            }
        }
        catch (MavenResolutionException e) {
            this.printer().printErr("Error resolving the artifact: " + String.valueOf(gav) + " due to: " + e.getMessage());
        }
        catch (IOException e) {
            this.printer().printErr("Error copying the artifact: " + String.valueOf(gav) + " due to: " + e.getMessage());
        }
    }

    protected void copyApplicationPropertiesFiles(Path srcResourcesDir) throws Exception {
        try {
            Files.list(this.exportBaseDir).filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(p -> {
                String fileName = p.getFileName().toString();
                String ext = FileUtil.onlyExt((String)fileName);
                String name = FileUtil.onlyName((String)fileName);
                if (!"properties".equals(ext)) {
                    return false;
                }
                if (name.equals("application")) {
                    return false;
                }
                if (this.profile == null) {
                    return name.startsWith("application");
                }
                return name.equals("application-" + this.profile);
            }).forEach(p -> {
                try {
                    ExportHelper.safeCopy(p, srcResourcesDir.resolve(p.getFileName()), true, this.symbolicLink);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    protected void copyApplicationPropertiesFiles(File srcResourcesDir) throws Exception {
        this.copyApplicationPropertiesFiles(srcResourcesDir.toPath());
    }

    private MavenDownloader getDownloader() {
        if (this.downloader == null) {
            this.init();
        }
        return this.downloader;
    }

    private void init() {
        this.downloader = new MavenDownloaderImpl();
        ((MavenDownloaderImpl)this.downloader).build();
    }

    protected Printer outPrinter() {
        return super.printer();
    }

    @Override
    protected Printer printer() {
        if (this.quiet) {
            if (this.quietPrinter == null) {
                this.quietPrinter = new Printer.QuietPrinter(super.printer());
            }
            CommandHelper.setPrinter(this.quietPrinter);
            return this.quietPrinter;
        }
        return super.printer();
    }

    static class FilesConsumer
    extends CamelCommand.ParameterConsumer<Export> {
        FilesConsumer() {
        }

        @Override
        protected void doConsumeParameters(Stack<String> args, Export cmd) {
            String arg = args.pop();
            cmd.files.add(arg);
        }
    }
}

