/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.DependencyList;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.xml.XmlLineNumberParser;
import org.apache.logging.log4j.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"Updates dependencies in Maven pom.xml or Java source file (JBang style)"}, sortOptions=false, showDefaultValues=true)
public class DependencyUpdate
extends DependencyList {
    @CommandLine.Parameters(description={"Maven pom.xml or Java source files (JBang Style with //DEPS) to have dependencies updated"}, arity="1")
    public Path file;
    @CommandLine.Option(names={"--clean"}, description={"Regenerate list of dependencies (do not keep existing dependencies). Not supported for pom.xml"})
    protected boolean clean;
    private final List<String> deps = new ArrayList<String>();
    private final List<MavenGav> gavs = new ArrayList<MavenGav>();

    public DependencyUpdate(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (!Files.exists(this.file, new LinkOption[0])) {
            this.printer().printErr("Source file does not exist: " + String.valueOf(this.file));
            return -1;
        }
        boolean maven = "pom.xml".equals(this.file.getFileName().toString());
        if (this.clean && !maven) {
            this.updateJBangSource();
        }
        if (maven && this.runtime == null) {
            String pomContent = new String(Files.readAllBytes(this.file));
            if (pomContent.contains("quarkus")) {
                this.runtime = RuntimeType.quarkus;
            } else if (pomContent.contains("spring-boot")) {
                this.runtime = RuntimeType.springBoot;
            } else if (pomContent.contains("camel-main")) {
                this.runtime = RuntimeType.main;
            }
        }
        return super.doCall();
    }

    @Override
    protected void outputGav(MavenGav gav, int index, int total) {
        try {
            boolean maven = "pom.xml".equals(this.file.getFileName().toString());
            if (maven) {
                this.outputGavMaven(gav, index, total);
            } else {
                this.outputGavJBang(gav, index, total);
            }
        }
        catch (Exception e) {
            this.printer().printErr("Cannot update dependencies due to " + e.getMessage(), e);
        }
    }

    protected void outputGavMaven(MavenGav gav, int index, int total) throws Exception {
        boolean last;
        this.gavs.add(gav);
        boolean bl = last = total - index <= 1;
        if (last) {
            this.updateMavenSource();
        }
    }

    protected void outputGavJBang(MavenGav gav, int index, int total) {
        boolean last;
        String line;
        if (index == 0) {
            this.deps.add("//DEPS org.apache.camel:camel-bom:" + gav.getVersion() + "@pom");
        }
        if (gav.getGroupId().equals("org.apache.camel")) {
            gav.setVersion(null);
        }
        if (!this.deps.contains(line = "//DEPS " + String.valueOf(gav))) {
            this.deps.add(line);
        }
        boolean bl = last = total - index <= 1;
        if (last) {
            this.updateJBangSource();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateJBangSource() {
        try {
            List<String> lines = Files.readAllLines(this.file);
            ArrayList<Object> answer = new ArrayList<Object>();
            int pos = -1;
            for (int i = 0; i < lines.size(); ++i) {
                String string = lines.get(i);
                String l = string.trim();
                while (l.startsWith("#")) {
                    l = l.substring(1);
                }
                if (l.startsWith("//DEPS ")) {
                    if (pos != -1) continue;
                    pos = i;
                    continue;
                }
                answer.add(string);
            }
            if (pos == -1 && ((String)answer.get(0)).trim().startsWith("///usr/bin/env jbang")) {
                pos = 1;
            }
            if (pos == -1) {
                pos = 0;
            }
            Collections.reverse(this.deps);
            for (String string : this.deps) {
                void var5_11;
                String ext = FileUtil.onlyExt((String)this.file.getFileName().toString(), (boolean)true);
                if ("yaml".equals(ext)) {
                    String string2 = "#" + string;
                }
                answer.add(pos, var5_11);
            }
            String text = String.join((CharSequence)System.lineSeparator(), answer);
            Files.writeString(this.file, (CharSequence)text, new OpenOption[0]);
        }
        catch (Exception e) {
            this.printer().printErr("Error updating source file: " + String.valueOf(this.file) + " due to: " + e.getMessage());
        }
    }

    private void updateMavenSource() throws Exception {
        ArrayList<MavenGav> existingGavs = new ArrayList<MavenGav>();
        Node camelClone = null;
        int targetLineNumber = -1;
        Path pom = this.file;
        if (Files.exists(pom, new LinkOption[0])) {
            Document dom = XmlLineNumberParser.parseXml((InputStream)Files.newInputStream(pom, new OpenOption[0]));
            String camelVersion = null;
            NodeList nl = dom.getElementsByTagName("dependency");
            for (int i = 0; i < nl.getLength(); ++i) {
                String num;
                boolean bl;
                Element node = (Element)nl.item(i);
                String p = node.getParentNode().getNodeName();
                String p2 = node.getParentNode().getParentNode().getNodeName();
                boolean bl2 = bl = ("dependencyManagement".equals(p2) || "project".equals(p2)) && p.equals("dependencies");
                if (!bl) continue;
                String g = node.getElementsByTagName("groupId").item(0).getTextContent();
                String a = node.getElementsByTagName("artifactId").item(0).getTextContent();
                String v = null;
                NodeList vl = node.getElementsByTagName("version");
                if (vl.getLength() > 0) {
                    v = vl.item(0).getTextContent();
                }
                Object scope = null;
                vl = node.getElementsByTagName("scope");
                if (vl.getLength() > 0) {
                    scope = vl.item(0).getTextContent();
                }
                if (scope != null && !"compile".equals(scope)) continue;
                if ("org.apache.camel".equals(g)) {
                    camelVersion = v;
                    if (camelClone == null && !"camel-bom".equals(a)) {
                        camelClone = node.cloneNode(true);
                    }
                    if ((num = (String)node.getUserData("lineNumberEnd")) != null) {
                        targetLineNumber = Integer.parseInt(num);
                    }
                    if ((num = (String)node.getUserData("lineNumberEnd")) != null) {
                        targetLineNumber = Integer.parseInt(num);
                    }
                }
                if ("org.apache.camel.springboot".equals(g)) {
                    camelVersion = v;
                    num = (String)node.getUserData("lineNumberEnd");
                    if (num != null) {
                        targetLineNumber = Integer.parseInt(num);
                    }
                }
                if ("org.apache.camel.quarkus".equals(g) && (num = (String)node.getUserData("lineNumberEnd")) != null) {
                    targetLineNumber = Integer.parseInt(num);
                }
                if (v != null) {
                    existingGavs.add(MavenGav.parseGav((String)(g + ":" + a + ":" + v)));
                    continue;
                }
                existingGavs.add(MavenGav.parseGav((String)(g + ":" + a)));
            }
            ArrayList<Object> updates = new ArrayList<Object>();
            for (MavenGav gav : this.gavs) {
                MavenGav target = "org.apache.camel.kamelets".equals(gav.getGroupId()) ? gav : (camelVersion != null ? MavenGav.parseGav((String)(gav.getGroupId() + ":" + gav.getArtifactId() + ":" + camelVersion)) : MavenGav.parseGav((String)(gav.getGroupId() + ":" + gav.getArtifactId())));
                updates.add(target);
            }
            updates.sort(this.mavenGavComparator());
            ArrayList<MavenGav> toBeUpdated = new ArrayList<MavenGav>();
            int changes = 0;
            for (MavenGav mavenGav : updates) {
                if (existingGavs.contains(mavenGav)) continue;
                toBeUpdated.add(mavenGav);
                ++changes;
            }
            if (changes > 0) {
                String line = IOHelper.loadTextLine((InputStream)Files.newInputStream(this.file, new OpenOption[0]), (int)targetLineNumber);
                line = StringHelper.before((String)line, (String)"<");
                int n = StringHelper.countChar((String)line, (char)' ');
                String pad = Strings.repeat((String)" ", (int)n);
                line = IOHelper.loadTextLine((InputStream)Files.newInputStream(this.file, new OpenOption[0]), (int)(targetLineNumber - 1));
                line = StringHelper.before((String)line, (String)"<");
                int indent2 = StringHelper.countChar((String)line, (char)' ');
                String pad2 = Strings.repeat((String)" ", (int)indent2);
                StringJoiner sj = new StringJoiner("");
                for (MavenGav gav : toBeUpdated) {
                    sj.add("\n").add(pad).add("<dependency>\n");
                    sj.add(pad2).add("<groupId>" + gav.getGroupId() + "</groupId>\n");
                    sj.add(pad2).add("<artifactId>" + gav.getArtifactId() + "</artifactId>\n");
                    if (gav.getVersion() != null) {
                        sj.add(pad2).add("<version>" + gav.getVersion() + "</version>\n");
                    }
                    if (gav.getScope() != null) {
                        sj.add(pad2).add("<scope>" + gav.getScope() + "</scope>\n");
                    }
                    sj.add(pad).add("</dependency>");
                }
                StringJoiner out = new StringJoiner("\n");
                String[] lines = IOHelper.loadText((InputStream)Files.newInputStream(this.file, new OpenOption[0])).split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    String txt = lines[i];
                    out.add(txt);
                    if (i != targetLineNumber - 1) continue;
                    out.add(sj.toString());
                }
                if (changes > 1) {
                    this.outPrinter().println("Updating pom.xml with " + changes + " dependencies added");
                } else {
                    this.outPrinter().println("Updating pom.xml with 1 dependency added");
                }
                Files.writeString(this.file, (CharSequence)out.toString(), new OpenOption[0]);
            } else {
                this.outPrinter().println("No updates to pom.xml");
            }
        } else {
            this.outPrinter().println("pom.xml not found " + String.valueOf(pom.toAbsolutePath()));
        }
    }
}

