/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.ExportCamelMain;
import org.apache.camel.dsl.jbang.core.commands.ExportQuarkus;
import org.apache.camel.dsl.jbang.core.commands.ExportSpringBoot;
import org.apache.camel.dsl.jbang.core.commands.RunHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.XmlHelper;
import org.apache.camel.main.util.VersionHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Displays all Camel dependencies required to run"}, sortOptions=false, showDefaultValues=true)
public class DependencyList
extends Export {
    protected static final String EXPORT_DIR = ".camel-jbang/export";
    @CommandLine.Option(names={"--output"}, description={"Output format (gav, maven, jbang)"}, defaultValue="gav")
    protected String output;

    public DependencyList(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        this.quiet = true;
        this.ignoreLoadingError = true;
        this.lazyBean = true;
        return super.doCall();
    }

    @Override
    protected Integer export() throws Exception {
        Integer answer;
        String name;
        Path first;
        if (!("gav".equals(this.output) || "maven".equals(this.output) || "jbang".equals(this.output))) {
            this.printer().printErr("--output must be either gav or maven, was: " + this.output);
            return 1;
        }
        this.exportBaseDir = Path.of(".", new String[0]);
        if (this.files != null && this.files.size() == 1 && Files.isDirectory(first = Path.of(name = FileUtil.stripTrailingSeparator((String)((String)this.files.get(0))), new String[0]), new LinkOption[0])) {
            this.exportBaseDir = first;
            RunHelper.dirToFiles(name, this.files);
        }
        if ((answer = this.doExport()) == 0) {
            Path pom = Paths.get(EXPORT_DIR, new String[0]).resolve("pom.xml");
            if (Files.exists(pom, new LinkOption[0])) {
                int i;
                DocumentBuilderFactory dbf = XmlHelper.createDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(Files.newInputStream(pom, new OpenOption[0]));
                NodeList nl = dom.getElementsByTagName("dependency");
                ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
                String camelVersion = null;
                String springBootVersion = null;
                String quarkusVersion = null;
                for (i = 0; i < nl.getLength(); ++i) {
                    boolean accept;
                    Element node = (Element)nl.item(i);
                    String p2 = node.getParentNode().getNodeName();
                    String p22 = node.getParentNode().getParentNode().getNodeName();
                    boolean bl = accept = ("dependencyManagement".equals(p22) || "project".equals(p22)) && p2.equals("dependencies");
                    if (!accept) continue;
                    String g = node.getElementsByTagName("groupId").item(0).getTextContent();
                    String a = node.getElementsByTagName("artifactId").item(0).getTextContent();
                    String v = null;
                    NodeList vl = node.getElementsByTagName("version");
                    if (vl.getLength() > 0) {
                        v = vl.item(0).getTextContent();
                    }
                    if ("org.apache.camel".equals(g) && "camel-bom".equals(a)) {
                        camelVersion = v;
                        continue;
                    }
                    if ("org.apache.camel.springboot".equals(g) && "camel-spring-boot-bom".equals(a)) {
                        camelVersion = v;
                        continue;
                    }
                    if ("org.springframework.boot".equals(g) && "spring-boot-dependencies".equals(a)) {
                        springBootVersion = v;
                        continue;
                    }
                    if (("${quarkus.platform.group-id}".equals(g) || "io.quarkus.platform".equals(g)) && ("${quarkus.platform.artifact-id}".equals(a) || "quarkus-bom".equals(a))) {
                        if ("${quarkus.platform.version}".equals(v)) {
                            quarkusVersion = dom.getElementsByTagName("quarkus.platform.version").item(0).getTextContent();
                            continue;
                        }
                        quarkusVersion = v;
                        continue;
                    }
                    String scope = null;
                    NodeList sl = node.getElementsByTagName("scope");
                    if (sl.getLength() > 0) {
                        scope = sl.item(0).getTextContent();
                    }
                    if ("test".equals(scope) || "import".equals(scope)) continue;
                    if (v == null && g.equals("org.apache.camel")) {
                        v = camelVersion;
                    }
                    if (v == null && g.equals("org.apache.camel.kamelets")) {
                        v = this.kameletsVersion != null ? this.kameletsVersion : VersionHelper.extractKameletsVersion();
                    }
                    if (v == null && g.equals("org.apache.camel.springboot")) {
                        v = camelVersion;
                    }
                    if (v == null && g.equals("org.springframework.boot")) {
                        v = springBootVersion;
                    }
                    if (v == null && (g.equals("io.quarkus") || g.equals("org.apache.camel.quarkus"))) {
                        v = quarkusVersion;
                    }
                    if (this.skipArtifact(g, a, v)) continue;
                    if (v != null) {
                        gavs.add(MavenGav.parseGav((String)(g + ":" + a + ":" + v)));
                        continue;
                    }
                    gavs.add(MavenGav.parseGav((String)(g + ":" + a)));
                }
                gavs.sort(this.mavenGavComparator());
                i = 0;
                int total = gavs.size();
                for (MavenGav gav : gavs) {
                    this.outputGav(gav, i, total);
                    ++i;
                }
            }
            Path buildDir = Paths.get(EXPORT_DIR, new String[0]);
            try {
                Files.walk(buildDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
                    try {
                        Files.deleteIfExists(p);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    protected void outputGav(MavenGav gav, int index, int total) {
        if ("gav".equals(this.output)) {
            this.outPrinter().println(String.valueOf(gav));
        } else if ("maven".equals(this.output)) {
            this.outPrinter().println("<dependency>");
            this.outPrinter().printf("    <groupId>%s</groupId>%n", gav.getGroupId());
            this.outPrinter().printf("    <artifactId>%s</artifactId>%n", gav.getArtifactId());
            this.outPrinter().printf("    <version>%s</version>%n", gav.getVersion());
            if (gav.getScope() != null) {
                this.outPrinter().printf("    <scope>%s</scope>%n", gav.getScope());
            }
            this.outPrinter().println("</dependency>");
        } else if ("jbang".equals(this.output)) {
            if (index == 0) {
                this.outPrinter().println("//DEPS org.apache.camel:camel-bom:" + gav.getVersion() + "@pom");
            }
            if (gav.getGroupId().equals("org.apache.camel")) {
                gav.setVersion(null);
            }
            this.outPrinter().println("//DEPS " + String.valueOf(gav));
        }
    }

    @Override
    protected Integer doExport() throws Exception {
        Path profile = this.exportBaseDir.resolve("application.properties");
        if (Files.exists(profile, new LinkOption[0])) {
            CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
            try (InputStream is = Files.newInputStream(profile, new OpenOption[0]);){
                prop.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.runtime == null && prop.containsKey("camel.jbang.runtime")) {
                this.runtime = RuntimeType.fromValue(prop.getProperty("camel.jbang.runtime"));
            }
            if (this.gav == null) {
                this.gav = prop.getProperty("camel.jbang.gav");
            }
            this.javaVersion = prop.getProperty("camel.jbang.javaVersion", this.javaVersion);
            this.camelVersion = prop.getProperty("camel.jbang.camel-version", this.camelVersion);
            this.kameletsVersion = prop.getProperty("camel.jbang.kameletsVersion", this.kameletsVersion);
            this.localKameletDir = prop.getProperty("camel.jbang.localKameletDir", this.localKameletDir);
            this.quarkusGroupId = prop.getProperty("camel.jbang.quarkusGroupId", this.quarkusGroupId);
            this.quarkusArtifactId = prop.getProperty("camel.jbang.quarkusArtifactId", this.quarkusArtifactId);
            this.quarkusVersion = prop.getProperty("camel.jbang.quarkusVersion", this.quarkusVersion);
            this.springBootVersion = prop.getProperty("camel.jbang.springBootVersion", this.springBootVersion);
        }
        this.exportDir = EXPORT_DIR;
        if (this.gav == null) {
            this.gav = "org.example.project:camel-jbang-dummy:1.0";
        }
        if (this.runtime == null) {
            this.runtime = RuntimeType.main;
        }
        switch (this.runtime) {
            case springBoot: {
                return this.export(this.exportBaseDir, new ExportSpringBoot(this.getMain()));
            }
            case quarkus: {
                return this.export(this.exportBaseDir, new ExportQuarkus(this.getMain()));
            }
            case main: {
                return this.export(this.exportBaseDir, new ExportCamelMain(this.getMain()));
            }
        }
        this.printer().printErr("Unknown runtime: " + String.valueOf((Object)this.runtime));
        return 1;
    }

    protected boolean skipArtifact(String groupId, String artifactId, String version) {
        if ("org.fusesource.jansi".equals(groupId)) {
            return true;
        }
        return "org.apache.logging.log4j".equals(groupId);
    }
}

