/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.DependencyList;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.tooling.maven.MavenDownloader;
import org.apache.camel.tooling.maven.MavenDownloaderImpl;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.maven.MavenResolutionException;
import org.apache.camel.util.FileUtil;
import picocli.CommandLine;

@CommandLine.Command(name="copy", description={"Copies all Camel dependencies required to run to a specific directory"}, sortOptions=false, showDefaultValues=true)
public class DependencyCopy
extends DependencyList {
    private static final Set<String> EXCLUDED_GROUP_IDS = Set.of("org.fusesource.jansi", "org.apache.logging.log4j");
    private MavenDownloader downloader;
    @CommandLine.Option(names={"--output-directory"}, description={"Directory where dependencies should be copied"}, defaultValue="lib", required=true)
    protected String outputDirectory;

    public DependencyCopy(CamelJBangMain main) {
        super(main);
    }

    private void createOutputDirectory() {
        Path outputDirectoryPath = Paths.get(this.outputDirectory, new String[0]);
        if (Files.exists(outputDirectoryPath, new LinkOption[0])) {
            if (Files.isDirectory(outputDirectoryPath, new LinkOption[0])) {
                FileUtil.removeDir((File)outputDirectoryPath.toFile());
            } else {
                this.printer().printErr("Error creating the output directory: " + this.outputDirectory + " is not a directory");
                return;
            }
        }
        try {
            Files.createDirectories(outputDirectoryPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error creating the output directory: " + this.outputDirectory, e);
        }
    }

    @Override
    protected void outputGav(MavenGav gav, int index, int total) {
        try {
            List artifacts = this.getDownloader().resolveArtifacts(List.of(gav.toString()), Set.of(), true, gav.getVersion().contains("SNAPSHOT"));
            for (MavenArtifact artifact : artifacts) {
                Path target = Paths.get(this.outputDirectory, artifact.getFile().getName());
                if (Files.exists(target, new LinkOption[0]) || EXCLUDED_GROUP_IDS.contains(artifact.getGav().getGroupId())) continue;
                Files.copy(artifact.getFile().toPath(), target, new CopyOption[0]);
            }
        }
        catch (MavenResolutionException e) {
            this.printer().printErr("Error resolving the artifact: " + String.valueOf(gav) + " due to: " + e.getMessage());
        }
        catch (IOException e) {
            this.printer().printErr("Error copying the artifact: " + String.valueOf(gav) + " due to: " + e.getMessage());
        }
    }

    private MavenDownloader getDownloader() {
        if (this.downloader == null) {
            this.init();
        }
        return this.downloader;
    }

    private void init() {
        this.downloader = new MavenDownloaderImpl();
        ((MavenDownloaderImpl)this.downloader).build();
        this.createOutputDirectory();
    }
}

