/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.util.Arrays;
import java.util.Locale;

public enum SourceScheme {
    GIST("https://gist.github", true),
    GITHUB("https://github.com/", true),
    RAW_GITHUB("https://raw.githubusercontent.com/", true),
    FILE,
    CLASSPATH,
    HTTP(true),
    HTTPS(true),
    UNKNOWN;

    private final String uri;
    private final boolean remote;

    private SourceScheme() {
        this(false);
    }

    private SourceScheme(boolean remote) {
        this(null, remote);
    }

    private SourceScheme(String uri, boolean remote) {
        this.uri = uri;
        this.remote = remote;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public static SourceScheme fromUri(String path) {
        return Arrays.stream(SourceScheme.values()).filter(scheme -> path.startsWith(scheme.name().toLowerCase(Locale.US) + ":") || scheme.uri != null && path.startsWith(scheme.uri)).findFirst().orElse(UNKNOWN);
    }

    public static String onlyName(String name) {
        for (SourceScheme scheme : SourceScheme.values()) {
            if (!name.startsWith(scheme.name().toLowerCase(Locale.US) + ":")) continue;
            return name.substring(scheme.name().length() + 1);
        }
        return name;
    }
}

