/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dsl.jbang.core.common.GistHelper;
import org.apache.camel.dsl.jbang.core.common.GitHubHelper;
import org.apache.camel.dsl.jbang.core.common.Source;
import org.apache.camel.dsl.jbang.core.common.SourceScheme;
import org.apache.camel.github.GistResourceResolver;
import org.apache.camel.github.GitHubResourceResolver;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultResourceResolvers;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;

public class SourceHelper {
    private static final String[] ACCEPTED_FILE_EXT = new String[]{"java", "xml", "yaml"};

    public static Source resolveSource(String source) {
        List<Source> resolved = SourceHelper.resolveSources(Collections.singletonList(source));
        if (resolved.isEmpty()) {
            throw new RuntimeCamelException("Failed to resolve source file: " + source);
        }
        return resolved.get(0);
    }

    public static List<Source> resolveSources(List<String> sources) {
        return SourceHelper.resolveSources(sources, false);
    }

    public static List<Source> resolveSources(List<String> sources, boolean compression) {
        ArrayList<Source> resolved = new ArrayList<Source>();
        block45: for (String source : sources) {
            SourceScheme sourceScheme = SourceScheme.fromUri(source);
            String fileExtension = FileUtil.onlyExt((String)source, (boolean)true);
            Object fileName = SourceScheme.onlyName(FileUtil.onlyName((String)source));
            if (fileExtension != null) {
                fileName = (String)fileName + "." + fileExtension;
            }
            try {
                switch (sourceScheme) {
                    case GIST: {
                        StringJoiner all = new StringJoiner(",");
                        GistHelper.fetchGistUrls(source, all);
                        GistResourceResolver resolver = new GistResourceResolver();
                        try {
                            for (String uri : all.toString().split(",")) {
                                resolved.add(new Source(sourceScheme, FileUtil.stripPath((String)uri), IOHelper.loadText((InputStream)resolver.resolve(uri).getInputStream()), FileUtil.onlyExt((String)uri), compression));
                            }
                            continue block45;
                        }
                        finally {
                            resolver.close();
                            continue block45;
                        }
                    }
                    case HTTP: {
                        DefaultResourceResolvers.HttpResolver resolver = new DefaultResourceResolvers.HttpResolver();
                        try {
                            resolved.add(new Source(sourceScheme, (String)fileName, IOHelper.loadText((InputStream)resolver.resolve(source).getInputStream()), fileExtension, compression));
                            continue block45;
                        }
                        finally {
                            resolver.close();
                            continue block45;
                        }
                    }
                    case HTTPS: {
                        DefaultResourceResolvers.HttpResolver resolver = new DefaultResourceResolvers.HttpsResolver();
                        try {
                            resolved.add(new Source(sourceScheme, (String)fileName, IOHelper.loadText((InputStream)resolver.resolve(source).getInputStream()), fileExtension, compression));
                            continue block45;
                        }
                        finally {
                            resolver.close();
                            continue block45;
                        }
                    }
                    case FILE: {
                        DefaultResourceResolvers.HttpResolver resolver = new DefaultResourceResolvers.FileResolver();
                        try {
                            resolved.add(new Source(sourceScheme, (String)fileName, IOHelper.loadText((InputStream)resolver.resolve(source).getInputStream()), fileExtension, compression));
                            continue block45;
                        }
                        finally {
                            resolver.close();
                            continue block45;
                        }
                    }
                    case CLASSPATH: {
                        DefaultResourceResolvers.HttpResolver resolver = new DefaultResourceResolvers.ClasspathResolver();
                        try {
                            resolver.setCamelContext((CamelContext)new DefaultCamelContext());
                            resolved.add(new Source(sourceScheme, (String)fileName, IOHelper.loadText((InputStream)resolver.resolve(source).getInputStream()), fileExtension, compression));
                            continue block45;
                        }
                        finally {
                            resolver.close();
                            continue block45;
                        }
                    }
                    case GITHUB: 
                    case RAW_GITHUB: {
                        StringJoiner all = new StringJoiner(",");
                        GitHubHelper.fetchGithubUrls(source, all);
                        GistResourceResolver resolver = new GitHubResourceResolver();
                        try {
                            for (String uri : all.toString().split(",")) {
                                resolved.add(new Source(sourceScheme, FileUtil.stripPath((String)uri), IOHelper.loadText((InputStream)resolver.resolve(uri).getInputStream()), FileUtil.onlyExt((String)uri), compression));
                            }
                            continue block45;
                        }
                        finally {
                            resolver.close();
                            continue block45;
                        }
                    }
                    case UNKNOWN: {
                        if (!SourceHelper.isAcceptedSourceFile(fileExtension)) break;
                        Path sourcePath = Paths.get(source, new String[0]);
                        if (!Files.exists(sourcePath, new LinkOption[0])) {
                            throw new FileNotFoundException("Source file '%s' does not exist".formatted(source));
                        }
                        if (Files.isDirectory(sourcePath, new LinkOption[0])) break;
                        InputStream is = Files.newInputStream(sourcePath, new OpenOption[0]);
                        try {
                            resolved.add(new Source(sourceScheme, (String)fileName, IOHelper.loadText((InputStream)is), fileExtension, compression));
                            if (is == null) break;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        is.close();
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Failed to resolve sources", (Throwable)e);
            }
        }
        return resolved;
    }

    public static boolean isAcceptedSourceFile(String fileExt) {
        return Arrays.stream(ACCEPTED_FILE_EXT).anyMatch(e -> e.equalsIgnoreCase(fileExt));
    }
}

