/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.util.Arrays;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;

public final class ProcessHelper {
    private static final String[] DSL_EXT = new String[]{"java", "xml", "yaml"};
    private static final Pattern PATTERN = Pattern.compile("([\\w|\\-.])+");

    private ProcessHelper() {
    }

    public static String extractName(JsonObject root, ProcessHandle ph) {
        String name = ProcessHelper.doExtractName(root, ph);
        return FileUtil.stripPath((String)name);
    }

    static String doExtractName(JsonObject root, ProcessHandle ph) {
        JsonObject jo;
        boolean camel;
        String mc;
        if (root != null && (mc = ProcessHelper.extractMainClass(root)) != null) {
            return mc;
        }
        String cl = ph != null ? ph.info().commandLine().orElse("") : "";
        String mvn = ProcessHelper.extractMavenPluginName(cl);
        if (mvn != null && ph != null && (camel = ph.children().anyMatch(ch -> !ProcessHelper.extractName(root, ch).isEmpty()))) {
            return "";
        }
        String name = ProcessHelper.extractCamelJBangName(cl);
        if (name != null && !name.isEmpty()) {
            return name;
        }
        mvn = ProcessHelper.extractMavenPluginName(cl);
        if (mvn == null && ph != null && ph.parent().isPresent()) {
            String clp = ph.parent().get().info().commandLine().orElse("");
            mvn = ProcessHelper.extractMavenPluginName(clp);
        }
        if ((name = ProcessHelper.extractCamelName(cl, mvn)) == null && root != null && (jo = (JsonObject)root.get((Object)"context")) != null) {
            name = jo.getString("name");
        }
        return name == null ? "" : name;
    }

    private static String extractMavenPluginName(String cl) {
        String name = StringHelper.after((String)cl, (String)"org.codehaus.plexus.classworlds.launcher.Launcher");
        if (name != null) {
            return name.trim();
        }
        return null;
    }

    static String extractMainClass(JsonObject root) {
        JsonObject runtime = (JsonObject)root.get((Object)"runtime");
        return runtime != null ? runtime.getString("mainClass") : null;
    }

    private static String extractCamelName(String cl, String mvn) {
        if (cl != null) {
            if (cl.contains("camel-spring-boot") && mvn != null) {
                int pos = cl.lastIndexOf(" ");
                if (pos != -1) {
                    String after = cl.substring(pos);
                    if ((after = after.trim()).matches("[\\w|.]+")) {
                        return after;
                    }
                }
                return mvn;
            }
            if (cl.contains("camel-quarkus") && mvn != null) {
                return mvn;
            }
            int pos = cl.lastIndexOf(" ");
            if (pos != -1) {
                String after = cl.substring(pos);
                if ((after = after.trim()).matches("[\\w|.]+")) {
                    return after;
                }
            }
            if (mvn != null) {
                return mvn;
            }
        }
        return null;
    }

    static String extractCamelJBangName(String cl) {
        String name = StringHelper.after((String)cl, (String)"main.CamelJBang run");
        if (name != null) {
            name = name.trim();
            StringJoiner js = new StringJoiner(" ");
            Matcher matcher = PATTERN.matcher(name);
            while (matcher.find()) {
                String part = matcher.group();
                String ext = FileUtil.onlyExt((String)part, (boolean)true);
                if (ext == null || !Arrays.asList(DSL_EXT).contains(ext)) continue;
                js.add(part);
            }
            return js.toString();
        }
        return null;
    }
}

