/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.util.Arrays;
import java.util.Optional;

public enum PluginType {
    KUBERNETES("kubernetes", "kubernetes", "Run Camel applications on Kubernetes", "4.8.0"),
    GENERATE("generate", "generate", "Generate code such as DTOs", "4.8.0"),
    EDIT("edit", "edit", "Edit Camel files with suggestions", "4.12.0");

    private final String name;
    private final String command;
    private final String description;
    private final String firstVersion;

    private PluginType(String name, String command, String description, String firstVersion) {
        this.name = name;
        this.command = command;
        this.description = description;
        this.firstVersion = firstVersion;
    }

    public static Optional<PluginType> findByName(String name) {
        return Arrays.stream(PluginType.values()).filter(p -> p.name.equalsIgnoreCase(name)).findFirst();
    }

    public String getName() {
        return this.name;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFirstVersion() {
        return this.firstVersion;
    }
}

