/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.update;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.util.json.Jsoner;
import org.apache.maven.artifact.versioning.ComparableVersion;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List available update versions for Apache Camel and its runtime variants"})
public class UpdateList
extends CamelCommand {
    @CommandLine.Option(names={"--repos"}, description={"Additional maven repositories for download on-demand (Use commas to separate multiple repositories)"})
    String repos;
    @CommandLine.Option(names={"--json"}, description={"Output in JSON Format"})
    boolean jsonOutput;
    @CommandLine.Option(names={"--use-cache"}, description={"Use Maven cache"})
    boolean useCache;
    private static final String CAMEL_UPGRADE_GROUPID = "org.apache.camel.upgrade";
    private static final String CAMEL_UPGRADE_ARTIFACTID = "camel-upgrade-recipes";
    private static final String CAMEL_SB_UPGRADE_ARTIFACTID = "camel-spring-boot-upgrade-recipes";
    private static final String FIRST_RECIPE_VERSION = "4.8.0";
    private static final String QUARKUS_FIRST_RECIPE_VERSION = "1.0.22";
    private static final String QUARKUS_FIRST_UPDATABLE_VERSION = "4.4.0";

    public UpdateList(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        try (MavenDependencyDownloader downloader = new MavenDependencyDownloader();){
            downloader.setRepositories(this.repos);
            downloader.setFresh(!this.useCache);
            downloader.start();
            RecipeVersions recipesVersions = this.collectRecipesVersions(downloader);
            recipesVersions.plainCamelRecipesVersion().forEach(l -> rows.add(new Row(l[0], "Camel", "", "Migrates Apache Camel 4 application to Apache Camel " + l[0])));
            recipesVersions.camelSpringBootRecipesVersion().forEach(l -> {
                String[] runtimeVersion = recipesVersions.sbVersions().stream().filter(v -> v[0].equals(l[0])).findFirst().orElseThrow();
                rows.add(new Row(l[0], "Camel Spring Boot", runtimeVersion[1], "Migrates Apache Camel Spring Boot 4 application to Apache Camel Spring Boot " + l[0]));
            });
            recipesVersions.camelQuarkusRecipesVersions();
            recipesVersions.quarkusUpdateRecipes().forEach(l -> {
                List runtimeVersions = recipesVersions.qVersions().stream().filter(v -> v[1].startsWith(l.version())).collect(Collectors.toList());
                runtimeVersions.sort(Comparator.comparing(o -> o[1]));
                String[] runtimeVersion = (String[])runtimeVersions.get(runtimeVersions.size() - 1);
                Object quarkusVersion = runtimeVersion[1];
                quarkusVersion = ((String)quarkusVersion).substring(0, ((String)quarkusVersion).lastIndexOf(46)) + ".x";
                rows.add(new Row(runtimeVersion[0], "Camel Quarkus", (String)quarkusVersion, l.description()));
            });
        }
        rows.sort(Comparator.comparing(Row::version).reversed().thenComparing(Row::runtime));
        if (this.jsonOutput) {
            this.printer().println(Jsoner.serialize(rows.stream().map(row -> Map.of("version", row.version(), "runtime", row.runtime(), "runtimeVersion", row.runtimeVersion(), "description", row.description())).collect(Collectors.toList())));
        } else {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("VERSION").minWidth(30).dataAlign(HorizontalAlign.LEFT).with(r -> r.version().toString()), new Column().header("RUNTIME").dataAlign(HorizontalAlign.LEFT).with(r -> r.runtime()), new Column().header("RUNTIME VERSION").dataAlign(HorizontalAlign.LEFT).with(r -> r.runtimeVersion()), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).with(r -> r.description()))));
        }
        return 0;
    }

    private RecipeVersions collectRecipesVersions(MavenDependencyDownloader downloader) throws ExecutionException, InterruptedException {
        CompletableFuture<List> plainCamelRecipesVersionFuture = CompletableFuture.supplyAsync(() -> downloader.resolveAvailableVersions(CAMEL_UPGRADE_GROUPID, CAMEL_UPGRADE_ARTIFACTID, FIRST_RECIPE_VERSION, this.repos));
        ArrayList<String[]> sbVersions = new ArrayList<String[]>();
        CompletableFuture<List> camelSpringBootRecipesVersionFuture = CompletableFuture.supplyAsync(() -> {
            List camelSpringBootRecipesVersion = downloader.resolveAvailableVersions(CAMEL_UPGRADE_GROUPID, CAMEL_SB_UPGRADE_ARTIFACTID, FIRST_RECIPE_VERSION, this.repos);
            if (!camelSpringBootRecipesVersion.isEmpty()) {
                sbVersions.addAll(downloader.resolveAvailableVersions("org.apache.camel.springboot", "camel-spring-boot", FIRST_RECIPE_VERSION, this.repos));
            }
            return camelSpringBootRecipesVersion;
        });
        LinkedHashSet<QuarkusUpdates> quarkusUpdateRecipes = new LinkedHashSet<QuarkusUpdates>();
        CompletableFuture<List> camelQuarkusRecipesVersionsFuture = CompletableFuture.supplyAsync(() -> {
            List camelQuarkusRecipesVersions = downloader.resolveAvailableVersions("io.quarkus", "quarkus-update-recipes", QUARKUS_FIRST_RECIPE_VERSION, this.repos);
            for (String[] camelQuarkusRecipeVersion : camelQuarkusRecipesVersions) {
                String version = camelQuarkusRecipeVersion[0];
                MavenArtifact artifact = downloader.downloadArtifact("io.quarkus", "quarkus-update-recipes", version);
                try {
                    quarkusUpdateRecipes.addAll(this.getCamelQuarkusRecipesInJar(artifact.getFile()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return camelQuarkusRecipesVersions;
        });
        CompletableFuture<List> qVersionsFuture = CompletableFuture.supplyAsync(() -> downloader.resolveAvailableVersions("org.apache.camel.quarkus", "camel-quarkus-catalog", QUARKUS_FIRST_UPDATABLE_VERSION, this.repos));
        return new RecipeVersions(plainCamelRecipesVersionFuture.get(), sbVersions, camelSpringBootRecipesVersionFuture.get(), quarkusUpdateRecipes, camelQuarkusRecipesVersionsFuture.get(), qVersionsFuture.get());
    }

    private Collection<QuarkusUpdates> getCamelQuarkusRecipesInJar(File jar) throws IOException {
        ArrayList<QuarkusUpdates> quarkusUpdateRecipes = new ArrayList<QuarkusUpdates>();
        try (JarFile jarFile = new JarFile(jar);){
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                String name = jarEntry.getName();
                if (!name.contains("quarkus-updates/org.apache.camel.quarkus/camel-quarkus/") || !name.endsWith(".yaml") || name.contains("alpha")) continue;
                String content = new String(jarFile.getInputStream(jarEntry).readAllBytes());
                String description = Arrays.stream(content.split(System.lineSeparator())).filter(l -> l.startsWith("description")).map(l -> l.substring(l.indexOf(":") + 1).trim()).findFirst().orElse("");
                quarkusUpdateRecipes.add(new QuarkusUpdates(name.substring(name.lastIndexOf("/") + 1, name.indexOf(".yaml")), description));
            }
            ArrayList<QuarkusUpdates> arrayList = quarkusUpdateRecipes;
            return arrayList;
        }
    }

    record RecipeVersions(List<String[]> plainCamelRecipesVersion, List<String[]> sbVersions, List<String[]> camelSpringBootRecipesVersion, Set<QuarkusUpdates> quarkusUpdateRecipes, List<String[]> camelQuarkusRecipesVersions, List<String[]> qVersions) {
    }

    record QuarkusUpdates(String version, String description) {
    }

    record Row(ComparableVersion version, String runtime, String runtimeVersion, String description) {
        public Row(String version, String runtime, String runtimeVersion, String description) {
            this(new ComparableVersion(version), runtime, runtimeVersion, description);
        }
    }
}

