/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessBaseCommand;
import org.apache.camel.util.StopWatch;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;

abstract class ProcessWatchCommand
extends ProcessBaseCommand {
    @CommandLine.Option(names={"--watch"}, description={"Execute periodically and showing output fullscreen"})
    boolean watch;
    private CommandHelper.ReadConsoleTask waitUserTask;

    public ProcessWatchCommand(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        int exit;
        AtomicBoolean running = new AtomicBoolean(true);
        if (this.watch) {
            Thread t = new Thread(() -> {
                this.waitUserTask = new CommandHelper.ReadConsoleTask(() -> running.set(false));
                this.waitUserTask.run();
            }, "WaitForUser");
            t.start();
            do {
                this.autoClearScreen();
                exit = this.doProcessWatchCall();
                if (exit != 0) continue;
                try {
                    StopWatch watch = new StopWatch();
                    while (running.get() && watch.taken() < 2000L) {
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    running.set(false);
                }
            } while (exit == 0 && running.get());
        } else {
            exit = this.doProcessWatchCall();
        }
        return exit;
    }

    protected void autoClearScreen() {
        this.clearScreen();
    }

    protected void clearScreen() {
        AnsiConsole.out().print((Object)Ansi.ansi().eraseScreen().cursor(1, 1));
    }

    protected abstract Integer doProcessWatchCall() throws Exception;
}

