/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="properties", description={"List configuration properties"}, sortOptions=false, showDefaultValues=true)
public class ListProperties
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameKeyCompletionCandidates.class, description={"Sort by pid, name or key"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--startup"}, description={"List only startup configuration"})
    boolean startup;
    @CommandLine.Option(names={"--verbose"}, description={"Whether to include more details"})
    boolean verbose;
    @CommandLine.Option(names={"--internal"}, description={"Whether to include internal configuration"})
    boolean internal;
    @CommandLine.Option(names={"--mask"}, description={"Whether to mask configuration values to avoid printing sensitive information such as password or access keys"}, defaultValue="true")
    boolean mask = true;

    public ListProperties(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonArray arr;
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                if (this.startup) {
                    jv = (JsonObject)root.get((Object)"main-configuration");
                    arr = (JsonArray)jv.getCollectionOrDefault("configurations", null);
                } else {
                    jv = (JsonObject)root.get((Object)"properties");
                    arr = (JsonArray)jv.getCollectionOrDefault("properties", null);
                }
                for (int i = 0; arr != null && i < arr.size(); ++i) {
                    boolean accept;
                    row = row.copy();
                    JsonObject jo = (JsonObject)arr.get(i);
                    row.key = jo.getString("key");
                    String value = jo.getString("value");
                    if (this.mask && SensitiveUtils.containsSensitive((String)row.key)) {
                        value = "xxxxxx";
                    }
                    row.value = value;
                    value = jo.getString("originalValue");
                    if (this.mask && SensitiveUtils.containsSensitive((String)row.key)) {
                        value = "xxxxxx";
                    }
                    row.originalValue = value;
                    row.internalLoc = jo.getBooleanOrDefault("internal", false);
                    row.source = jo.getString("source");
                    row.loc = ListProperties.sanitizeLocation(jo.getString("location"));
                    boolean bl = accept = this.internal || !row.internalLoc;
                    if (!accept) continue;
                    rows.add(row);
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("LOCATION").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(r -> r.loc), new Column().header("KEY").dataAlign(HorizontalAlign.LEFT).maxWidth(50, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.key), new Column().header("VALUE").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(r -> String.valueOf(r.value)), new Column().header("FUNCTION").visible(this.verbose).dataAlign(HorizontalAlign.LEFT).maxWidth(50, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getFunction), new Column().header("ORIGINAL VALUE").visible(this.verbose).dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(r -> String.valueOf(r.originalValue)))));
        }
        return 0;
    }

    protected String getFunction(Row r) {
        return StringHelper.before((String)r.source, (String)":", (String)r.source);
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "key": {
                return o1.key.compareToIgnoreCase(o2.key) * negate;
            }
        }
        return 0;
    }

    private static String sanitizeLocation(String loc) {
        if (loc == null) {
            return "";
        }
        switch (loc) {
            case "initial": 
            case "override": {
                loc = "camel-main";
                break;
            }
            case "SYS": {
                loc = "JVM System Property";
                break;
            }
            case "ENV": 
            case "env": {
                loc = "OS Environment Variable";
                break;
            }
            case "arguments": 
            case "CLI": {
                loc = "Command Line";
            }
        }
        return loc;
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String key;
        Object value;
        Object originalValue;
        String source;
        String loc;
        boolean internalLoc;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class PidNameKeyCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("pid", "name", "key").iterator();
        }
    }
}

