/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="inflight", description={"Get inflight messages of Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class ListInflight
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;

    public ListInflight(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        AtomicBoolean remoteVisible = new AtomicBoolean();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonArray arr;
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                row.uptime = ListInflight.extractSince(ph);
                row.age = TimeUtils.printSince((long)row.uptime);
                JsonObject jo = (JsonObject)root.get((Object)"inflight");
                if (jo != null && (arr = (JsonArray)jo.get((Object)"exchanges")) != null) {
                    for (int i = 0; i < arr.size(); ++i) {
                        row = row.copy();
                        jo = (JsonObject)arr.get(i);
                        row.exchangeId = jo.getString("exchangeId");
                        row.fromRouteId = jo.getString("fromRouteId");
                        Boolean bool = jo.getBoolean("fromRemoteEndpoint");
                        if (bool != null) {
                            remoteVisible.set(true);
                            row.fromRemoteEndpoint = bool;
                        }
                        row.atRouteId = jo.getString("atRouteId");
                        row.nodeId = jo.getString("nodeId");
                        row.elapsed = jo.getLong("elapsed");
                        row.duration = jo.getLong("duration");
                        rows.add(row);
                    }
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("EXCHANGE-ID").dataAlign(HorizontalAlign.LEFT).with(r -> r.exchangeId), new Column().header("REMOTE").visible(remoteVisible.get()).dataAlign(HorizontalAlign.CENTER).with(this::getRemote), new Column().header("ROUTE").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.atRouteId), new Column().header("ID").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.nodeId), new Column().header("ELAPSED").dataAlign(HorizontalAlign.RIGHT).with(this::getElapsed), new Column().header("DURATION").dataAlign(HorizontalAlign.RIGHT).with(this::getDuration))));
        }
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    private String getDuration(Row r) {
        return TimeUtils.printDuration((long)r.duration);
    }

    private String getElapsed(Row r) {
        return TimeUtils.printDuration((long)r.elapsed);
    }

    private String getRemote(Row r) {
        return r.fromRemoteEndpoint ? "x" : "";
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String age;
        long uptime;
        String exchangeId;
        String fromRouteId;
        boolean fromRemoteEndpoint;
        String atRouteId;
        String nodeId;
        long elapsed;
        long duration;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

