/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="endpoint", description={"Get usage of Camel endpoints"}, sortOptions=false, showDefaultValues=true)
public class ListEndpoint
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeTotalCompletionCandidates.class, description={"Sort by pid, name, age or total"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--limit"}, description={"Filter endpoints by limiting to the given number of rows"})
    int limit;
    @CommandLine.Option(names={"--filter"}, description={"Filter endpoints by URI"})
    String filter;
    @CommandLine.Option(names={"--filter-direction"}, description={"Filter by direction (in or out)"})
    String filterDirection;
    @CommandLine.Option(names={"--filter-total"}, description={"Filter endpoints that must be higher than the given usage"})
    long filterTotal;
    @CommandLine.Option(names={"--short-uri"}, description={"List endpoint URI without query parameters (short)"})
    boolean shortUri;
    @CommandLine.Option(names={"--wide-uri"}, description={"List endpoint URI in full details"})
    boolean wideUri;

    public ListEndpoint(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        if (this.filter != null && !this.filter.endsWith("*")) {
            this.filter = this.filter + "*";
        }
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject context = (JsonObject)root.get((Object)"context");
                JsonObject jo = (JsonObject)root.get((Object)"endpoints");
                if (context != null && jo != null) {
                    JsonArray array = (JsonArray)jo.get((Object)"endpoints");
                    for (int i = 0; i < array.size(); ++i) {
                        JsonObject o = (JsonObject)array.get(i);
                        Row row = new Row();
                        row.name = context.getString("name");
                        if ("CamelJBang".equals(row.name)) {
                            row.name = ProcessHelper.extractName(root, ph);
                        }
                        row.pid = Long.toString(ph.pid());
                        row.endpoint = o.getString("uri");
                        row.stub = o.getBooleanOrDefault("stub", false);
                        row.remote = o.getBooleanOrDefault("remote", true);
                        row.direction = o.getString("direction");
                        row.total = o.getString("hits");
                        row.uptime = ListEndpoint.extractSince(ph);
                        row.age = TimeUtils.printSince((long)row.uptime);
                        boolean add = true;
                        if (this.filterTotal > 0L && (row.total == null || Long.parseLong(row.total) < this.filterTotal)) {
                            add = false;
                        }
                        if (this.filterDirection != null && !this.filterDirection.equals(row.direction)) {
                            add = false;
                        }
                        if (this.filter != null) {
                            String f = this.filter;
                            boolean negate = this.filter.startsWith("-");
                            if (negate) {
                                f = f.substring(1);
                            }
                            boolean match = PatternHelper.matchPattern((String)row.endpoint, (String)f);
                            if (negate) {
                                boolean bl = match = !match;
                            }
                            if (!match) {
                                add = false;
                            }
                        }
                        if (this.limit > 0 && rows.size() >= this.limit) {
                            add = false;
                        }
                        if (!add) continue;
                        rows.add(row);
                    }
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printTable(rows);
        }
        return 0;
    }

    protected void printTable(List<Row> rows) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.age), new Column().header("DIR").with(r -> r.direction), new Column().header("TOTAL").with(r -> r.total), new Column().header("STUB").dataAlign(HorizontalAlign.CENTER).with(r -> r.stub ? "x" : ""), new Column().header("REMOTE").dataAlign(HorizontalAlign.CENTER).with(r -> r.remote ? "x" : ""), new Column().header("URI").visible(!this.wideUri).dataAlign(HorizontalAlign.LEFT).maxWidth(90, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getUri), new Column().header("URI").visible(this.wideUri).dataAlign(HorizontalAlign.LEFT).maxWidth(140, OverflowBehaviour.NEWLINE).with(this::getUri))));
    }

    private String getUri(Row r) {
        int pos;
        String u = r.endpoint;
        if (this.shortUri && (pos = u.indexOf(63)) > 0) {
            u = u.substring(0, pos);
        }
        return u;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
            case "total": {
                return Long.compare(Long.parseLong(o1.total), Long.parseLong(o2.total)) * negate;
            }
        }
        return 0;
    }

    static class Row {
        String pid;
        String name;
        long uptime;
        String age;
        String endpoint;
        String direction;
        String total;
        boolean stub;
        boolean remote;

        Row() {
        }
    }

    public static class PidNameAgeTotalCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("pid", "name", "age", "total").iterator();
        }
    }
}

